# 機能設計書 130-プロジェクト設定（Configure）

## 概要

本ドキュメントは、TensorFlowのプロジェクト設定（Configure）機能の機能設計を記述する。TensorFlowのビルド設定・環境検出スクリプト（configure.py）を提供し、ビルドに必要な各種設定を対話的またはバッチ的に構成する。

### 本機能の処理概要

**業務上の目的・背景**：TensorFlowはC++/Python/CUDAなど複数の言語・プラットフォームにまたがる大規模プロジェクトであり、ビルドに必要な設定項目（Pythonパス、CUDA設定、Android NDK設定等）が多岐にわたる。configure.pyはこれらの設定をユーザから取得し、Bazelビルドシステム用の設定ファイル（.tf_configure.bazelrc）を生成する。

**機能の利用シーン**：TensorFlowをソースからビルドする際の初期設定。新しい開発環境のセットアップ時、CUDA/GPUサポートの有効化・無効化、Android/iOSクロスコンパイル設定時に使用される。

**主要な処理内容**：
1. Pythonインタプリタのパス検出と設定
2. CUDA/cuDNN/TensorRT/NCCLの有効化と各種パスの設定
3. CUDAコンピュート能力の指定
4. Android NDK/SDKの検出と設定
5. Apple（iOS/macOS）ビルド設定
6. ROCm（AMD GPU）サポートの設定
7. Bazelビルド設定ファイル（.tf_configure.bazelrc）の生成

**関連システム・外部連携**：Bazelビルドシステム、CUDA Toolkit、cuDNN、NCCL、TensorRT、Android NDK/SDK。

**権限による制御**：ファイルシステムへの書き込み権限が必要（.tf_configure.bazelrcの生成）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はコマンドラインツールであり、直接関連するGUI画面はない |

## 機能種別

設定管理（ビルド環境の構成）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| PYTHON_BIN_PATH | string | Yes | Pythonバイナリのパス | ファイル存在・実行権限チェック |
| TF_NEED_CUDA | 0/1 | No | CUDAサポートの有無 | デフォルトは対話入力 |
| CUDA_TOOLKIT_PATH | string | No | CUDAツールキットのパス | CUDA有効時に必要 |
| CUDNN_INSTALL_PATH | string | No | cuDNNのインストールパス | CUDA有効時に必要 |
| TF_CUDA_COMPUTE_CAPABILITIES | string | No | CUDAコンピュート能力 | デフォルト 3.5,7.0 |
| ANDROID_NDK_HOME | string | No | Android NDKのパス | Android有効時に必要 |
| ANDROID_SDK_HOME | string | No | Android SDKのパス | Android有効時に必要 |
| TF_NEED_ROCM | 0/1 | No | ROCmサポートの有無 | - |
| NCCL_INSTALL_PATH | string | No | NCCLのインストールパス | NCCL有効時に必要 |

### 入力データソース

環境変数、対話的ユーザ入力（stdin）、またはコマンドライン引数。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| .tf_configure.bazelrc | ファイル | Bazelビルド設定ファイル |
| 各種シンボリックリンク | ファイル | Python/CUDA関連のシンボリックリンク |

### 出力先

プロジェクトルートディレクトリに.tf_configure.bazelrcを生成。

## 処理フロー

### 処理シーケンス

```
1. 既存設定ファイルのリセット
   └─ .tf_configure.bazelrcを初期化
2. Python環境の設定
   └─ PYTHON_BIN_PATHの検出、Pythonバージョン・サイトパッケージの取得
3. プラットフォーム検出
   └─ Windows/Linux/macOS/Cygwin の判定
4. CUDAサポートの設定（有効な場合）
   └─ CUDA Toolkit、cuDNN、NCCL、TensorRTのパスと設定
5. ROCmサポートの設定（有効な場合）
   └─ ROCmのパスと設定
6. Android/iOSの設定（有効な場合）
   └─ NDK/SDKのパス、APIレベル設定
7. Bazel設定ファイルの書き出し
   └─ build --action_env形式で設定を書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[configure.py 実行] --> B[.tf_configure.bazelrc初期化]
    B --> C[Python環境設定]
    C --> D{CUDA有効?}
    D -->|Yes| E[CUDA/cuDNN/NCCL設定]
    D -->|No| F{ROCm有効?}
    E --> F
    F -->|Yes| G[ROCm設定]
    F -->|No| H{Android有効?}
    G --> H
    H -->|Yes| I[Android NDK/SDK設定]
    H -->|No| J[.tf_configure.bazelrc書き出し]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-130-1 | デフォルトPython | sys.executableをデフォルトのPythonパスとして使用 | PYTHON_BIN_PATH未設定時 |
| BR-130-2 | CUDAデフォルト | CUDAコンピュート能力のデフォルトは3.5,7.0 | TF_CUDA_COMPUTE_CAPABILITIES未設定時 |
| BR-130-3 | Android NDKバージョン | サポートされるNDKバージョンは19, 20, 21, 25 | Android有効時 |
| BR-130-4 | NCCLパス検索 | lib64/, lib/powerpc64le-linux-gnu/, lib/x86_64-linux-gnu/, ''の順に検索 | NCCL有効時 |
| BR-130-5 | Apple設定 | iOS/macOS関連のBUILDファイルの設定 | macOSプラットフォーム時 |
| BR-130-6 | 入力リトライ | ユーザ入力は最大10回まで試行 | 対話入力時 |

### 計算ロジック

ビルド設定の組み合わせ判定。`build --action_env`および`build --config`ディレクティブの生成。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。ファイルシステムへの書き込みのみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| UserInputError | 入力エラー | 無効なユーザ入力が規定回数を超えた | 正しい値を入力 |
| FileNotFoundError | ファイルエラー | 指定されたパスにファイルが存在しない | 正しいパスを指定 |
| PermissionError | 権限エラー | .tf_configure.bazelrcの書き込み権限がない | ファイル権限を確認 |
| subprocess.CalledProcessError | コマンドエラー | 外部コマンドの実行に失敗 | 環境のセットアップを確認 |

### リトライ仕様

対話入力は最大10回（_DEFAULT_PROMPT_ASK_ATTEMPTS）までリトライ。

## トランザクション仕様

トランザクション管理なし。.tf_configure.bazelrcは追記モードで書き込み。

## パフォーマンス要件

ビルド前の1回限りの設定操作であり、パフォーマンス要件は特にない。

## セキュリティ考慮事項

- 外部コマンド（subprocess）の実行を行うため、入力パスのバリデーションが重要
- .tf_configure.bazelrcにパス情報が記録されるため、機密パスの取り扱いに注意

## 備考

- Python 2/3の両方に対応（raw_input / input の互換処理）
- シンボリックリンク作成時は既存リンクを強制的に上書き（symlink_force）
- Cygwin環境のパス変換サポート（cygpath）
- 環境変数またはユーザ対話入力のどちらからでも設定値を取得可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 全体構造を理解する

configure.pyの先頭でグローバル定数とユーティリティ関数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configure.py | `configure.py` | グローバル定数と基本ユーティリティ |

**読解のコツ**: configure.pyは単一のPythonスクリプトで、対話的にビルド設定を構成する。`_DEFAULT_CUDA_COMPUTE_CAPABILITIES`、`_SUPPORTED_ANDROID_NDK_VERSIONS`などのグローバル定数が設定のデフォルト値を定義している。

#### Step 2: プラットフォーム検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | configure.py | `configure.py` | プラットフォーム判定関数群 |

**主要処理フロー**:
1. **61-62行目**: is_windows() - platform.system() == 'Windows'
2. **65-66行目**: is_linux() - platform.system() == 'Linux'
3. **69-70行目**: is_macos() - platform.system() == 'Darwin'
4. **73-74行目**: is_ppc64le() - platform.machine() == 'ppc64le'
5. **77-78行目**: is_s390x() - platform.machine() == 's390x'
6. **81-82行目**: is_cygwin() - CYGWIN_NT判定

#### Step 3: ユーティリティ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | configure.py | `configure.py` | 入力取得・ファイル操作・シェルコマンド |

**主要処理フロー**:
- **85-93行目**: get_input() - Python 2/3互換のユーザ入力取得
- **96-110行目**: symlink_force() - 強制的なシンボリックリンク作成
- **113-115行目**: write_to_bazelrc() - .tf_configure.bazelrcへの追記
- **118-119行目**: write_action_env_to_bazelrc() - action_env形式での設定書き込み
- **128-138行目**: run_shell() - 外部コマンド実行

#### Step 4: Python環境設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | configure.py | `configure.py` | setup_python関数 |

**主要処理フロー**:
- **146-175行目**: get_python_path() - Pythonサイトパッケージのパス取得
- **183-199行目**: setup_python() - Pythonバイナリパスの設定と検証

### プログラム呼び出し階層図

```
configure.py (メインスクリプト)
    |
    +-- プラットフォーム検出
    |     +-- is_windows() / is_linux() / is_macos() / is_cygwin()
    |
    +-- ユーティリティ
    |     +-- get_input() ... ユーザ入力取得
    |     +-- write_to_bazelrc() ... 設定ファイル書き込み
    |     +-- run_shell() ... 外部コマンド実行
    |     +-- symlink_force() ... シンボリックリンク作成
    |
    +-- Python設定
    |     +-- setup_python()
    |     +-- get_python_path()
    |     +-- get_python_major_version()
    |
    +-- CUDA設定
    |     +-- (CUDA/cuDNN/NCCL/TensorRTパス設定)
    |
    +-- Android設定
    |     +-- (NDK/SDK検出・設定)
    |
    +-- 出力
          +-- .tf_configure.bazelrc生成
```

### データフロー図

```
[入力]                    [処理]                    [出力]

環境変数 ──────────┐
                    ├──▶ configure.py ──────▶ .tf_configure.bazelrc
ユーザ対話入力 ───┘      (設定収集・検証)        (Bazelビルド設定)
                              |
                              +────────────▶ シンボリックリンク
                                              (Python/CUDA関連)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| configure.py | `configure.py` | ソース | メインの設定スクリプト |
| .tf_configure.bazelrc | `.tf_configure.bazelrc` | 設定 | 生成されるBazelビルド設定 |
| tensorflow/lite/ios/BUILD | `tensorflow/lite/ios/BUILD` | 設定 | iOS向けビルド設定（Apple環境で設定） |
| tensorflow/lite/objc/BUILD | `tensorflow/lite/objc/BUILD` | 設定 | Objective-C向けビルド設定 |
| tensorflow/lite/swift/BUILD | `tensorflow/lite/swift/BUILD` | 設定 | Swift向けビルド設定 |
