# 機能設計書 144-継続的インテグレーション

## 概要

本ドキュメントは、TensorFlowの継続的インテグレーション（CI）機能（`ci/`）の設計を記載する。CI機能は、TensorFlowのコード変更に対するビルド・テスト・デプロイの自動化を提供し、コード品質と安定性を維持するための基盤を構成する。

### 本機能の処理概要

**業務上の目的・背景**：TensorFlowは巨大なコードベース（数百万行のC++、Python、その他言語のコード）を持ち、多数のコントリビューターが並行して変更を行っている。コード変更のたびに手動でビルド・テストを行うことは現実的でなく、自動化されたCI/CDパイプラインが不可欠である。CI機能は、コード変更の検証、ビルドの自動化、テストの実行、成果物のデプロイを効率的に行うための設定・スクリプト群を提供する。

**機能の利用シーン**：
- プルリクエスト（PR）提出時の自動ビルド・テスト実行
- コード変更のリグレッション検出
- TensorFlowリリースビルドの自動生成
- Wheelパッケージの生成・アップロード
- libtensorflow（C API共有ライブラリ）のビルド
- コードスタイルチェックの自動実行
- デリゲート性能ベンチマークの実行

**主要な処理内容**：
1. ビルドスクリプト（Bazelベースのビルド自動化）
2. テストスクリプト（Python/C++テストの自動実行）
3. Wheelパッケージの生成・インストール検証
4. libtensorflowの生成
5. コードチェック（変更ファイルまたはフル対象）
6. Docker環境の管理
7. 環境設定ファイルの管理（各OS/GPU/Python バージョンの組み合わせ）
8. 成果物のアップロード
9. デバッグ・二分探索スクリプト

**関連システム・外部連携**：Bazelビルドシステム、Docker、GitHub Actions/Kokoro CI、PyPI（Wheelアップロード）、Google Cloud Storage

**権限による制御**：CIスクリプトの実行はCI環境の権限に依存。リリースビルドの成果物アップロードはTensorFlow DevInfraチームの権限。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はCI/CD基盤であり、画面との直接の関連はない |

## 機能種別

ビルド・テスト自動化 / CI/CD基盤

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TFCI_* 環境変数 | 文字列 | Yes (CI実行時) | CI設定パラメータ（ビルド種別、Python版等） | envs/配下の設定ファイルで定義 |
| ソースコード | ディレクトリ | Yes | ビルド対象のTensorFlowソースツリー | git clean状態であること |
| Docker イメージ | Docker設定 | No | ビルド環境のDockerイメージ指定 | Dockerfile存在確認 |

### 入力データソース

- GitHubリポジトリのソースコード
- CI環境の環境変数（envs/配下のenv設定ファイル）
- Docker Hub / Google Container Registry上のベースイメージ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Wheelパッケージ | .whl ファイル | TensorFlow Pythonパッケージ |
| libtensorflow | .so / .dylib / .dll | TensorFlow C API共有ライブラリ |
| テスト結果 | JUnit XML / ログ | ビルド・テストの成功/失敗レポート |
| コードチェック結果 | テキスト | スタイルチェック・lint結果 |

### 出力先

- CIジョブの成果物ストレージ
- PyPI（リリース時のWheelアップロード）
- Google Cloud Storage（ナイトリービルド）

## 処理フロー

### 処理シーケンス

```
1. 環境準備
   ├─ Docker環境の構築（devinfra/docker/）
   └─ 環境変数の設定（envs/配下の設定ファイル読み込み）
2. コードチェック
   ├─ code_check_changed_files.sh（変更ファイルのみ対象）
   └─ code_check_full.sh（全ファイル対象）
3. ビルド
   ├─ any.sh（汎用ビルドスクリプト）
   ├─ pycpp.sh（Python/C++ビルド）
   └─ wheel.sh（Wheelパッケージ生成）
4. テスト
   ├─ Bazelテスト実行
   └─ Wheelインストール検証（installer_wheel.sh）
5. 成果物処理
   ├─ upload.sh（成果物アップロード）
   └─ libtensorflow.sh（C APIライブラリ生成）
```

### フローチャート

```mermaid
flowchart TD
    A[コード変更/PR] --> B[CI環境準備]
    B --> C[コードチェック]
    C --> D{チェック通過?}
    D -->|No| E[エラー報告]
    D -->|Yes| F[Bazelビルド]
    F --> G{ビルド成功?}
    G -->|No| E
    G -->|Yes| H[テスト実行]
    H --> I{テスト通過?}
    I -->|No| E
    I -->|Yes| J[成果物生成]
    J --> K[Wheel/libtensorflow]
    K --> L{リリースビルド?}
    L -->|Yes| M[アップロード]
    L -->|No| N[完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-144-01 | ビルド環境分離 | CIビルドはDocker環境内で実行し、ホスト環境への影響を防止する | 全CIジョブ |
| BR-144-02 | 環境マトリクス | 複数のOS/GPU/Pythonバージョンの組み合わせでテストを実行 | PR/リリース時 |
| BR-144-03 | コードチェック必須 | PRに対してコードスタイルチェックが必須 | PR提出時 |
| BR-144-04 | 成果物アーカイブ | ビルド成果物は所定のストレージにアーカイブする | リリースビルド時 |

### 計算ロジック

該当なし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | コンパイルエラー、依存関係エラー | ソースコードの修正 |
| - | テスト失敗 | テストケースの失敗 | テストまたはソースコードの修正 |
| - | コードチェック違反 | スタイルガイド違反 | コードフォーマットの修正 |
| - | 環境エラー | Dockerビルド失敗、依存ライブラリ不在 | CI環境設定の修正 |

### リトライ仕様

CI環境によっては、一時的な障害（ネットワークエラー等）に対するジョブ再実行機能が提供される。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- CIジョブは合理的な時間内（通常数時間以内）に完了すること
- 並列テスト実行によるテスト時間の短縮

## セキュリティ考慮事項

- CIスクリプトは認証情報を環境変数経由で受け取り、ログに出力しないよう注意
- 成果物アップロードにはアクセス制御が適用される
- 外部コントリビューターのPRに対するCIは限定的な権限で実行される

## 備考

- CIディレクトリは「still under construction」の警告あり、構造は今後変更される可能性がある
- メンテナ: TensorFlow DevInfra チーム
- `ci/official/` 配下に公式CIスクリプト、`ci/devinfra/` 配下にDevInfra固有のDocker設定が格納

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: CI全体の構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | README.md | `ci/README.md` | CIディレクトリの概要。構築中であることの注意事項。メンテナがTensorFlow DevInfraであること |
| 1-2 | README.md | `ci/official/README.md` | 公式CIスクリプトの詳細説明 |

**読解のコツ**: `ci/` は3つのサブディレクトリ（`official/`、`devinfra/`、`README.md`）に分かれている。`official/` が主要なCIスクリプト群であり、ここから読み始めるのが効率的。

#### Step 2: 公式CIスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | any.sh | `ci/official/any.sh` | 汎用ビルドスクリプト。環境変数に基づいてビルドを実行 |
| 2-2 | wheel.sh | `ci/official/wheel.sh` | Wheelパッケージの生成スクリプト。Bazelビルド、パッケージング、テストの一連の流れ |
| 2-3 | pycpp.sh | `ci/official/pycpp.sh` | Python/C++のビルド・テストスクリプト |
| 2-4 | libtensorflow.sh | `ci/official/libtensorflow.sh` | libtensorflow（C API共有ライブラリ）の生成 |
| 2-5 | installer_wheel.sh | `ci/official/installer_wheel.sh` | Wheelのインストール検証スクリプト |
| 2-6 | upload.sh | `ci/official/upload.sh` | 成果物のアップロードスクリプト |

#### Step 3: コードチェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | code_check_changed_files.sh | `ci/official/code_check_changed_files.sh` | 変更ファイルのみを対象としたコードチェック |
| 3-2 | code_check_full.sh | `ci/official/code_check_full.sh` | 全ファイルを対象としたコードチェック |

#### Step 4: 環境設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | envs/ | `ci/official/envs/` | 各ビルド環境の設定ファイル群（OS/GPU/Pythonバージョンの組み合わせ） |

#### Step 5: Docker環境を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | docker/ | `ci/devinfra/docker/` | DevInfra固有のDocker設定 |
| 5-2 | containers/ | `ci/official/containers/` | 公式CIのコンテナ設定 |

#### Step 6: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | utilities/ | `ci/official/utilities/` | 共通ユーティリティスクリプト群 |
| 6-2 | bisect.sh | `ci/official/bisect.sh` | リグレッション二分探索スクリプト |
| 6-3 | debug_tfci.sh | `ci/official/debug_tfci.sh` | CIデバッグスクリプト |

### プログラム呼び出し階層図

```
CI実行環境（GitHub Actions / Kokoro）
    |
    +-- ci/official/any.sh (汎用エントリーポイント)
    |       +-- envs/ (環境設定読み込み)
    |       +-- utilities/ (共通ユーティリティ)
    |
    +-- ci/official/wheel.sh (Wheelビルド)
    |       +-- bazel build //tensorflow/tools/pip_package:wheel
    |       +-- installer_wheel.sh (インストール検証)
    |       +-- upload.sh (成果物アップロード)
    |
    +-- ci/official/pycpp.sh (Python/C++テスト)
    |       +-- bazel test ...
    |
    +-- ci/official/libtensorflow.sh (C APIライブラリ)
    |       +-- bazel build //tensorflow/c:libtensorflow
    |
    +-- ci/official/code_check_*.sh (コードチェック)
    |
    +-- ci/official/bisect.sh (二分探索)
    |
    +-- ci/devinfra/docker/ (Docker環境)
```

### データフロー図

```
[入力]                          [処理]                        [出力]

GitHub PR/コミット ---------> CI環境準備 ---------> Docker環境
                                 |
ソースコード + envs/ -------> Bazelビルド --------> ビルド成果物
                                 |
ビルド成果物 ----------------> テスト実行 ---------> テスト結果
                                 |
テスト済み成果物 ------------> Wheel/lib生成 ------> .whl / .so
                                 |
パッケージ ------------------> アップロード -------> PyPI / GCS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| README.md | `ci/README.md` | ドキュメント | CIディレクトリの概要 |
| README.md | `ci/official/README.md` | ドキュメント | 公式CIスクリプトの説明 |
| any.sh | `ci/official/any.sh` | スクリプト | 汎用ビルドエントリーポイント |
| wheel.sh | `ci/official/wheel.sh` | スクリプト | Wheelパッケージ生成 |
| pycpp.sh | `ci/official/pycpp.sh` | スクリプト | Python/C++ビルド・テスト |
| libtensorflow.sh | `ci/official/libtensorflow.sh` | スクリプト | libtensorflowビルド |
| installer_wheel.sh | `ci/official/installer_wheel.sh` | スクリプト | Wheelインストール検証 |
| upload.sh | `ci/official/upload.sh` | スクリプト | 成果物アップロード |
| code_check_changed_files.sh | `ci/official/code_check_changed_files.sh` | スクリプト | 変更ファイルコードチェック |
| code_check_full.sh | `ci/official/code_check_full.sh` | スクリプト | フルコードチェック |
| bisect.sh | `ci/official/bisect.sh` | スクリプト | リグレッション二分探索 |
| debug_tfci.sh | `ci/official/debug_tfci.sh` | スクリプト | CIデバッグ |
| envs/ | `ci/official/envs/` | 設定 | 環境設定ファイル群 |
| utilities/ | `ci/official/utilities/` | スクリプト | 共通ユーティリティ |
| containers/ | `ci/official/containers/` | 設定 | コンテナ設定 |
| requirements_updater/ | `ci/official/requirements_updater/` | スクリプト | 依存関係更新ツール |
| docker/ | `ci/devinfra/docker/` | 設定 | DevInfra Docker設定 |
| README.md | `ci/devinfra/README.md` | ドキュメント | DevInfra説明 |
