# 機能設計書 145-開発者ツール

## 概要

本ドキュメントは、TensorFlowの開発者ツール（`tools/`）の機能設計を記載する。開発者ツールは、TensorFlowの開発・デバッグ・問題報告を支援するユーティリティスクリプト群を提供する。現在の主要ツールは、環境情報収集スクリプト `tf_env_collect.sh` であり、バグ報告時に必要なシステム環境情報を自動的に収集する。

### 本機能の処理概要

**業務上の目的・背景**：TensorFlowはPython、CUDA、cuDNN、OS、コンパイラ等の多数の依存関係を持ち、問題報告時に正確な環境情報を提供することが問題の迅速な特定と解決に不可欠である。`tf_env_collect.sh` は、ユーザーの環境情報を自動的に収集し、GitHub Issueテンプレートに必要なフィールドを埋めるための情報をファイルに出力する。

**機能の利用シーン**：
- TensorFlowの問題をGitHub Issueとして報告する際に環境情報を収集
- TensorFlowのインストール問題のデバッグ
- CUDA/cuDNNの検出状況の確認
- 仮想環境の確認

**主要な処理内容**：
1. Pythonバージョン・ビルド情報の収集
2. OSプラットフォーム情報の収集（OS種別、カーネルバージョン、アーキテクチャ等）
3. Docker環境の検出
4. C++コンパイラの確認
5. pip パッケージ情報の収集（tensorflow、numpy、protobuf等）
6. 仮想環境の検出
7. TensorFlowのインポートテスト（バージョン、コンパイラバージョン、基本動作確認）
8. cuDNN/CUDAライブラリの検出
9. 環境変数（LD_LIBRARY_PATH、DYLD_LIBRARY_PATH）の確認
10. NVIDIA GPU情報の収集（nvidia-smi）
11. TensorFlow/tf_nightlyのインストール情報確認
12. Bazelバージョンの確認

**関連システム・外部連携**：Python実行環境、CUDA/cuDNN、Docker、pip、Bazel、OS環境

**権限による制御**：スクリプト実行権限。GPUデバイス情報の取得にはGPUドライバへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はCLIツールであり、画面との直接の関連はない |

## 機能種別

CLIツール / 開発支援ユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (なし) | - | - | パラメータなし。スクリプトを直接実行するのみ | Python実行環境が存在すること |

### 入力データソース

- システム環境変数
- Python実行環境
- pip パッケージ情報
- OS情報（/proc/、platform モジュール等）
- GPU情報（nvidia-smi）
- CUDA/cuDNNライブラリファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tf_env.txt | テキストファイル | 収集された環境情報一式 |

### 出力先

- カレントディレクトリの `tf_env.txt` ファイル

### 出力内容の詳細

出力ファイルには以下のセクションが含まれる：

| セクション | 内容 |
|-----------|------|
| check python | Pythonバージョン、ブランチ、ビルドバージョン、コンパイラ、実装 |
| check os platform | OS種別、カーネルバージョン、リリースバージョン、アーキテクチャ等 |
| are we in docker | Docker環境内かの判定結果 |
| c++ compiler | C++コンパイラのパスとバージョン |
| check pips | tensorflow/numpy/protobuf等の関連パッケージバージョン |
| check for virtualenv | 仮想環境内かの判定結果 |
| tensorflow import | TensorFlowバージョン、GITバージョン、コンパイラバージョン、基本動作テスト |
| env | LD_LIBRARY_PATH、DYLD_LIBRARY_PATHの値 |
| nvidia-smi | GPUデバイス情報 |
| cuda libs | CUDA/cuDNNライブラリの検出結果 |
| tensorflow installation | tensorflow pip パッケージの詳細情報 |
| tf_nightly installation | tf_nightly pip パッケージの詳細情報 |
| python version | Python詳細バージョン（major, minor, micro, releaselevel, serial） |
| bazel version | Bazelビルドツールのバージョン |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ Pythonバイナリのパスを検出（python または python3）
2. 情報収集（順次実行）
   ├─ Python情報の収集（platform モジュール経由）
   ├─ OS情報の収集（platform モジュール経由）
   ├─ Docker環境の検出（/proc/1/cgroup確認）
   ├─ C++コンパイラの確認（which c++ && c++ --version）
   ├─ pipパッケージの収集（pip list | grep）
   ├─ 仮想環境の検出（sys.real_prefix / sys.base_prefix確認）
   ├─ TensorFlowインポートテスト（import tensorflow as tf）
   ├─ cuDNNライブラリの検出（LD_DEBUG経由）
   ├─ 環境変数の確認
   ├─ nvidia-smi実行
   ├─ CUDAライブラリの検索（find /usr -name 'libcud*'）
   ├─ tensorflow/tf_nightly pip show実行
   ├─ Pythonバージョン詳細
   └─ Bazelバージョン
3. 出力
   └─ 全情報を tf_env.txt に書き出し（Googleを含む行はフィルタ）
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[Pythonパス検出]
    B --> C{Python見つかった?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[Python情報収集]
    E --> F[OS情報収集]
    F --> G[Docker検出]
    G --> H[C++コンパイラ確認]
    H --> I[pip パッケージ収集]
    I --> J[仮想環境検出]
    J --> K[TensorFlowインポートテスト]
    K --> L[GPU/CUDA情報収集]
    L --> M[Bazelバージョン確認]
    M --> N[tf_env.txtに出力]
    N --> O[完了メッセージ表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-145-01 | Pythonバイナリ検出 | `python` または `python3` のいずれかが利用可能であること。両方見つからない場合はエラー終了 | スクリプト開始時 |
| BR-145-02 | Google情報除外 | 出力ファイルからGoogleを含む行をフィルタリング（プライバシー配慮） | 出力時 |
| BR-145-03 | 環境変数安全性 | 未定義の環境変数参照でエラーにならないよう `set -u` とデフォルト値処理を組み合わせ | 環境変数確認時 |

### 計算ロジック

該当なし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | Python未検出 | pythonもpython3も見つからない | Pythonをインストール |
| - | nvidia-smi不在 | GPUドライバ未インストール | GPUドライバのインストール（オプション） |
| - | TensorFlowインポート失敗 | TensorFlow未インストール | TensorFlowのインストール |
| - | Bazel不在 | Bazel未インストール | Bazelのインストール（ソースビルド用） |

### リトライ仕様

リトライ機構はない。各セクションで失敗しても他のセクションの収集は継続される。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- スクリプトは通常数秒から数十秒で完了すること
- TensorFlowのインポートテストが最も時間を要する処理

## セキュリティ考慮事項

- 出力ファイルにはシステムのパス情報が含まれるため、公開時は機密パスの確認が必要
- Googleを含む行のフィルタリングにより、Google内部のパス情報が除外される
- nvidia-smiの出力にはGPUシリアル番号等の情報が含まれる可能性がある

## 備考

- `tools/` ディレクトリには現在 `tf_env_collect.sh` のみが格納されている
- 以前のバージョンでは追加のツールが存在していた可能性があるが、現在のリポジトリでは単一ファイルのみ
- 出力ファイル名は固定で `tf_env.txt`

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: スクリプト全体構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tf_env_collect.sh | `tools/tf_env_collect.sh` | スクリプト全体（195行）。`set -u` でundefined変数チェック有効化（17行目）。`die()` ヘルパー関数（19-27行目）。`print_header()` 出力フォーマット関数（38-51行目） |

**読解のコツ**: Bashスクリプトの全体構造は大きなブレースグループ `{ ... }` で囲まれ（56-187行目）、パイプでフィルタ処理（`grep -v -i google`）してから出力ファイルにリダイレクトされる。各セクションは `print_header` で区切られている。

#### Step 2: 各情報収集セクションを理解する

| 順序 | セクション | 行番号 | 読解ポイント |
|-----|-----------|--------|-------------|
| 2-1 | Python情報 | 57-68行目 | `platform` モジュールを使ってPythonバージョン、ブランチ、ビルド情報、コンパイラ、実装を収集 |
| 2-2 | OS情報 | 70-94行目 | `platform` モジュールの各関数を動的に呼び出し（`getattr`使用）。`PLATFORM_ENTRIES` リストで収集項目を定義 |
| 2-3 | Docker検出 | 97-102行目 | `/proc/1/cgroup` ファイルに "docker" が含まれるかで判定 |
| 2-4 | C++コンパイラ | 104-109行目 | `which c++` と `c++ --version` で確認 |
| 2-5 | pip パッケージ | 111-112行目 | `pip list` の出力から `proto|numpy|tensorflow|tf_nightly` をフィルタ |
| 2-6 | 仮想環境検出 | 116-123行目 | `sys.real_prefix` または `sys.base_prefix != sys.prefix` で判定 |
| 2-7 | TensorFlowインポート | 125-135行目 | `import tensorflow as tf` でバージョン情報取得、`tf.constant([1,2,3])[:1]` で基本動作テスト |
| 2-8 | cuDNN検出 | 138-143行目 | `LD_DEBUG=libs` でライブラリロードをトレースし、`libcudnn` の存在を確認 |
| 2-9 | 環境変数 | 145-158行目 | `LD_LIBRARY_PATH` と `DYLD_LIBRARY_PATH` の確認。`set -u` との互換性のため `${VAR+x}` 構文を使用 |
| 2-10 | nvidia-smi | 161-162行目 | `nvidia-smi` コマンドの実行（不在時はエラーメッセージが出力される） |
| 2-11 | CUDAライブラリ検索 | 164-167行目 | `/usr` 配下でcudart/cudnnライブラリファイルを検索 |
| 2-12 | TF pip情報 | 169-177行目 | `pip show tensorflow` と `pip show tf_nightly` の実行 |
| 2-13 | Pythonバージョン詳細 | 179-181行目 | `sys.version_info[:]` でタプル形式の詳細バージョン |
| 2-14 | Bazelバージョン | 183-184行目 | `bazel version` コマンドの実行 |

#### Step 3: 出力処理を理解する

| 順序 | 行番号 | 読解ポイント |
|-----|--------|-------------|
| 3-1 | 31行目 | 出力ファイル名 `OUTPUT_FILE=tf_env.txt` の定義 |
| 3-2 | 54行目 | 出力ファイルの初期化（`echo > "$OUTPUT_FILE"`） |
| 3-3 | 187行目 | Googleを含む行のフィルタリング（`grep -v -i google >> "$OUTPUT_FILE"`） |
| 3-4 | 189-194行目 | ユーザーへの完了メッセージ表示 |

### プログラム呼び出し階層図

```
tf_env_collect.sh
    |
    +-- die() [19-27行目] (エラー時のメッセージ出力と終了)
    |
    +-- print_header() [38-51行目] (セクションヘッダ出力)
    |
    +-- Python情報収集 [57-68行目]
    |       +-- python -c "import platform; ..."
    |
    +-- OS情報収集 [70-94行目]
    |       +-- python -c "import platform; ..."
    |
    +-- Docker検出 [97-102行目]
    |       +-- grep docker /proc/1/cgroup
    |
    +-- C++コンパイラ確認 [104-109行目]
    |       +-- which c++ && c++ --version
    |
    +-- pip パッケージ収集 [111-112行目]
    |       +-- pip list | grep ...
    |
    +-- 仮想環境検出 [116-123行目]
    |       +-- python -c "import sys; ..."
    |
    +-- TensorFlowインポート [125-135行目]
    |       +-- python -c "import tensorflow as tf; ..."
    |
    +-- cuDNN検出 [138-143行目]
    |       +-- LD_DEBUG=libs python -c "import tensorflow"
    |
    +-- 環境変数確認 [145-158行目]
    |
    +-- nvidia-smi [161-162行目]
    |       +-- nvidia-smi
    |
    +-- CUDAライブラリ検索 [164-167行目]
    |       +-- find /usr -name 'libcud*'
    |
    +-- pip show情報 [169-177行目]
    |       +-- pip show tensorflow / tf_nightly
    |
    +-- Python/Bazelバージョン [179-184行目]
    |
    +-- 出力フィルタ [187行目]
            +-- grep -v -i google >> tf_env.txt
```

### データフロー図

```
[入力]                        [処理]                        [出力]

Pythonランタイム ----------> platform モジュール -------> Pythonバージョン情報
OSシステム -----------------> platform モジュール -------> OSプラットフォーム情報
/proc/1/cgroup ------------> grep ----------------------> Docker検出結果
C++コンパイラ --------------> c++ --version ------------> コンパイラ情報
pip パッケージDB -----------> pip list -----------------> パッケージバージョン
sys モジュール ------------> sys.real_prefix ----------> 仮想環境検出結果
TensorFlowライブラリ ------> import tensorflow --------> TFバージョン・動作確認
CUDAライブラリ ------------> LD_DEBUG / find ----------> GPU/CUDA情報
nvidia-smi ----------------> nvidia-smi ----------------> GPU情報
                                    |
                                    v
                              grep -v -i google
                                    |
                                    v
                              tf_env.txt（環境情報ファイル）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tf_env_collect.sh | `tools/tf_env_collect.sh` | スクリプト | 環境情報収集ツール。TensorFlowの問題報告時に使用 |
