# 機能設計書 48-実験的データセット操作

## 概要

本ドキュメントは、TensorFlowにおける実験的データセット操作機能の設計を記述する。グルーピング・サンプリング・自動シャーディング・統計収集・ベンチマーキング等の実験的なデータセット変換操作を提供する。

### 本機能の処理概要

本機能は、tf.data.experimental名前空間で提供される実験的なデータセット変換操作群をC++カーネルレベルで定義する。これらの操作は、標準のtf.data API（No.44）では提供されない高度な変換・最適化・デバッグ機能を提供する。

**業務上の目的・背景**：機械学習の入力パイプラインには、標準APIでは対応できない高度な要件が存在する。分散学習時のデータ自動シャーディング、パイプラインの性能プロファイリング、複数変換ブランチの自動選択、データ圧縮等の実験的機能が、パフォーマンス改善やデバッグに不可欠である。

**機能の利用シーン**：（1）分散学習でAutoShardDatasetによるデータの自動分割を行う場面、（2）パイプラインのバイト生成量やレイテンシを統計収集する場面、（3）CSVデータセットの直接読込みを行う場面、（4）圧縮/解凍によるデータ転送量削減を行う場面、（5）ChooseFastestDatasetで最速の変換ブランチを自動選択する場面。

**主要な処理内容**：
1. AssertCardinalityDataset: データセットのカーディナリティを検証
2. AssertNextDataset/AssertPrevDataset: パイプライン構成の検証
3. AutoShardDataset: ワーカー数とインデックスに基づくデータ自動シャーディング
4. BytesProducedStatsDataset/LatencyStatsDataset: パイプライン統計収集
5. ChooseFastestBranchDataset/ChooseFastestDataset: 最速変換の自動選択
6. CompressElement/UncompressElement: データ要素の圧縮/解凍
7. CSVDataset: CSVファイルの直接読込み
8. ComputeBatchSize: バッチサイズの動的計算

**関連システム・外部連携**：tf.data.Dataset API（No.44）、分散学習フレームワーク、パフォーマンスプロファイリングツール。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに本機能の関連画面なし |

## 機能種別

データ連携 / 計算処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| input_dataset | variant | Yes | 入力データセットハンドル | 有効なvariant |
| cardinality | int64 | No | 期待されるカーディナリティ | スカラー |
| num_workers | int64 | No | AutoShard用のワーカー数 | スカラー |
| index | int64 | No | AutoShard用のワーカーインデックス | スカラー |
| tag | string | No | 統計タグ | スカラー |
| transformations | string | No | Assert用の変換名リスト | ベクトル |
| filenames | string | No | CSVDataset用のファイル名 | ベクトル |
| components | input_types | No | CompressElement用の入力テンソル | 型リスト |

### 入力データソース

上流のtf.data.Datasetパイプライン、CSVファイル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| handle | variant | 変換後のデータセットハンドル |
| compressed | variant | 圧縮された要素（CompressElement） |
| components | output_types | 解凍された要素（UncompressElement） |
| batch_size | int64 | 計算されたバッチサイズ（ComputeBatchSize） |

### 出力先

下流のtf.dataパイプラインに接続される。

## 処理フロー

### 処理シーケンス

```
1. 実験的Op登録（C++）
   └─ REGISTER_OPマクロで各操作を登録
   └─ 入力/出力の型・形状を定義
   └─ SetTypeConstructorでvariant型コンテナを設定
   └─ SetShapeFnで形状推論関数を設定
2. Python APIからの呼び出し
   └─ tf.data.experimental.xxx() → gen_dataset_ops.xxx()
3. C++カーネルでの実行
   └─ 各Opの具体的な計算/変換ロジックを実行
```

### フローチャート

```mermaid
flowchart TD
    A[Python API呼出し] --> B[gen_dataset_ops生成コード]
    B --> C[C++ Op実行]
    C --> D{Op種別}
    D -->|AssertCardinality| E[カーディナリティ検証]
    D -->|AutoShard| F[ワーカーインデックスでデータ分割]
    D -->|Stats| G[統計情報収集]
    D -->|ChooseFastest| H[最速ブランチ選択]
    D -->|Compress| I[要素圧縮/解凍]
    D -->|CSV| J[CSVパース]
    E --> K[variant出力]
    F --> K
    G --> K
    H --> K
    I --> K
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | カーディナリティ検証 | AssertCardinalityのcardinalityはスカラー | Op実行時 |
| BR-48-02 | AutoShardポリシー | auto_shard_policyで分割戦略を選択（デフォルト0） | AutoShardDataset |
| BR-48-03 | 変換アサーション | AssertNextの変換名リストはベクトル | AssertNextDataset |
| BR-48-04 | ChooseFastestの最小入力 | ChooseFastestDatasetは最低2つの入力データセットが必要 | ChooseFastestDataset |
| BR-48-05 | 全Opがvariant型 | 全てのDataset Opの出力はTFT_DATASETのvariant型 | 常時 |

### 計算ロジック

- **AutoShard**: 入力データセットの要素をnum_workersで分割し、index番目のスライスを返す
- **CompressElement**: テンソルをvariant型に圧縮して転送コスト削減
- **ComputeBatchSize**: 入力データセットのバッチ次元から動的にバッチサイズを推定

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgumentError | 形状エラー | cardinalityがスカラーでない | スカラーテンソルを指定 |
| InvalidArgumentError | 形状エラー | transformationsがベクトルでない | 1次元テンソルを指定 |
| FailedPreconditionError | アサーション | カーディナリティが期待値と不一致 | データセットの要素数を確認 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- AutoShardDatasetは分散学習の必須コンポーネントであり、低オーバーヘッドであること
- ChooseFastestDatasetは実行時のベンチマークにより最速のブランチを選択
- CompressElementはデータ転送量を削減し、分散環境でのスループットを向上

## セキュリティ考慮事項

特になし。

## 備考

- Experimental Opの多くには非Experimental版（AssertNextDataset等）とExperimental版（ExperimentalAssertNextDataset等）の両方が登録されている
- CheckPinned Opはテンソルがピニングされたメモリに配置されているかを確認するデバッグ用Op

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | experimental_dataset_ops.cc | `tensorflow/core/ops/experimental_dataset_ops.cc` | Op登録マクロとvariant型コンテナ |

**読解のコツ**: 各REGISTER_OPマクロは、入力/出力テンソルの型と形状、属性（Attr）、形状推論関数（SetShapeFn）を定義する。ほとんどのDataset OpはTFT_DATASETのvariant型コンテナとしてSetTypeConstructorが設定される。

#### Step 2: 主要なOp定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | experimental_dataset_ops.cc | `tensorflow/core/ops/experimental_dataset_ops.cc` | AssertCardinality/AutoShard等 |

**主要処理フロー**:
1. **21-34行目**: AssertCardinalityDataset - input_datasetとcardinalityを入力、cardinalityがスカラーであることを検証
2. **36-49行目**: AssertNextDataset - transformationsがベクトルであることを検証
3. **81-94行目**: AutoShardDataset - num_workers/indexを入力、auto_shard_policy属性、num_replicas属性
4. **108-120行目**: BytesProducedStatsDataset - tagがスカラーであることを検証
5. **136-151行目**: ChooseFastestBranchDataset - 複数ブランチの関数と引数
6. **152-161行目**: ChooseFastestDataset - N個の入力データセット（N >= 2）
7. **174-178行目**: CompressElement - テンソルコンポーネントをvariantに圧縮
8. **180-185行目**: UncompressElement - variantからテンソルに解凍
9. **198-200行目**: CSVDataset - CSVファイルの直接読込み

### プログラム呼び出し階層図

```
tf.data.experimental.xxx()
    │
    └─ gen_dataset_ops.xxx()  (Python自動生成コード)
           │
           └─ C++ Kernel実行
                  │
                  ├─ AssertCardinalityDatasetOp
                  ├─ AutoShardDatasetOp
                  ├─ BytesProducedStatsDatasetOp
                  ├─ ChooseFastestBranchDatasetOp
                  ├─ CompressElementOp
                  └─ CSVDatasetOp
```

### データフロー図

```
[入力]                     [処理]                          [出力]

Dataset (variant) ───▶ Experimental Op ───▶ Dataset (variant)
                           │
                    ┌──────┴──────────┐
                    │ Assert: 検証    │
                    │ AutoShard: 分割 │
                    │ Stats: 統計     │
                    │ Compress: 圧縮  │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| experimental_dataset_ops.cc | `tensorflow/core/ops/experimental_dataset_ops.cc` | ソース(C++) | 実験的Dataset Opの登録 |
| gen_dataset_ops.py | `tensorflow/python/ops/gen_dataset_ops.py` | 自動生成 | C++ Opへのバインディング |
| dataset_ops.py | `tensorflow/python/data/ops/dataset_ops.py` | ソース | DatasetV2ベースクラス |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 形状推論共通関数 |
| full_type.pb.h | `tensorflow/core/framework/full_type.pb.h` | 自動生成 | 型システムProtobuf定義 |
