# 機能設計書 58-スパースCSR行列操作

## 概要

本ドキュメントは、TensorFlowにおけるスパースCSR（Compressed Sparse Row）行列操作機能の設計を記述する。CSR形式のスパース行列に対する変換、算術演算、行列積、転置、ソフトマックス、コレスキー分解、AMD順序付けなどのオペレーション群を提供する。

### 本機能の処理概要

**業務上の目的・背景**：CSR形式は行方向に圧縮されたスパース行列表現であり、行列・ベクトル積などの演算に効率的である。大規模疎行列の線形代数演算（科学計算、グラフ処理、推薦システム）において、COO形式よりも高い演算効率を実現する。本機能はvariant型としてカプセル化されたCSRスパース行列に対する各種操作を提供する。

**機能の利用シーン**：大規模疎行列の行列積（SparseMatrixMatMul）、疎行列同士の行列積（SparseMatrixSparseMatMul）、スパースコレスキー分解（SparseMatrixSparseCholesky）、スパースソフトマックス（SparseMatrixSoftmax）で利用される。

**主要な処理内容**：
1. 変換操作：SparseTensorToCSRSparseMatrix, CSRSparseMatrixToSparseTensor, DenseToCSRSparseMatrix, CSRSparseMatrixToDense
2. コンポーネント取得：CSRSparseMatrixComponents, SparseMatrixNNZ
3. 算術演算：SparseMatrixAdd, SparseMatrixMul
4. 行列積：SparseMatrixMatMul, SparseMatrixSparseMatMul
5. 構造操作：SparseMatrixTranspose, SparseMatrixZeros
6. 高度な演算：SparseMatrixSoftmax/Grad, SparseMatrixOrderingAMD, SparseMatrixSparseCholesky

**関連システム・外部連携**：Intel MKL（oneDNN）がコンパイル時に有効な場合、_MklNativeSparseMatrixMatMulが追加登録される。

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない基盤機能である |

## 機能種別

計算処理 / 線形代数（スパース）

## 入力仕様

### 入力パラメータ（代表的なOp）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| sparse_matrix | variant | Yes | CSRスパース行列（variant型でカプセル化） | rank=0, handle_shapes_and_typesが必須 |
| indices | int64 | Yes（変換系） | COO形式インデックス | rank=2 |
| values | T | Yes（変換系） | 非ゼロ要素値 | - |
| dense_shape | int64 | Yes（変換系） | 密行列の形状 | rank=1 |
| b | T | Yes（MatMul） | 密行列B | rank>=2, <=3 |
| transpose_a/b | bool（属性） | No | 転置フラグ | - |
| adjoint_a/b | bool（属性） | No | 随伴行列フラグ | adjoint_aとtranspose_aは排他 |
| conjugate | bool（属性） | No | 共役転置フラグ（Transpose） | - |

### 入力データソース

計算グラフ内のvariant型CSRスパース行列、またはCOO形式/密テンソルからの変換。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sparse_matrix | variant | CSRスパース行列（variant型） |
| dense_output | T | 密テンソル（CSRSparseMatrixToDense） |
| output | T | 行列積結果（SparseMatrixMatMul） |
| row_ptrs | int32 | CSR行ポインタ（Components） |
| col_inds | int32 | CSR列インデックス（Components） |
| nnz | int32 | 非ゼロ要素数 |

### 出力先

後続の計算グラフ。

## 処理フロー

### 処理シーケンス

```
1. CSRスパース行列の生成
   ├─ SparseTensorToCSRSparseMatrix: COO形式→CSR形式変換
   ├─ DenseToCSRSparseMatrix: 密テンソル→CSR形式変換
   └─ SparseMatrixZeros: ゼロ行列の生成
2. 演算の実行
   ├─ SparseMatrixMatMul: CSR × 密 → 密
   ├─ SparseMatrixSparseMatMul: CSR × CSR → CSR
   ├─ SparseMatrixAdd: alpha*A + beta*B
   └─ SparseMatrixMul: A * scalar
3. 構造操作
   ├─ SparseMatrixTranspose: 転置
   └─ SparseMatrixOrderingAMD: AMD順序付け
4. 結果の取得
   ├─ CSRSparseMatrixToDense: CSR→密テンソル
   ├─ CSRSparseMatrixToSparseTensor: CSR→COO形式
   └─ CSRSparseMatrixComponents: row_ptrs, col_inds, values取得
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | ランク制約 | CSRスパース行列はrank=2（単一行列）またはrank=3（バッチ行列）のみ | 全Op |
| BR-58-02 | variant型入出力 | CSRスパース行列はvariant型としてカプセル化され、handle_shapes_and_typesで形状・型情報を保持 | 全Op |
| BR-58-03 | 型制約 | サポート型はfloat, double, complex64, complex128 | 全Op |
| BR-58-04 | adjoint/transpose排他 | adjoint_aとtranspose_aは同時にtrueにできない | MatMul系 |
| BR-58-05 | 正方行列制約 | AMD順序付けとコレスキー分解は正方行列が必要 | OrderingAMD, SparseCholesky |
| BR-58-06 | バッチ次元一致 | 行列積でのバッチ次元は入力間で一致（または互換）が必要 | MatMul系 |
| BR-58-07 | Mul形状制約 | SparseMatrixMulのbはスカラーまたは[batch,1,1]形状 | SparseMatrixMul |

### 計算ロジック

- **SparseMatrixMatMul**: CSR形式スパース行列Aと密行列Bの行列積。transpose_a/b/output、adjoint_a/b、conjugate_outputフラグで多様な演算パターンに対応。
- **SparseMatrixSparseMatMul**: 2つのCSRスパース行列の行列積。バッチ次元はブロードキャスト互換。
- **SparseMatrixSparseCholesky**: 置換行列付きスパースコレスキー分解。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | ランクエラー | 行列のランクが2または3でない | rank=2またはrank=3のテンソルを入力 |
| InvalidArgument | variant型エラー | variant入力からshape_and_typeを取得できない | 正しいCSRスパース行列を入力 |
| InvalidArgument | 排他エラー | adjoint_aとtranspose_aが同時にtrue | 一方のみをtrueに設定 |
| InvalidArgument | 正方行列エラー | 非正方行列でAMD/Cholsekyを呼び出し | 正方行列を入力 |
| Unimplemented | Mul形状エラー | bがスカラーでも[batch,1,1]でもない | 対応形状のテンソルを入力 |

### リトライ仕様

ステートレスな計算であり、リトライに特別な考慮は不要。

## トランザクション仕様

トランザクション制御は行わない。

## パフォーマンス要件

CSR形式の行列・ベクトル積はO(nnz)の計算量で、密行列のO(n^2)よりも効率的。Intel MKL対応により更に高速化が可能。

## セキュリティ考慮事項

特段のセキュリティ考慮事項はない。

## 備考

sparse_csr_matrix_ops.ccは約700行で16のオペレーションを定義している。GetVariantInput/ValidateSquareMatrixShape等のヘルパー関数が複数のOpで再利用されている。INTEL_MKLとENABLE_ONEDNN_V3が有効な場合のみ_MklNativeSparseMatrixMatMulが追加登録される。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

variant型によるCSRスパース行列のカプセル化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 33-44行目: GetVariantInput - variant型入力からShapeAndTypeを取得するヘルパー |
| 1-2 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 48-61行目: ValidateSquareMatrixShape - rank=2/3の正方行列検証ヘルパー |

**読解のコツ**: CSRスパース行列はvariant型（スカラー、rank=0）としてTensorFlowグラフ内を流通する。形状・型情報はinput_handle_shapes_and_types()で取得する。これはTensorFlowの型システム拡張の一例である。

#### Step 2: 変換Opを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 63-89行目: SparseTensorToCSRSparseMatrix - COO→CSR変換 |
| 2-2 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 91-113行目: CSRSparseMatrixToSparseTensor - CSR→COO変換 |
| 2-3 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 115-153行目: DenseToCSRSparseMatrix - 密→CSR変換 |

#### Step 3: 行列積Opを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 225-300行目: SparseMatrixMatMul - CSR x Dense行列積の複雑な形状推論 |
| 3-2 | sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | 466-538行目: SparseMatrixSparseMatMul - CSR x CSR行列積 |

### プログラム呼び出し階層図

```
sparse_csr_matrix_ops.cc (Op定義)
    |
    +-- ヘルパー関数
    |    +-- GetVariantInput (33行目)
    |    +-- ValidateSquareMatrixShape (48行目)
    |
    +-- 変換Op
    |    +-- SparseTensorToCSRSparseMatrix (63行目)
    |    +-- CSRSparseMatrixToSparseTensor (91行目)
    |    +-- DenseToCSRSparseMatrix (115行目)
    |    +-- CSRSparseMatrixToDense (155行目)
    |
    +-- コンポーネントOp
    |    +-- CSRSparseMatrixComponents (171行目)
    |    +-- SparseMatrixNNZ (203行目)
    |
    +-- 行列積Op
    |    +-- SparseMatrixMatMul (225行目)
    |    +-- _MklNativeSparseMatrixMatMul (304行目, MKL有効時のみ)
    |    +-- SparseMatrixSparseMatMul (466行目)
    |
    +-- 算術Op
    |    +-- SparseMatrixMul (382行目)
    |    +-- SparseMatrixAdd (429行目)
    |
    +-- 構造Op
    |    +-- SparseMatrixZeros (540行目)
    |    +-- SparseMatrixTranspose (564行目)
    |
    +-- 高度な演算Op
         +-- SparseMatrixSoftmax (592行目)
         +-- SparseMatrixSoftmaxGrad (611行目)
         +-- SparseMatrixOrderingAMD (639行目)
         +-- SparseMatrixSparseCholesky (659行目)
```

### データフロー図

```
COO (indices, values, dense_shape) -> SparseTensorToCSRSparseMatrix -> CSR (variant)
Dense tensor -----------------------> DenseToCSRSparseMatrix --------> CSR (variant)

CSR (variant) + Dense (T) ----------> SparseMatrixMatMul ------------> Dense (T)
CSR (variant) + CSR (variant) ------> SparseMatrixSparseMatMul ------> CSR (variant)
CSR (variant) + scalar (T) ---------> SparseMatrixMul ---------------> CSR (variant)

CSR (variant) ----------------------> CSRSparseMatrixToDense --------> Dense tensor
CSR (variant) ----------------------> CSRSparseMatrixToSparseTensor -> COO tuple
CSR (variant) ----------------------> SparseMatrixTranspose ---------> CSR (variant)
CSR (variant) ----------------------> SparseMatrixSparseCholesky ----> CSR (variant)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sparse_csr_matrix_ops.cc | `tensorflow/core/ops/sparse_csr_matrix_ops.cc` | ソース | CSRスパース行列Op定義（16 Op） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | ValidateSparseTensor等の共通関数 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ定義 |
