# 機能設計書 59-RaggedTensor配列操作

## 概要

本ドキュメントは、TensorFlowにおけるRaggedTensor配列操作機能の設計を記述する。RaggedTensor（不揃い長さの配列を持つテンソル）に対するギャザー、クロス結合、空行埋めなどの配列操作オペレーションを提供する。

### 本機能の処理概要

**業務上の目的・背景**：自然言語処理（可変長文書・文のバッチ）、時系列データ（異なる長さのシーケンス）、グラフデータ（ノードごとに異なる数のエッジ）など、各要素の長さが不揃いなデータを効率的に扱うための配列操作が必要である。RaggedTensorはこうした不揃いデータをパディングなしで表現するデータ構造であり、本機能はその操作を提供する。

**機能の利用シーン**：可変長テキストデータのバッチ処理、特徴量クロス結合（RaggedCross）、不揃い配列からの要素取得（RaggedGather）、空行の処理（RaggedFillEmptyRows）で利用される。

**主要な処理内容**：
1. RaggedGather: RaggedTensorからインデックスによる要素取得
2. RaggedCross: 複数のRagged/Sparse/Dense入力の交差結合（特徴量エンジニアリング用）
3. RaggedFillEmptyRows: 空行をデフォルト値で埋める
4. RaggedFillEmptyRowsGrad: RaggedFillEmptyRowsの勾配計算

**関連システム・外部連携**：特になし。

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない基盤機能である |

## 機能種別

計算処理 / 配列操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| params_nested_splits | Tsplits[] | Yes（RaggedGather） | パラメータRaggedTensorの分割テンソル群 | 各rank=1 |
| params_dense_values | Tvalues | Yes（RaggedGather） | パラメータRaggedTensorの値テンソル | rank>=1 |
| indices | Tindices | Yes（RaggedGather） | ギャザーインデックス | rank = OUTPUT_RAGGED_RANK - PARAMS_RAGGED_RANK + 1 |
| value_rowids | int64 | Yes（FillEmptyRows） | 各値が属する行のID | rank=1 |
| values | T | Yes（FillEmptyRows） | 値テンソル | rank=1 |
| nrows | int64 | Yes（FillEmptyRows） | 行数 | rank=0 |
| default_value | T | Yes（FillEmptyRows） | デフォルト値 | rank=0 |
| PARAMS_RAGGED_RANK | int（属性） | Yes（RaggedGather） | パラメータのラグド次元数 | >= 1 |
| OUTPUT_RAGGED_RANK | int（属性） | Yes（RaggedGather） | 出力のラグド次元数 | >= 0 |

### 入力データソース

計算グラフ内のRaggedTensor表現（nested_splits + dense_values）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output_nested_splits | Tsplits[] | 出力RaggedTensorの分割テンソル群 |
| output_dense_values | Tvalues | 出力RaggedTensorの値テンソル |
| output_values | out_values_type | クロス結合結果の値（RaggedCross） |
| output_row_splits | out_row_splits_type | クロス結合結果の行分割（RaggedCross） |
| output_value_rowids | int64 | 埋め後の行ID（FillEmptyRows） |
| empty_row_indicator | bool | 空行インジケータ（FillEmptyRows） |
| reverse_index_map | int64 | 逆インデックスマップ（FillEmptyRows） |

### 出力先

後続の計算グラフ。

## 処理フロー

### 処理シーケンス

```
1. RaggedGather
   ├─ params_nested_splitsの各分割テンソルをrank=1検証
   ├─ params_dense_valuesをrank>=1検証
   ├─ indicesのランクを OUTPUT_RAGGED_RANK - PARAMS_RAGGED_RANK + 1 で検証
   ├─ OUTPUT_RAGGED_RANK個の分割テンソルを出力（各rank=1）
   └─ dense_valuesの後続次元を保持した値テンソルを出力

2. RaggedCross
   ├─ Ragged/Sparse/Dense入力の型情報を属性から取得
   ├─ バッチサイズの整合性を検証
   └─ 交差結合結果を [output_values, output_row_splits] で出力

3. RaggedFillEmptyRows
   ├─ value_rowids[rank=1], values[rank=1], nrows[rank=0], default_value[rank=0]検証
   ├─ N = value_rowids.dim(0) = values.dim(0) を検証
   └─ output_value_rowids, output_values, empty_row_indicator, reverse_index_map出力
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-01 | ラグドランク制約 | PARAMS_RAGGED_RANK >= 1, OUTPUT_RAGGED_RANK >= 0 | RaggedGather |
| BR-59-02 | インデックスランク | indices.rank = OUTPUT_RAGGED_RANK - PARAMS_RAGGED_RANK + 1 | RaggedGather |
| BR-59-03 | 分割テンソルランク | 全てのnested_splitsはrank=1 | RaggedGather, RaggedCross |
| BR-59-04 | クロスバッチ整合性 | 全入力のバッチサイズが一致しなければならない | RaggedCross |
| BR-59-05 | クロス密入力ランク | RaggedCrossの密入力はrank=2のみ対応 | RaggedCross |
| BR-59-06 | 行ID・値一致 | value_rowids.dim(0) == values.dim(0) | RaggedFillEmptyRows |

### 計算ロジック

- **RaggedGather**: インデックスに従ってRaggedTensorのサブ構造を取得。nested_splitsを辿って対応する値範囲を決定。
- **RaggedCross**: 複数入力の直積（Cross Product）を計算し、ハッシュ化またはstring連結で結合。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 型不一致 | ragged_values_typesとragged_splits_typesの長さ不一致 | 同じ長さのリストを指定 |
| InvalidArgument | バッチ不一致 | 入力間でバッチサイズが異なる | 同一バッチサイズの入力を使用 |
| InvalidArgument | 密入力ランク | RaggedCrossの密入力がrank!=2 | rank=2のテンソルを入力 |

### リトライ仕様

ステートレスな計算であり、リトライに特別な考慮は不要。

## トランザクション仕様

トランザクション制御は行わない。

## パフォーマンス要件

RaggedTensorはパディングなしで不揃いデータを表現するため、パディングベースのバッチ処理よりもメモリ効率が良い。

## セキュリティ考慮事項

特段のセキュリティ考慮事項はない。

## 備考

ragged_array_ops.ccは約226行で4つのオペレーション（RaggedGather, RaggedCross, RaggedFillEmptyRows, RaggedFillEmptyRowsGrad）を定義している。RaggedGatherShapeFnは187-223行目に定義され、PARAMS_RAGGED_RANKとOUTPUT_RAGGED_RANKの属性値に基づく複雑な形状推論を行う。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

RaggedTensorの表現方法（nested_splits + dense_values）を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ragged_array_ops.cc | `tensorflow/core/ops/ragged_array_ops.cc` | 31-42行目: RaggedGatherのOp登録 - PARAMS_RAGGED_RANK個のsplitsテンソルとdense_valuesでRaggedTensorを表現 |

**読解のコツ**: RaggedTensorは「splits（分割）テンソル」の入れ子と「values（値）テンソル」で表現される。splits[i]は各行の開始/終了インデックスを示し、splits[i+1] - splits[i]がi番目の行の長さとなる。

#### Step 2: 形状推論を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ragged_array_ops.cc | `tensorflow/core/ops/ragged_array_ops.cc` | 187-223行目: RaggedGatherShapeFn - PARAMS_RAGGED_RANK/OUTPUT_RAGGED_RANKに基づく出力形状計算 |
| 2-2 | ragged_array_ops.cc | `tensorflow/core/ops/ragged_array_ops.cc` | 64-129行目: RaggedCrossの形状推論 - ragged/sparse/dense入力のバッチサイズ整合検証 |

#### Step 3: FillEmptyRowsを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ragged_array_ops.cc | `tensorflow/core/ops/ragged_array_ops.cc` | 131-165行目: RaggedFillEmptyRows - value_rowids+values+nrows+default_valueの4入力、4出力 |

### プログラム呼び出し階層図

```
ragged_array_ops.cc (Op定義)
    |
    +-- RaggedGather (31行目)
    |    └─ RaggedGatherShapeFn (187行目)
    |         ├─ PARAMS_RAGGED_RANK属性取得
    |         ├─ OUTPUT_RAGGED_RANK属性取得
    |         ├─ indices.rank検証 (num_splits - PARAMS_RAGGED_RANK + 1)
    |         ├─ params_nested_splits: 各rank=1検証
    |         ├─ params_dense_values: rank>=1検証
    |         ├─ 出力splits: OUTPUT_RAGGED_RANK個のrank=1テンソル
    |         └─ 出力values: [unknown] + dense_values.subshape(1:)
    |
    +-- RaggedCross (44行目)
    |    └─ カスタム形状推論
    |         ├─ ragged/sparse/dense型属性取得
    |         ├─ row_splitsのMerge（バッチサイズ整合）
    |         └─ 出力: [values, row_splits] 各rank=1
    |
    +-- RaggedFillEmptyRows (131行目)
    |    └─ カスタム形状推論
    |
    +-- RaggedFillEmptyRowsGrad (167行目)
         └─ カスタム形状推論
```

### データフロー図

```
[入力]                                [処理]                       [出力]

(nested_splits, dense_values)
+ indices                         -> RaggedGather            -> (output_splits, output_values)

(ragged_values, ragged_splits,
 sparse_indices/values/shape,
 dense_inputs)                    -> RaggedCross             -> (output_values, output_row_splits)

(value_rowids, values,
 nrows, default_value)            -> RaggedFillEmptyRows    -> (output_rowids, output_values,
                                                                 empty_indicator, reverse_map)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ragged_array_ops.cc | `tensorflow/core/ops/ragged_array_ops.cc` | ソース | RaggedTensor配列Op定義（4 Op） |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 共通形状推論関数 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ定義 |
