# 機能設計書 60-RaggedTensor変換操作

## 概要

本ドキュメントは、TensorFlowにおけるRaggedTensor変換操作機能の設計を記述する。RaggedTensorとSparseTensor/DenseTensor/Variant間の相互変換オペレーションを提供する。

### 本機能の処理概要

**業務上の目的・背景**：RaggedTensor、SparseTensor、密テンソル（DenseTensor）は異なるデータ表現形式であり、処理パイプラインの各段階で適切な形式への変換が必要となる。例えば、RaggedTensorから密テンソルへの変換（パディング付き）は、固定長入力を要求するモデルへの入力に不可欠である。また、variant型へのシリアライズはデータセットAPIでの効率的な転送に使用される。

**機能の利用シーン**：RaggedTensor→SparseTensor変換（既存のスパース処理との互換）、RaggedTensor→密テンソル変換（RaggedTensorToTensor、パディング付き）、variant型との相互変換（データパイプライン内の効率的なシリアライズ）で利用される。

**主要な処理内容**：
1. RaggedTensorToSparse: RaggedTensor→SparseTensor（COO形式）変換
2. RaggedTensorToVariant: RaggedTensor→variant型シリアライズ
3. RaggedTensorFromVariant: variant型→RaggedTensorデシリアライズ
4. RaggedTensorToVariantGradient: RaggedTensorToVariantの勾配計算
5. RaggedTensorToTensor: RaggedTensor→密テンソル変換（パディング付き）

**関連システム・外部連携**：特になし。

**権限による制御**：特段の権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面と直接関連しない基盤機能である |

## 機能種別

計算処理 / データ変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| rt_nested_splits | Tsplits[] | Yes（ToSparse/ToVariant） | RaggedTensorの分割テンソル群 | 各rank=1 |
| rt_dense_values | T/Tvalues | Yes（ToSparse/ToVariant） | RaggedTensorの値テンソル | rank>=1 |
| RAGGED_RANK | int（属性） | Yes（ToSparse） | ラグド次元数 | >= 1 |
| batched_input | bool（属性） | Yes（ToVariant） | バッチ入力フラグ | - |
| encoded_ragged | variant | Yes（FromVariant） | エンコード済みRaggedTensor | - |
| input_ragged_rank | int（属性） | Yes（FromVariant） | 入力のラグドランク | >= -1 |
| output_ragged_rank | int（属性） | Yes（FromVariant） | 出力のラグドランク | >= 0 |
| shape | Tshape | Yes（ToTensor） | 出力テンソルの形状 | ShapeTensor |
| values | T | Yes（ToTensor） | 値テンソル | - |
| default_value | T | Yes（ToTensor） | パディング用デフォルト値 | - |
| row_partition_tensors | Tindex[] | Yes（ToTensor） | 行パーティションテンソル群 | - |
| row_partition_types | string[]（属性） | Yes（ToTensor） | パーティション種別リスト | FIRST_DIM_SIZE/VALUE_ROWIDS/ROW_SPLITS |

### 入力データソース

計算グラフ内のRaggedTensor表現またはvariant型テンソル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sparse_indices | int64 | SparseTensor変換結果のインデックス [nnz, ndims]（ToSparse） |
| sparse_values | T | SparseTensor変換結果の値 [nnz]（ToSparse） |
| sparse_dense_shape | int64 | SparseTensor変換結果の密形状 [ndims]（ToSparse） |
| encoded_ragged | variant | シリアライズ結果（ToVariant） |
| output_nested_splits | Tsplits[] | デシリアライズ結果の分割テンソル群（FromVariant） |
| output_dense_values | Tvalues | デシリアライズ結果の値テンソル（FromVariant） |
| result | T | 密テンソル変換結果（ToTensor） |

### 出力先

後続の計算グラフ。

## 処理フロー

### 処理シーケンス

```
1. RaggedTensorToSparse
   ├─ RAGGED_RANK個のnested_splitsをrank=1検証
   ├─ rt_dense_valuesをrank>=1検証
   ├─ 出力形状計算: ndims = Rank(rt_dense_values) + RAGGED_RANK
   └─ 出力: indices[nnz, ndims], values[nnz], dense_shape[ndims]

2. RaggedTensorToVariant
   ├─ RAGGED_RANK個のnested_splitsをrank=1検証
   ├─ rt_dense_valuesをrank>=1検証
   ├─ batched_input=trueの場合: 出力はVector(num_first_splits - 1)
   └─ batched_input=falseの場合: 出力はScalar()

3. RaggedTensorFromVariant
   ├─ encoded_ragged入力の受け取り
   ├─ input_ragged_rank/output_ragged_rankに基づくランク検証
   └─ output_ragged_rank個のsplits + dense_valuesを出力

4. RaggedTensorToTensor
   ├─ shape入力から出力形状を決定
   ├─ row_partition_typesの検証（ROW_SPLITS/VALUE_ROWIDS/FIRST_DIM_SIZE）
   ├─ default_valueとvaluesの形状互換性検証
   └─ 密テンソル result を出力
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-60-01 | RAGGED_RANK>=1 | ToSparseのRAGGED_RANKは1以上 | RaggedTensorToSparse |
| BR-60-02 | バッチ出力形状 | batched_input=trueの場合、出力は[num_rows]ベクトル。falseの場合スカラー | RaggedTensorToVariant |
| BR-60-03 | ランク整合性 | encoded_ragged.rank = output_ragged_rank - input_ragged_rank | RaggedTensorFromVariant |
| BR-60-04 | パーティション型制約 | FIRST_DIM_SIZEは先頭でのみ使用可能。VALUE_ROWIDSは先頭では使用不可 | RaggedTensorToTensor |
| BR-60-05 | FIRST_DIM_SIZE後続制約 | FIRST_DIM_SIZEの直後はVALUE_ROWIDSでなければならない | RaggedTensorToTensor |
| BR-60-06 | パーティション数一致 | num_row_partition_tensors == row_partition_types.size() | RaggedTensorToTensor |
| BR-60-07 | パーティション形状制約 | FIRST_DIM_SIZEはスカラー、それ以外はベクトル | RaggedTensorToTensor |

### 計算ロジック

- **RaggedTensorToSparse**: nested_splitsを辿って各値のN次元インデックスを計算し、COO形式のSparseTensorに変換
- **RaggedTensorToTensor**: row_partition_tensorsとshapeからパディング付き密テンソルを構成。ragged_rank分のネスト構造をフラット化。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | RAGGED_RANKエラー | RAGGED_RANK < 1（ToSparse） | 1以上の値を指定 |
| InvalidArgument | パーティション型エラー | FIRST_DIM_SIZEが先頭以外、VALUE_ROWIDSが先頭 | 正しい順序で指定 |
| InvalidArgument | パーティション数不一致 | テンソル数と型数が不一致 | 同数で指定 |
| InvalidArgument | パーティション形状エラー | FIRST_DIM_SIZEがスカラーでない、他がベクトルでない | 正しい形状で入力 |
| InvalidArgument | デフォルト値形状エラー | default_valueとvaluesの形状が非互換 | 互換形状で入力 |

### リトライ仕様

ステートレスな計算であり、リトライに特別な考慮は不要。

## トランザクション仕様

トランザクション制御は行わない。

## パフォーマンス要件

RaggedTensor→密テンソル変換ではパディングが発生するため、密テンソルのサイズは最大長の要素に合わせて拡大される。メモリ使用量に注意。

## セキュリティ考慮事項

特段のセキュリティ考慮事項はない。

## 備考

ragged_conversion_ops.ccは約283行で5つのオペレーション（RaggedTensorToSparse, RaggedTensorToVariant, RaggedTensorFromVariant, RaggedTensorToVariantGradient, RaggedTensorToTensor）を定義している。RaggedTensorToTensorは最も複雑な形状推論を持ち、row_partition_typesの検証（ValidateRowPartitionTypesAndShapes）とCombineRaggedTensorToTensorShapes（ragged_to_dense_util.hから）を使用する。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

RaggedTensorの表現とrow_partition_typesの概念を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | 28-88行目: ValidateRowPartitionTypesAndShapes - パーティション型（FIRST_DIM_SIZE, VALUE_ROWIDS, ROW_SPLITS）の検証ロジック |
| 1-2 | ragged_to_dense_util.h | `tensorflow/core/util/ragged_to_dense_util.h` | RowPartitionType列挙型、GetRowPartitionTypes、CombineRaggedTensorToTensorShapesの定義 |

**読解のコツ**: RowPartitionTypeは3種類あり、FIRST_DIM_SIZEは最初の次元のサイズをスカラーで指定、ROW_SPLITSは分割境界インデックス、VALUE_ROWIDSは各値の行IDを保持する。これらを組み合わせてRaggedTensorの構造を密テンソルに展開する。

#### Step 2: 変換Opを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | 160-187行目: RaggedTensorToSparseShapeFn - ndims = Rank(values) + RAGGED_RANK |
| 2-2 | ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | 189-209行目: RaggedTensorToVariantShapeFn - batched_inputによる出力形状切り替え |
| 2-3 | ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | 219-237行目: RaggedTensorFromVariantShapeFn - input_ragged_rank/output_ragged_rankに基づく形状推論 |
| 2-4 | ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | 239-280行目: RaggedTensorToTensorShapeFn - 最も複雑な形状推論 |

**主要処理フロー**:
1. **160-187行目**: ToSparse: RAGGED_RANK取得→splits各rank=1検証→ndims計算→indices[nnz,ndims], values[nnz], dense_shape[ndims]出力
2. **189-209行目**: ToVariant: batched=true時はVector(num_first_splits-1)、false時はScalar()
3. **239-280行目**: ToTensor: shape入力→GetRowPartitionTypes→ValidateRowPartitionTypesAndShapes→CombineRaggedTensorToTensorShapes→出力形状決定

### プログラム呼び出し階層図

```
ragged_conversion_ops.cc (Op定義)
    |
    +-- ヘルパー関数
    |    +-- ValidateRowPartitionTypesAndShapes (28行目)
    |
    +-- 前方宣言
    |    +-- RaggedTensorToSparseShapeFn (92行目)
    |    +-- RaggedTensorToVariantShapeFn (93行目)
    |    +-- RaggedTensorFromVariantShapeFn (94行目)
    |    +-- RaggedTensorToVariantGradientShapeFn (95行目)
    |    +-- RaggedTensorToTensorShapeFn (96行目)
    |
    +-- Op登録
    |    +-- RaggedTensorToSparse (102行目)
    |    +-- RaggedTensorToVariant (113行目)
    |    +-- RaggedTensorFromVariant (124行目)
    |    +-- RaggedTensorToVariantGradient (134行目)
    |    +-- RaggedTensorToTensor (143行目)
    |
    +-- 形状推論関数の実装
         +-- RaggedTensorToSparseShapeFn (160行目)
         +-- RaggedTensorToVariantShapeFn (189行目)
         +-- RaggedTensorToVariantGradientShapeFn (211行目)
         +-- RaggedTensorFromVariantShapeFn (219行目)
         +-- RaggedTensorToTensorShapeFn (239行目)
              └─ GetRowPartitionTypes (249行目, ragged_to_dense_util.hから)
              └─ ValidateRowPartitionTypesAndShapes (252行目)
              └─ CombineRaggedTensorToTensorShapes (272行目, ragged_to_dense_util.hから)
```

### データフロー図

```
[入力]                              [処理]                          [出力]

(nested_splits, dense_values) -> RaggedTensorToSparse --------> (indices, values, dense_shape)
                                                                  COO形式SparseTensor

(nested_splits, dense_values) -> RaggedTensorToVariant -------> variant (スカラー or ベクトル)

variant -----------------------> RaggedTensorFromVariant ------> (output_splits, output_values)

(shape, values, default_value,
 row_partition_tensors)       -> RaggedTensorToTensor ---------> result (密テンソル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ragged_conversion_ops.cc | `tensorflow/core/ops/ragged_conversion_ops.cc` | ソース | RaggedTensor変換Op定義（5 Op） |
| ragged_to_dense_util.h | `tensorflow/core/util/ragged_to_dense_util.h` | ヘッダ | RowPartitionType, GetRowPartitionTypes, CombineRaggedTensorToTensorShapes |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダ | 共通形状推論関数 |
| op.h | `tensorflow/core/framework/op.h` | ヘッダ | REGISTER_OPマクロ定義 |
