# 機能設計書 68-集約的All-Reduce戦略

## 概要

本ドキュメントは、TensorFlowにおけるCollectiveAllReduceStrategy（MultiWorkerMirroredStrategy）によるマルチワーカー分散学習を提供する機能の設計を記述する。

### 本機能の処理概要

集約的All-Reduce戦略は、tf.distribute.MultiWorkerMirroredStrategyとして公開される分散学習ストラテジーである。複数のワーカー（マシン）にまたがる同期分散学習を実現し、各ワーカーが持つ複数のGPUでモデルを複製する。勾配の集約にはcollective通信（All-Reduce）を使用し、NCCL、RING、AUTO等の実装を選択可能である。

**業務上の目的・背景**：単一マシンのGPUでは処理しきれない大規模データセットや大規模モデルの学習には、複数マシンを使った分散学習が必要である。MultiWorkerMirroredStrategyは、MirroredStrategyの概念をマルチワーカーに拡張し、TF_CONFIG環境変数によるクラスタ設定で手軽にマルチワーカー学習を実現する。

**機能の利用シーン**：複数マシンでのデータ並列学習、Keras model.fitでのマルチワーカー学習、カスタムトレーニングループでのマルチワーカー学習。

**主要な処理内容**：
1. TF_CONFIG環境変数によるクラスタ設定の解析
2. CollectiveAllReduceExtendedによるワーカー間通信の設定
3. 各ワーカーのローカルデバイスでのモデル複製
4. collective通信を用いた勾配のAll-Reduce集約
5. 全ワーカーの全レプリカで同期的な変数更新

**関連システム・外部連携**：TF_CONFIG環境変数、gRPCベースのワーカー間通信、NCCLライブラリ。

**権限による制御**：ワーカー間のネットワーク通信権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに該当なし |

## 機能種別

計算処理（分散学習フレームワーク）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cluster_resolver | ClusterResolver | No | クラスタ設定のリゾルバ（デフォルト: TFConfigClusterResolver） | ClusterResolverインスタンス |
| communication_options | CommunicationOptions | No | 通信オプション（NCCL/RING/AUTO） | CommunicationOptionsインスタンス |

### 入力データソース

TF_CONFIG環境変数によるクラスタ構成情報。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| strategy | CollectiveAllReduceStrategy | 構成済みのマルチワーカー分散ストラテジー |

### 出力先

Python上のStrategyオブジェクト。

## 処理フロー

### 処理シーケンス

```
1. CollectiveAllReduceStrategy のインスタンス化
   └─ 1-1. cluster_resolver の設定（デフォルト: TFConfigClusterResolver）
   └─ 1-2. communication_options の設定
   └─ 1-3. CollectiveAllReduceExtended の初期化
2. ワーカー初期化
   └─ 2-1. TF_CONFIGからクラスタ構成を解析
   └─ 2-2. 各ワーカーのGPU数を検出
   └─ 2-3. collective通信グループの設定
3. strategy.scope() による変数作成
   └─ 全ワーカー・全レプリカにMirroredVariableを作成
4. strategy.run() による学習ステップ実行
   └─ 各ワーカーの各レプリカで計算を実行
5. All-Reduce による勾配集約
   └─ collective_ops を使用して全ワーカー間で勾配を集約
```

### フローチャート

```mermaid
flowchart TD
    A[TF_CONFIG設定] --> B[CollectiveAllReduceStrategy 初期化]
    B --> C[クラスタ構成解析]
    C --> D[ローカルデバイス検出]
    D --> E[collective通信グループ設定]
    E --> F[strategy.scope 入場]
    F --> G[MirroredVariable作成]
    G --> H[strategy.run 学習ステップ]
    H --> I[各レプリカで計算]
    I --> J[collective All-Reduce勾配集約]
    J --> K[全レプリカで変数更新]
    K --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-68-01 | TF_CONFIG必須 | マルチワーカーの場合、各ワーカーにTF_CONFIGの設定が必要 | マルチワーカー環境 |
| BR-68-02 | 同一プログラム実行 | 全ワーカーで同一のプログラムを実行する必要がある | 常時 |
| BR-68-03 | 同一GPU数 | 全ワーカーで同じ数のアクセラレータを使用する | 常時 |
| BR-68-04 | 全ワーカー保存 | チェックポイント保存は全ワーカーで実行する必要がある | チェックポイント保存時 |
| BR-68-05 | Eager先行初期化 | Eagerモードでは他のTensorFlow APIより先にストラテジーを作成する | Eagerモード |

### 計算ロジック

該当なし。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| RuntimeError | TF_CONFIG不正 | TF_CONFIGの形式が不正 | 正しいJSON形式のTF_CONFIGを設定 |
| RuntimeError | ワーカー不到達 | 他のワーカーに接続できない | ネットワーク設定を確認 |

### リトライ仕様

collective通信の障害時はタイムアウト後にエラーが発生する。自動リトライはTensorFlowのcollective実装に依存。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- ワーカー間通信のレイテンシがスケーラビリティに影響
- NCCL使用時はGPU間の高速通信が可能
- communication_optionsで最適な通信アルゴリズムを選択可能

## セキュリティ考慮事項

ワーカー間通信はデフォルトでは暗号化されない。本番環境ではTLS設定が推奨される。

## 備考

- `tf.distribute.experimental.MultiWorkerMirroredStrategy`は非推奨で`tf.distribute.MultiWorkerMirroredStrategy`を使用
- `_collective_key_base`はテスト用のcollectiveキー開始番号

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | collective_all_reduce_strategy.py | `tensorflow/python/distribute/collective_all_reduce_strategy.py` | クラスドキュメント（58-160行目）：MultiWorkerMirroredStrategyの概要、使用例、既知の問題 |

**読解のコツ**: TF_CONFIG環境変数の形式（cluster、taskフィールド）を理解することが重要。`task_type`と`task_id`で各ワーカーを一意に識別する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | collective_all_reduce_strategy.py | `tensorflow/python/distribute/collective_all_reduce_strategy.py` | `CollectiveAllReduceStrategy.__init__`（170-203行目） |

**主要処理フロー**:
- **184-185行目**: communication_optionsのデフォルト設定
- **186-192行目**: CollectiveAllReduceExtendedの初期化
- **194-203行目**: メトリクスゲージへのストラテジー情報設定（ワーカー数、レプリカ数）

#### Step 3: 実験的APIとの互換性

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | collective_all_reduce_strategy.py | `tensorflow/python/distribute/collective_all_reduce_strategy.py` | `_CollectiveAllReduceStrategyExperimental`（236-268行目）：非推奨の実験的API |

**主要処理フロー**:
- **226-233行目**: instancecheckのオーバーライドで旧APIとの互換性を確保
- **244-245行目**: @deprecatedデコレータで非推奨警告

### プログラム呼び出し階層図

```
tf.distribute.MultiWorkerMirroredStrategy(cluster_resolver, communication_options)
    │
    ├─ CollectiveAllReduceExtended.__init__()
    │      ├─ TFConfigClusterResolver  [クラスタ構成解析]
    │      ├─ _initialize_local()  [ローカルデバイス初期化]
    │      └─ collective通信グループ設定
    │
    ├─ scope()  [distribute_lib.Strategy.scope()]
    │
    ├─ run(fn, args)  [distribute_lib.Strategy.run()]
    │      └─ mirrored_strategy._MirroredReplicaThread  [レプリカ実行]
    │
    └─ reduce()  [CrossDeviceOps経由でAll-Reduce]
           └─ CollectiveAllReduce
```

### データフロー図

```
[Worker 0]                [処理]                        [Worker 1]

GPU 0: forward/backward ──▶                           ◀── GPU 0: forward/backward
GPU 1: forward/backward ──▶  collective All-Reduce    ◀── GPU 1: forward/backward
                               (NCCL/RING/AUTO)
                                    │
                                    ▼
                          集約済み勾配を全レプリカに配布
                                    │
GPU 0: 変数更新 ◀──────────────────┘──────────────────▶ GPU 0: 変数更新
GPU 1: 変数更新 ◀──────────────────────────────────────▶ GPU 1: 変数更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| collective_all_reduce_strategy.py | `tensorflow/python/distribute/collective_all_reduce_strategy.py` | ソース | MultiWorkerMirroredStrategyの実装 |
| distribute_lib.py | `tensorflow/python/distribute/distribute_lib.py` | ソース | Strategyベースクラス |
| cross_device_ops.py | `tensorflow/python/distribute/cross_device_ops.py` | ソース | クロスデバイス通信操作 |
| mirrored_strategy.py | `tensorflow/python/distribute/mirrored_strategy.py` | ソース | MirroredStrategy（基盤） |
| collective_util.py | `tensorflow/python/distribute/collective_util.py` | ソース | collective通信ユーティリティ |
| multi_worker_util.py | `tensorflow/python/distribute/multi_worker_util.py` | ソース | マルチワーカーユーティリティ |
| cross_device_utils.py | `tensorflow/python/distribute/cross_device_utils.py` | ソース | クロスデバイスユーティリティ |
