# 機能設計書 69-CentralStorageStrategy

## 概要

本ドキュメントは、TensorFlowにおけるパラメータをCPUに集約する分散戦略CentralStorageStrategyの設計を記述する。

### 本機能の処理概要

CentralStorageStrategyは、単一マシン内でパラメータ（変数）を1つのデバイス（CPUまたは単一GPU）に集約配置し、計算操作を複数のGPUにレプリケーションする分散学習ストラテジーである。MirroredStrategyとは異なり、変数を各デバイスにミラーリングせず、1箇所に集中管理する。

**業務上の目的・背景**：大規模なモデルパラメータを全GPUにミラーリングするとGPUメモリが圧迫される場合がある。CentralStorageStrategyでは変数をCPU（またはGPUが1つの場合はそのGPU）に集約することで、GPUメモリの使用を抑えつつデータ並列学習を実現する。ただし、変数へのアクセスにデバイス間通信が発生するため、MirroredStrategyに比べて通信オーバーヘッドが大きくなる可能性がある。

**機能の利用シーン**：GPUメモリが限られている環境でのマルチGPU学習、パラメータサイズが大きいモデルの学習、GPUが1つしかない場合の軽量ストラテジーとしての使用。

**主要な処理内容**：
1. 利用可能なコンピュートデバイス（GPU）とパラメータデバイス（CPU/GPU）の設定
2. 変数のパラメータデバイスへの集約配置
3. データセットの分散配布と各コンピュートデバイスへのプリフェッチ
4. 各GPUでの計算実行と結果の集約

**関連システム・外部連携**：ParameterServerStrategyExtendedを内部的に使用。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに該当なし |

## 機能種別

計算処理（分散学習フレームワーク）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| compute_devices | list[str] | No | 計算を行うデバイスのリスト（デフォルト: 全ローカルGPU、GPUなしならCPU） | デバイス文字列のリスト |
| parameter_device | str | No | 変数を配置するデバイス（デフォルト: CPUまたは単一GPU） | デバイス文字列 |

### 入力データソース

ローカルマシンのデバイス構成情報。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| strategy | CentralStorageStrategy | 構成済みの集約配置分散ストラテジー |

### 出力先

Python上のStrategyオブジェクト。

## 処理フロー

### 処理シーケンス

```
1. CentralStorageStrategy のインスタンス化
   └─ 1-1. compute_devices の設定（デフォルト: 全ローカルGPU）
   └─ 1-2. parameter_device の設定（デフォルト: CPU）
   └─ 1-3. ParameterServerStrategyExtended の初期化
2. strategy.scope() による変数作成
   └─ 変数はparameter_device上に1つだけ作成される
3. データセットの分散配布
   └─ experimental_distribute_dataset でコンピュートデバイスにプリフェッチ
4. strategy.run() による計算実行
   └─ 各コンピュートデバイスで計算を実行
5. 結果の集約
   └─ 各レプリカの結果をPerReplicaとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[CentralStorageStrategy 初期化] --> B[compute_devices 設定]
    B --> C[parameter_device 設定]
    C --> D[ParameterServerStrategyExtended 初期化]
    D --> E[strategy.scope 入場]
    E --> F[変数をparameter_deviceに作成]
    F --> G[データセット分散配布]
    G --> H[strategy.run 計算実行]
    H --> I[各compute_deviceで計算]
    I --> J[結果集約]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-69-01 | デバイス自動検出 | compute_devices未指定時は全ローカルGPUを使用、GPUなしならCPU | 常時 |
| BR-69-02 | パラメータデバイスデフォルト | parameter_device未指定時はCPUまたは単一GPU | 常時 |
| BR-69-03 | PER_REPLICA非サポート | InputReplicationMode.PER_REPLICAはexperimental_distribute_datasetで非サポート | PER_REPLICA指定時 |

### 計算ロジック

該当なし。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotImplementedError | PER_REPLICA非サポート | experimental_distribute_datasetでPER_REPLICAを指定 | experimental_distribute_datasets_from_functionを使用 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- 変数がCPUに集約されるため、GPUからのアクセスにPCIe帯域幅の制約を受ける
- MirroredStrategyに比べて通信オーバーヘッドが大きくなる可能性がある
- GPUメモリ節約のトレードオフとして使用

## セキュリティ考慮事項

単一マシン内での使用のため、ネットワークセキュリティの懸念はない。

## 備考

- `tf.distribute.experimental.CentralStorageStrategy`として実験的APIで公開
- 内部的にParameterServerStrategyExtendedを使用しているが、パラメータサーバーアーキテクチャとは異なる（単一マシン内でのパラメータ集約）
- `distribution_strategy_gauge`に"CentralStorageStrategy"として記録される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | central_storage_strategy.py | `tensorflow/python/distribute/central_storage_strategy.py` | クラスドキュメント（24-49行目）：CentralStorageStrategyの概要と使用例 |

**読解のコツ**: CentralStorageStrategyはdistribute_lib.Strategyを継承するが、内部的にはParameterServerStrategyExtendedを使用している。この関係を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | central_storage_strategy.py | `tensorflow/python/distribute/central_storage_strategy.py` | `CentralStorageStrategy.__init__`（51-67行目） |

**主要処理フロー**:
- **52-55行目**: ParameterServerStrategyExtendedの初期化（compute_devices、parameter_deviceを渡す）
- **65行目**: 親クラスのStrategy.__init__にextendedを渡す
- **66-67行目**: メトリクスゲージに"CentralStorageStrategy"を設定

#### Step 3: 主要メソッドのオーバーライド

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | central_storage_strategy.py | `tensorflow/python/distribute/central_storage_strategy.py` | `experimental_distribute_dataset`（73-109行目） |
| 3-2 | central_storage_strategy.py | `tensorflow/python/distribute/central_storage_strategy.py` | `experimental_local_results`（111-120行目） |

**主要処理フロー**:
- **101-107行目**: PER_REPLICAモードの場合NotImplementedErrorを発生
- **108行目**: 親クラスのexperimental_distribute_datasetに委譲

### プログラム呼び出し階層図

```
tf.distribute.experimental.CentralStorageStrategy(compute_devices, parameter_device)
    │
    ├─ ParameterServerStrategyExtended(self, compute_devices, parameter_device)
    │      └─ 変数配置戦略の設定
    │
    ├─ scope()  [distribute_lib.Strategy.scope()]
    │      └─ 変数をparameter_deviceに作成
    │
    ├─ experimental_distribute_dataset(dataset)
    │      └─ 親クラスのexperimental_distribute_datasetに委譲
    │
    └─ run(fn, args)
           └─ 各compute_deviceでfn実行
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Model definition ────────────▶ scope() ──▶ Variables on CPU
                                │
Dataset ─────────────────────▶ distribute_dataset ──▶ DistributedDataset
                                │
                           ┌────┴────┐
                           │ GPU 0   │ GPU 1   │  ... (compute_devices)
                           │ fn実行  │ fn実行  │
                           └────┬────┘
                                │
Variables on CPU ◀──────────────┘  (変数の読み書きはCPU経由)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| central_storage_strategy.py | `tensorflow/python/distribute/central_storage_strategy.py` | ソース | CentralStorageStrategyの実装 |
| distribute_lib.py | `tensorflow/python/distribute/distribute_lib.py` | ソース | Strategyベースクラス |
| parameter_server_strategy.py | `tensorflow/python/distribute/parameter_server_strategy.py` | ソース | ParameterServerStrategyExtended（内部使用） |
| device_util.py | `tensorflow/python/distribute/device_util.py` | ソース | デバイスユーティリティ |
