# 機能設計書 73-クラスタリゾルバ

## 概要

本ドキュメントは、TensorFlowにおけるクラスタリゾルバ（Cluster Resolver）機能の設計について記述する。クラスタリゾルバは、クラスタ構成の動的解決とTF_CONFIGの管理を提供する抽象化レイヤーである。

### 本機能の処理概要

**業務上の目的・背景**：分散TensorFlow環境では、GCE、AWS、Kubernetes、Slurm、SageMaker、TPU等の多様なクラスタ管理システムと連携する必要がある。クラスタリゾルバは、これらの異なるシステムからクラスタのIPアドレス・ホスト名を動的に解決し、TensorFlowに必要な接続情報を提供する。これにより、ユーザは基盤インフラを意識せずに分散学習を構築できる。

**機能の利用シーン**：MultiWorkerMirroredStrategy等の分散ストラテジーの初期化時にクラスタ情報を提供する。また、TPUClusterResolverを通じてCloud TPUに接続する際や、KubernetesClusterResolverでKubernetes上のワーカーを検出する際に使用される。

**主要な処理内容**：
1. クラスタ構成（ClusterSpec）の動的解決と取得
2. マスターアドレスの解決
3. アクセラレータ（GPU/TPU）数の検出
4. タスクタイプ・タスクIDの管理
5. RPCレイヤーの設定
6. 複数クラスタリゾルバの統合（UnionClusterResolver）

**関連システム・外部連携**：GCE API、AWS API、Kubernetes API、Slurm、SageMaker、Cloud TPU

**権限による制御**：task_type/task_idにより各ワーカーの役割が決定される。

## 関連画面

本機能はバックエンドの構成管理コンポーネントであるため、直接的な関連画面は存在しない。

## 機能種別

構成管理 / デバイス検出

## 入力仕様

### 入力パラメータ（SimpleClusterResolver）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| cluster_spec | ClusterSpec | Yes | クラスタ構成 | tf.train.ClusterSpecインスタンスであること |
| master | string | No | マスターアドレス | 文字列型であること |
| task_type | string | No | タスクタイプ | chief/worker/ps/evaluator |
| task_id | int | No | タスクインデックス | 0以上の整数 |
| environment | string | No | 環境タイプ | "google"または空文字列 |
| num_accelerators | dict | No | アクセラレータ数 | {"GPU": N}形式 |
| rpc_layer | string | No | RPCプロトコル | "grpc"等 |

### 入力データソース

- プログラム引数として直接指定されたClusterSpec
- 各クラスタ管理システムのAPI（GCE、Kubernetes等）
- TF_CONFIG環境変数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cluster_spec | ClusterSpec | 解決されたクラスタ構成 |
| master | string | セッションマスターのURL |
| num_accelerators | dict | アクセラレータ種別ごとの数 |
| task_type | string | 現在のタスクタイプ |
| task_id | int | 現在のタスクID |

### 出力先

分散ストラテジーや分散コーディネータへの入力として使用される

## 処理フロー

### 処理シーケンス

```
1. クラスタリゾルバの初期化
   └─ クラスタ管理システムに応じた具象クラスの作成
2. クラスタ構成の解決
   └─ cluster_spec()メソッドでClusterSpecを取得
   └─ 管理システムAPIからIPアドレス・ポート情報を動的に取得
3. マスターアドレスの解決
   └─ master()メソッドでセッションマスターURLを取得
   └─ rpc_layerプレフィックスの付与
4. アクセラレータの検出
   └─ num_accelerators()メソッドでデバイス情報を取得
   └─ Eager Mode: tf.config.list_logical_devicesから取得
   └─ Graph Mode: Session.list_devicesから取得
```

### フローチャート

```mermaid
flowchart TD
    A[クラスタリゾルバ初期化] --> B{リゾルバ種別}
    B -->|Simple| C[直接指定されたClusterSpecを使用]
    B -->|TFConfig| D[TF_CONFIGから読み取り]
    B -->|GCE| E[GCE APIからインスタンス情報取得]
    B -->|Kubernetes| F[K8s APIからPod情報取得]
    B -->|TPU| G[Cloud TPU APIから接続情報取得]
    B -->|Union| H[複数リゾルバのClusterSpecを統合]
    C --> I[ClusterSpec返却]
    D --> I
    E --> I
    F --> I
    G --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-73-01 | 動的解決 | cluster_spec()は呼び出し毎に最新のクラスタ状態を返す | 全リゾルバ |
| BR-73-02 | Union統合 | 同一ジョブ名のワーカーリストが全てリストの場合は結合、辞書の場合はキー重複チェック | UnionClusterResolver |
| BR-73-03 | プロパティ委譲 | UnionClusterResolverのtask_type/task_idは最初のリゾルバから取得 | UnionClusterResolver |
| BR-73-04 | マスターURL形式 | rpc_layer指定時は"{rpc_layer}://{address}"形式で返却 | master()メソッド |
| BR-73-05 | CPUフィルタ | num_accelerators()はCPU/XLA_CPUデバイスを除外 | Eager Mode時 |

### 計算ロジック

特段の計算ロジックなし。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TypeError | 型不正 | cluster_specがClusterSpecインスタンスでない | ClusterSpecオブジェクトを渡す |
| TypeError | 型不正 | masterが文字列でない | 文字列を渡す |
| TypeError | 型不正 | UnionResolverの引数がClusterResolverでない | ClusterResolverサブクラスを渡す |
| ValueError | 値不正 | UnionResolverに引数が渡されない | 最低1つのClusterResolverを渡す |
| KeyError | キー重複 | UnionClusterResolverでジョブのワーカーキーが重複 | 重複しないキーを使用 |

### リトライ仕様

クラスタ管理システムAPIの呼び出しに対するリトライは各具象クラスの実装に依存する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- cluster_spec()は毎回最新情報を取得するため、頻繁な呼び出しは避けるべき
- キャッシュ戦略は各具象クラスの実装に依存

## セキュリティ考慮事項

- クラスタ管理システムAPIへのアクセスには適切な認証情報が必要
- TF_CONFIGにはクラスタのホスト名・ポート情報が含まれるため、環境変数の保護が必要

## 備考

- 抽象基底クラスClusterResolverは具象実装のインターフェースを定義
- SimpleClusterResolverは静的なClusterSpecに対するシンプルな実装
- UnionClusterResolverは複数リゾルバの統合を提供
- 各クラウドプロバイダ向けのリゾルバ（GCE、Kubernetes、Slurm、SageMaker、TPU）が提供されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | 抽象基底クラスClusterResolverのインターフェースを理解する（55-286行目） |

**読解のコツ**: `@abc.abstractmethod`デコレータが付いたメソッド（cluster_spec、master）が必須実装メソッド。`@property`デコレータのtask_type、task_id、environment等はデフォルト実装がある。

#### Step 2: 具象実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | SimpleClusterResolver（288-416行目）の静的ClusterSpec管理 |
| 2-2 | cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | UnionClusterResolver（418-624行目）の統合ロジック |

**主要処理フロー**:
1. **320-339行目**: SimpleClusterResolverの初期化（ClusterSpecの検証と保持）
2. **345-366行目**: master()メソッド（task_type/task_id指定時はClusterSpecから解決）
3. **495-567行目**: UnionClusterResolver.cluster_spec()の統合ロジック（リスト/辞書判定と重複チェック）

#### Step 3: クラウドプロバイダ向けリゾルバを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tfconfig_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/tfconfig_cluster_resolver.py` | TF_CONFIGからの解決 |
| 3-2 | gce_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/gce_cluster_resolver.py` | GCEインスタンスからの解決 |
| 3-3 | kubernetes_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/kubernetes_cluster_resolver.py` | KubernetesのPod情報からの解決 |
| 3-4 | tpu_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/tpu_cluster_resolver.py` | Cloud TPUの接続情報解決 |
| 3-5 | slurm_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/slurm_cluster_resolver.py` | Slurmジョブからの解決 |
| 3-6 | sagemaker_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/sagemaker_cluster_resolver.py` | SageMaker環境からの解決 |

#### Step 4: ユーティリティ関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | format_master_url関数（31-35行目）のURL構築 |
| 4-2 | cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | get_accelerator_devices関数（38-52行目）のデバイス検出 |

### プログラム呼び出し階層図

```
ClusterResolver (抽象基底)
    │
    ├─ SimpleClusterResolver
    │      ├─ cluster_spec() → 保持されたClusterSpecを返却
    │      ├─ master() → task_type/task_idからアドレス解決
    │      └─ num_accelerators() → コンストラクタ指定値を返却
    │
    ├─ UnionClusterResolver
    │      ├─ cluster_spec() → 全子リゾルバのClusterSpecを統合
    │      └─ master() → 最初の子リゾルバに委譲
    │
    ├─ TFConfigClusterResolver
    │      └─ cluster_spec() → TF_CONFIGから読み取り
    │
    ├─ GCEClusterResolver
    │      └─ cluster_spec() → GCE APIからインスタンス解決
    │
    ├─ KubernetesClusterResolver
    │      └─ cluster_spec() → K8s APIからPod解決
    │
    ├─ TPUClusterResolver
    │      └─ cluster_spec() → Cloud TPU APIから解決
    │
    ├─ SlurmClusterResolver
    │      └─ cluster_spec() → Slurm環境変数から解決
    │
    └─ SageMakerClusterResolver
           └─ cluster_spec() → SageMaker環境変数から解決
```

### データフロー図

```
[入力]                       [処理]                          [出力]

クラスタ管理API ──────▶  ClusterResolver.cluster_spec()  ──▶  ClusterSpec
TF_CONFIG ─────────▶       └─ 動的IPアドレス解決          ──▶  master URL
静的ClusterSpec ───▶                                      ──▶  num_accelerators
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/cluster_resolver.py` | ソース | 基底クラスとSimple/Union実装 |
| __init__.py | `tensorflow/python/distribute/cluster_resolver/__init__.py` | ソース | パッケージ初期化・エクスポート |
| tfconfig_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/tfconfig_cluster_resolver.py` | ソース | TF_CONFIGリゾルバ |
| gce_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/gce_cluster_resolver.py` | ソース | GCEリゾルバ |
| kubernetes_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/kubernetes_cluster_resolver.py` | ソース | Kubernetesリゾルバ |
| tpu_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/tpu_cluster_resolver.py` | ソース | TPUリゾルバ |
| slurm_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/slurm_cluster_resolver.py` | ソース | Slurmリゾルバ |
| sagemaker_cluster_resolver.py | `tensorflow/python/distribute/cluster_resolver/sagemaker_cluster_resolver.py` | ソース | SageMakerリゾルバ |
