# 機能設計書 78-AOTコンパイル

## 概要

本ドキュメントは、TensorFlowにおけるAOT（Ahead-of-Time）コンパイル機能の設計について記述する。AOTコンパイルは、tfcompileツールを通じてTensorFlowグラフを事前にネイティブコードにコンパイルし、ランタイムなしで実行可能なオブジェクトファイルとヘッダファイルを生成する。

### 本機能の処理概要

**業務上の目的・背景**：推論時のレイテンシを最小化し、TensorFlowランタイムへの依存を排除するため、AOTコンパイルはTFグラフをC/C++から直接呼び出し可能なネイティブコードに変換する。これにより、組み込みシステムや低レイテンシが要求されるサービング環境でTFモデルを実行できる。

**機能の利用シーン**：組み込みデバイスでの推論実行、低レイテンシサービング、TFランタイム依存の排除、CPU向け推論バイナリの生成。

**主要な処理内容**：
1. GraphDefの読み込みとTF2XLA Config設定
2. TF Op → XLA HLO変換
3. HLO → LLVM IR変換
4. LLVM IR → ネイティブオブジェクトコード生成
5. C++ヘッダファイル（アクセサクラス）の生成
6. 定数バッファの埋め込み

**関連システム・外部連携**：XLAコンパイラ、LLVM、CPU向けバックエンド

**権限による制御**：特段の権限制御はない。

## 関連画面

本機能はコマンドラインツール（tfcompile）として提供されるため、直接的な関連画面は存在しない。

## 機能種別

コンパイラツール / コード生成

## 入力仕様

### 入力パラメータ（tfcompileコマンドライン）

| パラメータ名 | 型 | 必須 | 説明 | デフォルト値 |
|-------------|-----|-----|------|------------|
| --graph | string | Yes | 入力GraphDefファイルパス | なし |
| --config | string | Yes | TF2XLA Config protobufファイル | なし |
| --cpp_class | string | Yes | 生成されるC++クラスの完全修飾名 | なし |
| --target_triple | string | No | ターゲットアーキテクチャ | x86_64-pc-linux |
| --out_function_object | string | No | 出力オブジェクトファイル名 | out_model.o |
| --out_metadata_object | string | No | メタデータオブジェクトファイル名 | out_helper.o |
| --out_header | string | No | 出力ヘッダファイル名 | out.h |
| --entry_point | string | No | エントリーポイント関数名 | entry |
| --debug_info_path_begin_marker | string | No | デバッグ情報パスマーカー | "" |

### 入力データソース

- TensorFlowのGraphDef（protobuf形式）
- TF2XLA Config（入出力テンソルの名前・型・形状を指定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| function object | .o | コンパイル済みモデル関数のオブジェクトファイル |
| metadata object | .o | メタ情報のオブジェクトファイル |
| header file | .h | C++アクセサクラスのヘッダファイル |

### CompileResult構造体

| フィールド | 型 | 説明 |
|-----------|-----|------|
| aot | CpuAotCompilationResult | オブジェクトファイルとメタ情報 |
| program_shape | ProgramShapeProto | 引数と結果の静的形状 |
| entry_point | string | 生成された関数名 |
| pointer_size | int | ポインタサイズ（バイト） |

### 出力先

ファイルシステムに.oファイルと.hファイルを出力

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数の解析
   └─ MainFlagsの設定とXLAデバッグオプションの適用
2. GraphDefとConfigの読み込み
   └─ protobufファイルからGraphDefとTF2XLA Configをデシリアライズ
3. TF→XLA変換
   └─ tf2xla::ConvertGraphDefToXlaでGraphDefをXlaComputationに変換
4. XLAコンパイル
   └─ CompileXla関数でXlaComputationをAOTコンパイル
   └─ CompileOnlyClient経由でCpuAotCompilationResultを取得
5. コード生成
   └─ codegen.hのGenerateHeader/GenerateObjectでC++コードを生成
6. 定数バッファ埋め込み
   └─ embedded_constant_buffers.hで定数をオブジェクトファイルに埋め込み
7. ファイル出力
   └─ .oファイルと.hファイルをディスクに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[tfcompile起動] --> B[コマンドライン引数解析]
    B --> C[GraphDef / Config読み込み]
    C --> D[量子化処理（optional）]
    D --> E[TF→XLA HLO変換]
    E --> F[XLA AOTコンパイル]
    F --> G[オブジェクトコード生成]
    G --> H[C++ヘッダ生成]
    H --> I[ファイル出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | CPU限定 | AOTコンパイルはCPUターゲットのみ対応 | 常時 |
| BR-78-02 | 静的形状 | 入出力テンソルの形状はコンパイル時に確定している必要がある | 常時 |
| BR-78-03 | ターゲットトリプル | デフォルトはx86_64-pc-linux（s390x除く） | コンパイル時 |
| BR-78-04 | エントリーポイント名 | シンボル名はLLVMの命名規則に従う | コード生成時 |

### 計算ロジック

特段の計算ロジックなし。XLAの最適化パイプライン（Fusion、定数折り畳み等）が適用される。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 引数不正 | 必須引数が未指定 | --helpで使用法を確認 |
| NotFound | ファイル不在 | GraphDefまたはConfigファイルが存在しない | パスを確認 |
| Internal | コンパイル失敗 | XLAコンパイルが失敗 | グラフの簡素化やOp確認 |

### リトライ仕様

コマンドラインツールのため、ユーザが手動で再実行する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- AOTコンパイル済みバイナリはTFランタイムオーバーヘッドがないため、低レイテンシ推論が可能
- コンパイル時間はグラフの複雑度に依存

## セキュリティ考慮事項

- 生成されるオブジェクトファイルはネイティブコードを含むため、適切なファイルアクセス制御が必要

## 備考

- tf_library Bazelマクロがtfcompileの呼び出しを自動化
- fast mathフラグがデフォルトで有効（tf_libraryマクロ経由時）
- 量子化オプション（QuantizeXlaFn）のサポート
- LLVMの初期化はグローバルに一度のみ（absl::call_once）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | compile.h | `tensorflow/compiler/aot/compile.h` | CompileResult構造体（37-43行目）を理解する |
| 1-2 | flags.h | `tensorflow/compiler/aot/flags.h` | MainFlags構造体を理解する |

**読解のコツ**:
- **37行目**: CompileResult.aot はCpuAotCompilationResult型で、コンパイル済みオブジェクトとメタ情報を保持
- **40行目**: program_shapeは引数と結果の静的形状を示すProto
- **41行目**: entry_pointはLLVMシンボル名
- **42行目**: pointer_sizeはターゲットアーキテクチャのポインタサイズ

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tfcompile_main.cc | `tensorflow/compiler/aot/tfcompile_main.cc` | main関数の全体フロー |

**主要処理フロー**:
1. **48-56行目**: MainFlagsのデフォルト値設定（target_triple, out_function_object等）
2. **60-62行目**: フラグリスト構築（MainFlags + XLAデバッグオプション）
3. **70-71行目**: コマンドライン引数の解析
4. **76行目**: Main(flags)の呼び出し

#### Step 3: コンパイルロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | compile.cc | `tensorflow/compiler/aot/compile.cc` | CompileGraph/CompileXla関数の実装 |

**主要処理フロー**:
1. **67-73行目**: 量子化関数（QuantizeXlaFn）のレジストリ
2. **78-80行目**: CompileXla関数（XlaComputation→CpuAotCompilationResult）
3. CompileGraph関数: GraphDef→XlaComputation→AOTコンパイル→CompileResult

#### Step 4: コード生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | codegen.h | `tensorflow/compiler/aot/codegen.h` | ヘッダファイル生成 |
| 4-2 | embedded_constant_buffers.h | `tensorflow/compiler/aot/embedded_constant_buffers.h` | 定数バッファ埋め込み |

### プログラム呼び出し階層図

```
tfcompile_main.cc
    │
    └─ Main(flags) [compile.h/compile.cc]
           │
           ├─ GraphDef / Config読み込み
           │
           ├─ [optional] QuantizeXla (量子化)
           │
           ├─ CompileGraph(graph_def, config, flags, result)
           │      │
           │      ├─ tf2xla::ConvertGraphDefToXla (TF→HLO変換)
           │      │      └─ tensorflow/compiler/tf2xla/tf2xla.h
           │      │
           │      └─ CompileXla(client, computation, aot_opts, result)
           │             └─ CompileOnlyClient::CompileAheadOfTime
           │                    └─ xla::Compiler → LLVM → Object Code
           │
           ├─ codegen::GenerateHeader(result, ...) → .h ファイル
           │
           └─ EmbedConstantBuffers(result, ...) → .o ファイル
```

### データフロー図

```
[入力]                     [処理]                              [出力]

GraphDef (.pb) ──▶  TF→XLA変換  ──▶  HLO
Config (.pbtxt) ──▶       │              │
                          └─ AOTコンパイル └─ LLVM IR ──▶  .o (object)
                                                            .h (header)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tfcompile_main.cc | `tensorflow/compiler/aot/tfcompile_main.cc` | ソース | メインエントリーポイント |
| compile.h | `tensorflow/compiler/aot/compile.h` | ヘッダ | CompileResult/CompileGraph定義 |
| compile.cc | `tensorflow/compiler/aot/compile.cc` | ソース | コンパイルロジック実装 |
| codegen.h | `tensorflow/compiler/aot/codegen.h` | ヘッダ | C++ヘッダ生成 |
| codegen.cc | `tensorflow/compiler/aot/codegen.cc` | ソース | C++ヘッダ生成実装 |
| embedded_constant_buffers.h | `tensorflow/compiler/aot/embedded_constant_buffers.h` | ヘッダ | 定数バッファ埋め込み |
| flags.h | `tensorflow/compiler/aot/flags.h` | ヘッダ | コマンドラインフラグ定義 |
| quantize.h | `tensorflow/compiler/aot/quantize.h` | ヘッダ | 量子化関数インターフェース |
| tf2xla.h | `tensorflow/compiler/tf2xla/tf2xla.h` | ヘッダ | TF→XLA変換 |
