# 機能設計書 80-TFLiteモデル変換

## 概要

本ドキュメントは、TensorFlowにおけるTFLite（TensorFlow Lite）モデル変換機能の設計について記述する。TFLiteモデル変換は、TensorFlowモデル（SavedModel、Keras、ConcreteFunction）をTFLite FlatBuffer形式に変換し、モバイル・組み込みデバイス向けに最適化するコンバータである。

### 本機能の処理概要

**業務上の目的・背景**：モバイルデバイス、IoTデバイス、マイクロコントローラ等のリソース制約環境でのモデル推論を実現するため、TFモデルをコンパクトで高速なTFLite形式に変換する。量子化（INT8/UINT8/FP16）による推論高速化・モデルサイズ削減、Opフュージョン、デリゲート（GPU/NNAPI/XNNPACK等）への対応が主要な最適化である。

**機能の利用シーン**：Android/iOSアプリでのオンデバイス推論、Edge TPU向けモデル生成、マイクロコントローラ向けモデル変換、WebAssemblyでのブラウザ内推論。

**主要な処理内容**：
1. TFLiteConverter: SavedModel/Keras/ConcreteFunction/GraphDefからの変換
2. 量子化: ポストトレーニング量子化（動的範囲/全整数/FP16）
3. Op変換: TF OpをTFLite Opに変換、Select TF Ops対応
4. グラフ最適化: Opフュージョン、定数折り畳み、デッドコード除去
5. FlatBuffer出力: TFLite FlatBuffer形式のモデルファイル生成
6. モデルI/O型変更: 入出力テンソルの型変換

**関連システム・外部連携**：MLIR（内部変換パイプライン）、FlatBuffers、TFLite Runtime、デリゲート（GPU、NNAPI、XNNPACK、Coral Edge TPU）

**権限による制御**：特段の権限制御はない。

## 関連画面

本機能はPython APIおよびコマンドラインツールとして提供されるため、直接的な関連画面は存在しない。

## 機能種別

モデル変換 / 最適化

## 入力仕様

### 入力パラメータ（TFLiteConverter）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| saved_model_dir / model / func | string/Model/ConcreteFunction | Yes | 入力モデル | 有効なTFモデル |
| optimizations | set[Optimize] | No | 最適化オプション | DEFAULT, OPTIMIZE_FOR_SIZE等 |
| target_spec.supported_ops | set[OpsSet] | No | サポートするOp集合 | TFLITE_BUILTINS, SELECT_TF_OPS等 |
| target_spec.supported_types | set[DType] | No | サポートする型 | FLOAT16, INT8等 |
| representative_dataset | Callable | No | 代表データセット（量子化用） | キャリブレーションデータ生成関数 |
| inference_input_type | DType | No | 入力テンソルの推論型 | FLOAT32, UINT8, INT8 |
| inference_output_type | DType | No | 出力テンソルの推論型 | FLOAT32, UINT8, INT8 |
| allow_custom_ops | bool | No | カスタムOp許可 | デフォルトFalse |
| experimental_new_converter | bool | No | MLIR変換器使用 | デフォルトTrue |

### OpsSet列挙

| 値 | 説明 |
|-----|------|
| TFLITE_BUILTINS | TFLite組み込みOp |
| SELECT_TF_OPS | TF Select Ops（TFカーネルフォールバック） |
| TFLITE_BUILTINS_INT8 | INT8量子化済みOp |
| EXPERIMENTAL_TFLITE_BUILTINS_ACTIVATIONS_INT16_WEIGHTS_INT8 | INT16アクティベーション/INT8ウェイト |

### Optimize列挙

| 値 | 説明 |
|-----|------|
| DEFAULT | デフォルト最適化（ポストトレーニング量子化有効化） |
| OPTIMIZE_FOR_SIZE | サイズ最適化（DEFAULTのエイリアス） |
| OPTIMIZE_FOR_LATENCY | レイテンシ最適化（DEFAULTのエイリアス） |
| EXPERIMENTAL_SPARSITY | スパース性最適化 |

### 入力データソース

- TensorFlowのSavedModel
- Kerasモデル（tf.keras.Model）
- ConcreteFunction（tf.function.get_concrete_function）
- Frozen GraphDef

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TFLite Model | bytes | FlatBuffer形式のTFLiteモデルバイナリ |

### 出力先

- ファイルシステム（.tfliteファイル）
- メモリ上のバイト列（convert()メソッドの戻り値）

## 処理フロー

### 処理シーケンス

```
1. モデルの読み込み
   ├─ SavedModel: from_saved_model()でロード
   ├─ Keras: from_keras_model()でロード
   └─ ConcreteFunction: from_concrete_functions()でロード
2. グラフの前処理
   └─ フリーズ（変数の定数化）
   └─ Grappler最適化
   └─ 入力形状の設定
3. 変換フラグの構築
   └─ _build_conversion_flagsで量子化・Opフラグを設定
4. MLIR変換パイプライン
   └─ 型変換（TF型→TFLite型マッピング）
   └─ TF Op→TFLite Op変換
   └─ Opフュージョン
   └─ 量子化パス（指定時）
5. 量子化（指定時）
   ├─ 動的範囲量子化: ウェイトのみINT8化
   ├─ 全整数量子化: ウェイト+アクティベーションのINT8化
   │   └─ representative_datasetによるキャリブレーション
   └─ FP16量子化: ウェイトのFP16化
6. 後処理
   └─ バッファ重複排除（deduplicate_readonly_buffers）
   └─ スパース化（指定時）
   └─ モデルI/O型変更（指定時）
7. FlatBuffer出力
   └─ TFLite FlatBuffer形式でシリアライズ
```

### フローチャート

```mermaid
flowchart TD
    A[モデル入力] --> B{入力形式}
    B -->|SavedModel| C[from_saved_model]
    B -->|Keras| D[from_keras_model]
    B -->|ConcreteFunction| E[from_concrete_functions]
    C --> F[グラフ前処理・フリーズ]
    D --> F
    E --> F
    F --> G[変換フラグ構築]
    G --> H[MLIR変換パイプライン]
    H --> I{量子化指定?}
    I -->|Yes| J{量子化モード}
    I -->|No| K[FlatBuffer出力]
    J -->|動的範囲| L[ウェイトINT8化]
    J -->|全整数| M[キャリブレーション→全INT8化]
    J -->|FP16| N[ウェイトFP16化]
    L --> K
    M --> K
    N --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-01 | 量子化入力統計 | INT8量子化でpost_training_quantize=Falseの場合、quantized_input_statsが必要 | 量子化時 |
| BR-80-02 | 代表データセット | 全整数量子化にはrepresentative_datasetの指定が必須 | 全整数量子化時 |
| BR-80-03 | Op互換性 | TFLITE_BUILTINSに含まれないOpはSELECT_TF_OPSの指定が必要 | Op変換時 |
| BR-80-04 | 型マッピング | TF型はTFLite型にマッピングされる（float32→FLOAT, int8→INT8等） | 変換時 |
| BR-80-05 | MLIRコンバータ | experimental_new_converter=TrueでMLIRベースの変換器を使用 | デフォルト |

### 型マッピング（TF→TFLite）

| TF型 | TFLite型 |
|------|---------|
| float16 | FLOAT16 |
| float32 | FLOAT |
| float64 | FLOAT64 |
| int8 | INT8 |
| int16 | INT16 |
| int32 | INT32 |
| int64 | INT64 |
| uint8 | UINT8 |
| uint16 | UINT16 |
| uint32 | UINT32 |
| uint64 | UINT64 |
| string | STRING |
| bool | BOOL |
| complex64 | COMPLEX64 |
| complex128 | COMPLEX128 |

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ConverterError | 変換エラー | TF OpがTFLite Opに変換できない | SELECT_TF_OPS追加またはallow_custom_ops |
| ValueError | 型不正 | サポートされないTF型がinference_type等に指定 | サポート型を使用 |
| ValueError | 量子化パラメータ不正 | 全整数量子化でrepresentative_datasetが未指定 | representative_datasetを設定 |
| RuntimeError | モデル読み込み失敗 | SavedModelのロードに失敗 | モデルパス・形式を確認 |

### リトライ仕様

自動リトライ機能は提供されない。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- INT8量子化によりFP32比で最大4倍の推論高速化とモデルサイズ1/4
- FP16量子化によりモデルサイズ約1/2
- XNNPACK/GPUデリゲート使用で追加の高速化

## セキュリティ考慮事項

- TFLiteモデルファイルにはモデルの重みが含まれるため、適切なファイル保護が必要
- モデルのデシリアライズ時にFlatBufferの検証を実施

## 備考

- tflite_convertコマンドラインツールでも変換可能
- MLIR変換器がデフォルトで有効（experimental_new_converter=True）
- StableHLO量子化との統合（quantization_config_pb2使用）
- conversion_metadata_schema_py_generatedによる変換メタデータの記録
- flatbuffer_utilsによるFlatBufferの操作ユーティリティ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lite.py | `tensorflow/lite/python/lite.py` | Optimize列挙型（112-行目）、OpsSet列挙型（convert.pyからインポート）を理解する |
| 1-2 | convert.py | `tensorflow/lite/python/convert.py` | 型マッピングテーブル（64-100行目）を理解する |
| 1-3 | lite_constants.py | `tensorflow/lite/python/lite_constants.py` | 定数定義 |

**読解のコツ**:
- **convert.py 42-61行目**: _is_quantized_input_stats_required関数で量子化パラメータの必要性判定
- **convert.py 64-100行目**: convert_tensor_tf_type_to_tflite_type関数でTF型→TFLite型の変換マッピング（dtypes.float32→FLOAT, dtypes.int8→INT8等）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lite.py | `tensorflow/lite/python/lite.py` | TFLiteConverterクラスの各from_*メソッド |

**主要処理フロー**:
1. **インポート群（1-109行目）**: 大量のインポートがあるが、主要なものはconvert.py（変換ロジック）、util.py（ユーティリティ）、optimize/calibrator.py（量子化キャリブレーション）
2. **112行目以降**: Optimize列挙型（DEFAULT, OPTIMIZE_FOR_SIZE, OPTIMIZE_FOR_LATENCY, EXPERIMENTAL_SPARSITY）

#### Step 3: 変換ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | convert.py | `tensorflow/lite/python/convert.py` | 変換フラグ構築（build_conversion_flags）とMLIR変換呼び出し |

**読解のコツ**:
- wrap_converterモジュールがMLIR C++変換器のPythonバインディング
- _conversion_flags_pb2でConverterFlags protobufを構築
- _model_flags_pb2でModelFlags protobufを構築

#### Step 4: 補助機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | util.py | `tensorflow/lite/python/util.py` | グラフフリーズ、Grappler最適化、形状設定等のユーティリティ |
| 4-2 | interpreter.py | `tensorflow/lite/python/interpreter.py` | 変換後モデルのテスト実行用インタプリタ |
| 4-3 | analyzer.py | `tensorflow/lite/python/analyzer.py` | 変換後モデルの分析 |

### プログラム呼び出し階層図

```
TFLiteConverter (lite.py)
    │
    ├─ from_saved_model() / from_keras_model() / from_concrete_functions()
    │      └─ モデル読み込みと前処理
    │
    ├─ convert()
    │      │
    │      ├─ _freeze_graph() (変数の定数化)
    │      ├─ _run_graph_optimizations() (Grappler最適化)
    │      ├─ _build_conversion_flags() (変換フラグ構築)
    │      │
    │      ├─ _convert_saved_model() / _convert_graphdef()
    │      │      └─ wrap_converter (C++ MLIR変換器)
    │      │             ├─ TF Op → TFLite Op変換
    │      │             ├─ Opフュージョン
    │      │             └─ 量子化パス
    │      │
    │      ├─ [量子化時] _mlir_quantize() (量子化後処理)
    │      ├─ [スパース時] _mlir_sparsify() (スパース化)
    │      ├─ _modify_model_io_type() (I/O型変更)
    │      └─ _deduplicate_readonly_buffers() (バッファ重複排除)
    │
    └─ .tflite バイナリ出力
```

### データフロー図

```
[入力]                      [処理]                               [出力]

SavedModel ──────▶  フリーズ → Grappler最適化  ──▶  最適化GraphDef
Keras Model ─────▶       │
ConcreteFunction ▶       │
                         └─ MLIR変換 → 量子化  ──▶  TFLite FlatBuffer
                                                       (.tfliteファイル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lite.py | `tensorflow/lite/python/lite.py` | ソース | TFLiteConverter メイン実装 |
| convert.py | `tensorflow/lite/python/convert.py` | ソース | 変換ロジック・型マッピング |
| util.py | `tensorflow/lite/python/util.py` | ソース | ユーティリティ（フリーズ、最適化等） |
| lite_constants.py | `tensorflow/lite/python/lite_constants.py` | ソース | 定数定義 |
| interpreter.py | `tensorflow/lite/python/interpreter.py` | ソース | TFLiteインタプリタ |
| analyzer.py | `tensorflow/lite/python/analyzer.py` | ソース | モデル分析 |
| tflite_convert.py | `tensorflow/lite/python/tflite_convert.py` | ソース | コマンドラインツール |
| convert_saved_model.py | `tensorflow/lite/python/convert_saved_model.py` | ソース | SavedModel変換 |
| wrap_converter | C++バインディング | ソース | MLIR C++変換器のPythonラッパー |
| converter_flags.proto | `tensorflow/compiler/mlir/lite/converter_flags.proto` | Proto | 変換フラグ定義 |
| model_flags.proto | `tensorflow/compiler/mlir/lite/model_flags.proto` | Proto | モデルフラグ定義 |
| types.proto | `tensorflow/compiler/mlir/lite/types.proto` | Proto | TFLite型定義 |
