# 機能設計書 82-TFLiteデリゲート

## 概要

本ドキュメントは、TensorFlow Liteのハードウェアデリゲート機能について、その設計・処理内容・インタフェース仕様を記述した機能設計書である。GPU・NNAPI・CoreML・XNNPACKなどのハードウェアアクセラレータへの推論処理のオフロードを提供する。

### 本機能の処理概要

TFLiteデリゲートは、TFLite推論エンジン（機能No.81）の演算処理を特定のハードウェアアクセラレータにオフロードするためのプラグイン機構を提供する機能である。

**業務上の目的・背景**：モバイル・エッジデバイスには、CPUに加えてGPU・DSP・NPUなどの専用ハードウェアが搭載されている。これらのハードウェアを活用することで、推論速度を大幅に向上させ、電力消費を削減できる。デリゲート機構は、この多様なハードウェアに対する統一的なアクセスインタフェースを提供し、アプリケーション開発者がハードウェア固有の最適化を意識せずに恩恵を受けられるようにする。

**機能の利用シーン**：リアルタイム画像処理でのGPUデリゲート利用、Android端末でのNNAPIデリゲートによるNPU活用、iOS端末でのCoreMlデリゲート利用、XNNPACK による最適化されたCPU演算の活用など。

**主要な処理内容**：
1. デリゲートの生成（GPU/NNAPI/XNNPACK/CoreML等のオプション指定）
2. Interpreterへのデリゲートモディファイ（ModifyGraphWithDelegate）
3. サポート対象演算ノードの判定（Prepare/IsNodeSupportedByDelegate）
4. デリゲートカーネルの構築と演算グラフのパーティショニング
5. デリゲート固有バックエンドでの推論実行
6. デリゲートプラグインレジストリによる動的ロード
7. Stable Delegate APIによるバイナリ互換デリゲート

**関連システム・外部連携**：TFLite推論エンジン（No.81）、Android NNAPI、OpenGL ES/OpenCL/Vulkan（GPU）、Apple CoreML、XNNPACK CPUライブラリ、Qualcomm Hexagonなどのハードウェア固有APIと連携する。

**権限による制御**：デリゲートの利用はハードウェア・OSの対応状況に依存する。NNAPI利用にはAndroid 8.1以上が必要。GPU利用にはOpenGL ES 3.1以上またはOpenCL対応が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | TFLiteカメラプレビューフラグメント | 補助画面 | GPU・NNAPIデリゲートの選択切替によるハードウェアアクセラレーション対応 |
| 11 | TFLiteベンチマーク実行画面 | 補助画面 | Hexagonデリゲートの指定・ネイティブライブラリパスの設定 |
| 12 | デリゲート性能ベンチマーク（レイテンシ）画面 | 主画面 | TFLite設定ファイル経由で各種デリゲートのレイテンシ性能を計測・比較 |
| 13 | デリゲート性能ベンチマーク（精度）画面 | 主画面 | TFLite設定ファイル経由で各種デリゲートの精度性能を計測・比較 |
| 14 | Firebase Game Loopベンチマーク画面 | 補助画面 | ベンチマークシナリオ内でのデリゲート設定に対応 |

## 機能種別

計算処理（ハードウェアアクセラレーション制御）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| delegate | TfLiteDelegate* | Yes | デリゲートインスタンス | NULL不可 |
| options | デリゲート固有オプション構造体 | No | GPUオプション、NNAPIオプション等 | デリゲート固有の検証 |
| inference_priority | enum | No | 推論優先度（速度/電力/精度） | 定義済み列挙値 |
| num_threads | int | No | デリゲート内部スレッド数 | >= 1 |

### 入力データソース

TFLite Interpreterから演算グラフ情報を受け取る。デリゲート設定はアプリケーション層から指定される。TFLite設定ファイル（FlatBuffer形式）からもデリゲート設定を読み込み可能。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| status | TfLiteStatus | デリゲート適用結果ステータス |
| delegated_nodes | int[] | デリゲートに委譲されたノード一覧 |
| output_tensors | TfLiteTensor* | デリゲート経由で計算された出力テンソル |

### 出力先

TFLite Interpreter（出力テンソルデータ）。ベンチマーク結果はベンチマークアプリケーションに返却。

## 処理フロー

### 処理シーケンス

```
1. デリゲート生成
   └─ TfLiteGpuDelegateV2Create() / TfLiteNnapiDelegateCreate() 等
2. オプション設定
   └─ デリゲート固有のオプション構造体を設定
3. Interpreterへの適用
   └─ Interpreter::ModifyGraphWithDelegate(delegate) を呼び出し
4. ノードパーティショニング
   └─ サポート対象ノードを判定し、デリゲートカーネルに置換
5. デリゲートカーネル初期化
   └─ デリゲート固有のバックエンド初期化（GPUコンテキスト生成等）
6. 推論時デリゲート実行
   └─ Invoke時にデリゲートカーネルが呼び出される
7. デリゲート解放
   └─ TfLiteGpuDelegateV2Delete() 等
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[デリゲートオプション設定]
    B --> C[デリゲートインスタンス生成]
    C --> D[ModifyGraphWithDelegate]
    D --> E{対象ノード検出?}
    E -->|No| F[CPUフォールバック]
    E -->|Yes| G[ノードパーティショニング]
    G --> H[デリゲートカーネル構築]
    H --> I[AllocateTensors]
    I --> J[Invoke実行]
    J --> K{デリゲート実行成功?}
    K -->|No| L[エラーハンドリング]
    K -->|Yes| M[結果返却]
    F --> I
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-01 | デリゲートフォールバック | デリゲートが対応しない演算はCPUカーネルにフォールバック | 非対応Op検出時 |
| BR-82-02 | デリゲート適用タイミング | デリゲートはAllocateTensors前に適用する必要がある | Interpreter構築後 |
| BR-82-03 | デリゲート排他 | 同一ノードに複数のデリゲートは適用できない | 複数デリゲート使用時 |
| BR-82-04 | Stable Delegate互換性 | Stable Delegate APIを使用したデリゲートはバイナリ互換が保証される | プラグインデリゲート使用時 |

### 計算ロジック

デリゲートパーティショニングでは、デリゲートがサポートするノードの連結成分を特定し、各成分をデリゲートカーネルに置換する。GPUデリゲートではOpenGL/OpenCL/Vulkanシェーダへの演算マッピングが行われる。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（デリゲートはデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| kTfLiteDelegateError | デリゲートエラー | デリゲートの初期化または実行失敗 | CPUフォールバックまたはデリゲート無しで再実行 |
| kTfLiteError | 一般エラー | デリゲートオプション不正 | オプション設定を確認 |
| GPU初期化失敗 | デリゲートエラー | GPUドライバ非対応 | GPU非対応デバイスではGPUデリゲートを使用しない |

### リトライ仕様

デリゲートエラー時はCPUフォールバックが推奨される。自動リトライ機能はない。

## トランザクション仕様

該当なし

## パフォーマンス要件

- GPUデリゲート：CPU比で2〜5倍の高速化（モデル・デバイス依存）
- NNAPIデリゲート：対応NPU利用時にCPU比で大幅な高速化
- XNNPACKデリゲート：浮動小数点演算で最大2倍の高速化

## セキュリティ考慮事項

- Stable Delegate APIにより、信頼できるデリゲートプラグインのみをロード可能
- デリゲートプラグインの署名検証を推奨

## 備考

- TFLiteGpuDelegateV2CreateAsync はAndroid専用の非同期GPUデリゲート
- tflite_plugin_create_delegate / tflite_plugin_destroy_delegate はプラグインインタフェース
- デリゲートの性能は大幅にデバイス・モデルに依存するため、ベンチマークによる検証が重要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | common.h | `tensorflow/lite/core/c/common.h` | TfLiteDelegate構造体、TfLiteDelegateFlags定義 |
| 1-2 | delegate_options.h | `tensorflow/lite/delegates/gpu/delegate_options.h` | TfLiteGpuDelegateOptionsV2構造体 |

**読解のコツ**: TfLiteDelegate構造体のPrepare/CopyFromBufferHandle/FreeBufferHandleコールバック関数ポインタが、デリゲートの動作を規定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | delegate.h | `tensorflow/lite/delegates/gpu/delegate.h` | GPUデリゲート生成・破棄API |

**主要処理フロー**:
1. **41-42行目**: TfLiteGpuDelegateV2Create - GPUデリゲートインスタンス生成
2. **49行目**: TfLiteGpuDelegateV2Delete - GPUデリゲート破棄
3. **51-53行目**: tflite_plugin_create_delegate - プラグインインタフェース

#### Step 3: デリゲートレジストリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | delegate_registry.h | `tensorflow/lite/core/acceleration/configuration/delegate_registry.h` | デリゲートプラグインの登録・検索機構 |
| 3-2 | stable_delegate_registry.h | `tensorflow/lite/core/acceleration/configuration/stable_delegate_registry.h` | Stable Delegate登録 |
| 3-3 | delegate_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/delegate_plugin.h` | Cプラグインインタフェース |

#### Step 4: 各デリゲート実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gpu_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/gpu_plugin.h` | GPUデリゲートプラグイン |
| 4-2 | nnapi_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/nnapi_plugin.h` | NNAPIデリゲートプラグイン |
| 4-3 | xnnpack_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/xnnpack_plugin.h` | XNNPACKデリゲートプラグイン |

### プログラム呼び出し階層図

```
Interpreter::ModifyGraphWithDelegate
    |
    +-- TfLiteDelegate::Prepare (コールバック)
    |       +-- IsNodeSupportedByDelegate (各ノード判定)
    |       +-- PartitionGraph (サブグラフ分割)
    |       +-- CreateDelegateKernel (デリゲートカーネル構築)
    |
    +-- Subgraph::Invoke
            +-- DelegateKernel::Invoke
            |       +-- GPU: OpenGL/OpenCL/Vulkan実行
            |       +-- NNAPI: ANeuralNetworks実行
            |       +-- XNNPACK: xnn_operator実行
            |
            +-- CPU Kernel::Invoke (フォールバック)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

アプリ設定 ──────▶ デリゲートオプション
                        |
                        v
演算グラフ ──────▶ パーティショニング ──▶ デリゲートノード / CPUノード
                        |
                        v
入力テンソル ────▶ デリゲートカーネル実行 ──▶ 出力テンソル
                   (GPU/NNAPI/XNNPACK)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| delegate.h | `tensorflow/lite/delegates/gpu/delegate.h` | ソース（ヘッダ） | GPUデリゲートAPI |
| gl_delegate.h | `tensorflow/lite/delegates/gpu/gl_delegate.h` | ソース（ヘッダ） | OpenGLデリゲート |
| api.h | `tensorflow/lite/delegates/gpu/api.h` | ソース（ヘッダ） | GPU共通API |
| utils.h | `tensorflow/lite/delegates/utils.h` | ソース（ヘッダ） | デリゲートユーティリティ |
| delegate_registry.h | `tensorflow/lite/core/acceleration/configuration/delegate_registry.h` | ソース（ヘッダ） | デリゲートレジストリ |
| stable_delegate.h | `tensorflow/lite/core/acceleration/configuration/c/stable_delegate.h` | ソース（ヘッダ） | Stable Delegate API |
| delegate_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/delegate_plugin.h` | ソース（ヘッダ） | プラグインインタフェース |
| gpu_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/gpu_plugin.h` | ソース（ヘッダ） | GPUプラグイン |
| nnapi_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/nnapi_plugin.h` | ソース（ヘッダ） | NNAPIプラグイン |
| xnnpack_plugin.h | `tensorflow/lite/core/acceleration/configuration/c/xnnpack_plugin.h` | ソース（ヘッダ） | XNNPACKプラグイン |
