# 機能設計書 83-TFLite実験的機能

## 概要

本ドキュメントは、TensorFlow Liteの実験的機能（アクセラレーション互換性チェック、ミニベンチマーク、StableHLO演算等）について、その設計・処理内容・インタフェース仕様を記述した機能設計書である。

### 本機能の処理概要

TFLite実験的機能は、TFLiteの将来の安定版機能を試験的に提供する実験的モジュール群である。主にアクセラレーション（デリゲート）の互換性チェック、ミニベンチマークによるデリゲート自動選択、ML Adjacent画像処理ユーティリティ、StableHLO演算サポートなどを含む。

**業務上の目的・背景**：モバイルデバイスの多様なハードウェア構成において、最適なデリゲートの自動選択は重要な課題である。デバイスの GPU互換性、デリゲートの精度・レイテンシを自動的に評価し、最適な推論構成を決定する機能が必要とされている。これらの機能は実験段階にあり、APIの安定性は保証されないが、先進的な最適化機能を提供する。

**機能の利用シーン**：アプリ起動時のデバイスGPU互換性チェック、バックグラウンドでのデリゲートベンチマーク実行、最適デリゲート構成の自動決定、画像前処理のTFLite内実行など。

**主要な処理内容**：
1. GPU互換性チェック（devicedb、gpu_compatibility）
2. ミニベンチマークによるデリゲート性能評価（mini_benchmark）
3. バリデータによるデリゲート精度検証（validator）
4. バリデータランナーによる非同期ベンチマーク実行
5. ML Adjacent画像処理（リサイズ、回転、色空間変換等）
6. StableHLO演算カーネル（experimental/shlo）
7. リソース管理（initialization_status、resource_base）

**関連システム・外部連携**：TFLite推論エンジン（No.81）、TFLiteデリゲート（No.82）と密接に連携する。Android固有のAPIも利用する。

**権限による制御**：ミニベンチマークの実行にはファイルシステムへの書き込み権限が必要（結果の永続化）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接的な画面関連はないが、デリゲートベンチマーク画面（No.12, 13）の基盤技術として利用 |

## 機能種別

計算処理 / システムユーティリティ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| model_path | string | Yes | ベンチマーク対象モデルのパス | ファイル存在確認 |
| tflite_settings | TFLiteSettings* | Yes | デリゲート設定（FlatBuffer） | FlatBuffer形式検証 |
| device_info | AndroidInfo | No | デバイス情報（GPU互換性チェック用） | - |
| custom_validation_data | void* | No | カスタムバリデーションデータ | - |

### 入力データソース

TFLiteモデルファイル、TFLite設定ファイル（FlatBuffer形式）、デバイスハードウェア情報（Android固有API経由）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| compatibility_result | GpuCompatibilityResult | GPU互換性チェック結果 |
| benchmark_result | BenchmarkResult | ベンチマーク結果（レイテンシ・精度） |
| best_acceleration | BestAccelerationDecision | 最適デリゲート選択結果 |
| validation_status | MiniBenchmarkStatus | バリデーション実行ステータス |

### 出力先

アプリケーション層（デリゲート選択結果）。ベンチマーク結果はFlatBuffer形式でファイルシステムに永続化される。

## 処理フロー

### 処理シーケンス

```
1. デバイス情報取得
   └─ AndroidInfoの取得（GPUモデル、ドライババージョン等）
2. GPU互換性チェック
   └─ devicedbを参照し、GPU互換性レベルを判定
3. ミニベンチマーク設定
   └─ TFLiteSettings FlatBufferからベンチマーク設定を読み込み
4. バリデーション実行
   └─ 別プロセスでモデルの推論精度を検証
5. レイテンシ測定
   └─ 指定デリゲートでの推論レイテンシを測定
6. 結果評価
   └─ BenchmarkResultEvaluatorで結果を評価
7. 最適デリゲート決定
   └─ 精度・レイテンシに基づき最適構成を選択
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[デバイス情報取得]
    B --> C[GPU互換性チェック]
    C --> D{GPU互換?}
    D -->|Yes| E[GPUデリゲートでベンチマーク]
    D -->|No| F[CPU/NNAPIでベンチマーク]
    E --> G[バリデーション実行]
    F --> G
    G --> H[結果評価]
    H --> I[最適デリゲート決定]
    I --> J[結果永続化]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-83-01 | 実験的API不安定性 | experimentalパッケージのAPIは変更される可能性がある | 常時 |
| BR-83-02 | ベンチマーク分離実行 | ミニベンチマークは別プロセスで実行される | Android環境 |
| BR-83-03 | 結果キャッシュ | ベンチマーク結果はファイルに永続化され再利用される | 同一デバイス・モデル |

### 計算ロジック

ミニベンチマークは複数回の推論実行の平均レイテンシと精度を測定する。GPU互換性チェックはデバイスDBのルールベースマッチングで判定する。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースのFlatBufferストレージを使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| kMiniBenchmarkModelBuildFailed | ベンチマークエラー | モデルの読み込み失敗 | モデルパスを確認 |
| kMiniBenchmarkInterpreterBuilderFailed | ベンチマークエラー | Interpreter構築失敗 | モデルの互換性を確認 |
| kMiniBenchmarkValidationSubgraphBuildFailed | ベンチマークエラー | バリデーションサブグラフ構築失敗 | バリデーションモデルを確認 |

### リトライ仕様

ミニベンチマークは失敗時に自動リトライしない。次回アプリ起動時に再実行される。

## トランザクション仕様

該当なし（ファイルロックによる排他制御を使用）

## パフォーマンス要件

- ミニベンチマーク実行はバックグラウンドで行われ、UIスレッドをブロックしない
- ベンチマーク結果はキャッシュされ、重複実行を回避

## セキュリティ考慮事項

- ミニベンチマークは別プロセスで実行されるため、クラッシュがメインアプリに影響しない
- ファイルロックによるベンチマーク結果の排他アクセス制御

## 備考

- experimentalパッケージの機能は将来の安定版で変更・削除される可能性がある
- shlo（StableHLO）は将来のTFLiteカーネル標準化に向けた実験的実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | configuration_generated.h | `tensorflow/lite/experimental/acceleration/configuration/configuration_generated.h` | TFLiteSettings FlatBuffer定義 |
| 1-2 | status_codes.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/status_codes.h` | ミニベンチマークステータスコード |

**読解のコツ**: FlatBuffer生成コードは自動生成であるため、元のFlatBufferスキーマ（.fbs）ファイルと合わせて読むとよい。

#### Step 2: GPU互換性チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gpu_compatibility.h | `tensorflow/lite/experimental/acceleration/compatibility/gpu_compatibility.h` | GPU互換性判定ロジック |
| 2-2 | android_info.h | `tensorflow/lite/experimental/acceleration/compatibility/android_info.h` | Androidデバイス情報取得 |
| 2-3 | devicedb.h | `tensorflow/lite/experimental/acceleration/compatibility/devicedb.h` | デバイスデータベース |

#### Step 3: ミニベンチマークを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mini_benchmark.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/mini_benchmark.h` | ミニベンチマークのメインクラス |
| 3-2 | validator.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/validator.h` | バリデータ（精度検証） |
| 3-3 | validator_runner.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/validator_runner.h` | バリデータランナー（非同期実行） |
| 3-4 | blocking_validator_runner.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/blocking_validator_runner.h` | ブロッキングバリデータランナー |
| 3-5 | benchmark_result_evaluator.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/benchmark_result_evaluator.h` | 結果評価 |

#### Step 4: ML Adjacent画像処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lib.h | `tensorflow/lite/experimental/ml_adjacent/lib.h` | ML Adjacentライブラリ定義 |
| 4-2 | resize.h | `tensorflow/lite/experimental/ml_adjacent/algo/resize.h` | 画像リサイズアルゴリズム |
| 4-3 | rotate.h | `tensorflow/lite/experimental/ml_adjacent/algo/rotate.h` | 画像回転アルゴリズム |

### プログラム呼び出し階層図

```
MiniBenchmark
    |
    +-- ValidatorRunner
    |       +-- Validator
    |       |       +-- Interpreter (TFLite推論エンジン)
    |       |       +-- DelegatePlugin (デリゲート)
    |       |
    |       +-- Runner (別プロセス実行)
    |               +-- ValidatorRunnerEntrypoint
    |
    +-- BenchmarkResultEvaluator
    |       +-- 結果FlatBuffer読み込み
    |
    +-- GpuCompatibility
            +-- DeviceDB
            +-- AndroidInfo
```

### データフロー図

```
[入力]                     [処理]                           [出力]

モデルファイル ──────▶ Validator ──────────▶ バリデーション結果
                         |
デリゲート設定 ──────▶ ValidatorRunner ────▶ ベンチマーク結果
                         |
デバイス情報 ────────▶ GpuCompatibility ──▶ 互換性判定
                                                |
                                                v
                                    BenchmarkResultEvaluator ──▶ 最適デリゲート推奨
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gpu_compatibility.h | `tensorflow/lite/experimental/acceleration/compatibility/gpu_compatibility.h` | ソース | GPU互換性チェック |
| devicedb.h | `tensorflow/lite/experimental/acceleration/compatibility/devicedb.h` | ソース | デバイスDB |
| android_info.h | `tensorflow/lite/experimental/acceleration/compatibility/android_info.h` | ソース | Android情報取得 |
| mini_benchmark.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/mini_benchmark.h` | ソース | ミニベンチマーク |
| validator.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/validator.h` | ソース | バリデータ |
| validator_runner.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/validator_runner.h` | ソース | バリデータランナー |
| benchmark_result_evaluator.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/benchmark_result_evaluator.h` | ソース | 結果評価 |
| fb_storage.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/fb_storage.h` | ソース | FlatBufferストレージ |
| file_lock.h | `tensorflow/lite/experimental/acceleration/mini_benchmark/file_lock.h` | ソース | ファイルロック |
| lib.h | `tensorflow/lite/experimental/ml_adjacent/lib.h` | ソース | ML Adjacentライブラリ |
| data_type.h | `tensorflow/lite/experimental/shlo/data_type.h` | ソース | StableHLOデータ型 |
| shape.h | `tensorflow/lite/experimental/shlo/shape.h` | ソース | StableHLO形状 |
