# 機能設計書 84-Grappler最適化

## 概要

本ドキュメントは、TensorFlowの計算グラフ自動最適化フレームワーク「Grappler」について、その設計・処理内容・インタフェース仕様を記述した機能設計書である。定数畳み込み・演算融合・メモリ最適化等の最適化パスを提供する。

### 本機能の処理概要

Grapplerは、TensorFlowの計算グラフを自動的に最適化するフレームワークである。グラフレベルの多様な最適化パスを適用することで、推論速度の向上、メモリ使用量の削減、モデルサイズの縮小を実現する。

**業務上の目的・背景**：ユーザーが定義した計算グラフは、必ずしも最適な形とは限らない。冗長な演算、不要な中間テンソル、非効率なレイアウトなどが含まれることがある。Grapplerはこれらの非効率性を自動的に検出・除去し、同一の計算結果を保ちながら実行効率を向上させる。tf.function（No.88）によるグラフモードでの実行時に自動的に適用される。

**機能の利用シーン**：tf.functionでデコレートされた関数の初回実行時（グラフトレーシング後）、SavedModelの最適化、モデルエクスポート前の最適化、推論パフォーマンスのチューニングなど。

**主要な処理内容**：
1. MetaGraphDefの受け取りとGrapplerItemの構築
2. Clusterオブジェクトによるハードウェアリソース情報の管理
3. 各最適化パスの適用（ConfigProtoで制御）
4. 定数畳み込み（Constant Folding）：コンパイル時に計算可能な式の事前計算
5. 算術最適化（Arithmetic Optimization）：代数的簡約化
6. レイアウト最適化（Layout Optimization）：NHWC/NCHW変換
7. リマッパー（Remapper）：演算融合（Conv+BiasAdd+Relu等）
8. メモリ最適化（Memory Optimization）：テンソルの再利用・スワップ
9. 自動混合精度（Auto Mixed Precision）：FP16/BF16への自動変換
10. 最適化後のGraphDefの返却

**関連システム・外部連携**：tf.function（No.88）、Eager実行コンテキスト（No.87）、コスト分析（No.85）、自動混合精度（No.86）と連携する。

**権限による制御**：特になし。ConfigProtoのRewriterConfigで最適化パスの有効/無効を制御可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | GrapplerはバックエンドのグラフMAX最適化であり、直接的な画面関連はない |

## 機能種別

計算処理（グラフ最適化）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| config_proto | ConfigProto | Yes | 最適化設定を含むプロトコルバッファ | ConfigProto型チェック |
| metagraph | MetaGraphDef | Yes | 最適化対象の計算グラフ | 有効なMetaGraphDef |
| verbose | bool | No | 最適化結果のログ出力 | - |
| graph_id | bytes | No | グラフ識別子 | - |
| cluster | Cluster | No | ハードウェアクラスタ情報 | None許可 |
| strip_default_attributes | bool | No | デフォルト属性の除去 | - |

### 入力データソース

TensorFlowの計算グラフ（MetaGraphDef protobuf）。ConfigProtoのgraph_optionsフィールドでRewriterConfigを指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| optimized_graph | GraphDef | 最適化された計算グラフ |
| optimization_log | string | 最適化の適用結果ログ（verbose時） |

### 出力先

TensorFlowランタイム（最適化されたグラフで推論/学習を実行）。

## 処理フロー

### 処理シーケンス

```
1. 入力検証
   └─ config_protoがConfigProto型であることを確認
2. Cluster生成
   └─ Clusterが未指定の場合、ローカルマシンのClusterを生成
3. グラフシリアライズ
   └─ MetaGraphDefをシリアライズ
4. 最適化実行
   └─ TF_OptimizeGraphSerializedを呼び出し
5. 最適化後グラフのデシリアライズ
   └─ 結果をGraphDefにパース
6. Cluster解放
   └─ 自動生成したClusterの場合、Shutdownして解放
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ConfigProto検証]
    B --> C{Cluster指定あり?}
    C -->|Yes| D[指定Clusterを使用]
    C -->|No| E[ローカルCluster生成]
    D --> F[TF_OptimizeGraphSerialized]
    E --> F
    F --> G{最適化成功?}
    G -->|Yes| H[最適化GraphDef返却]
    G -->|No| I[エラー返却]
    H --> J[終了]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-84-01 | セッション排他 | Grapplerは同時に1つのセッションのみサポート（SingleMachine制約） | グローバル |
| BR-84-02 | ロック制御 | Cluster未指定時はグローバルロック(_OPTIMIZE_GRAPH_CLUSTER_LOCK)で排他制御 | Cluster未指定時 |
| BR-84-03 | 最適化パス制御 | RewriterConfigで各最適化パスの有効/無効を制御可能 | 常時 |
| BR-84-04 | 結果等価性 | 最適化は計算結果の等価性を保証する必要がある | 常時 |

### 計算ロジック

各最適化パスは以下のロジックで動作する：
- **定数畳み込み**：グラフ内の定数入力のみを持つノードを事前計算し、結果定数に置換
- **算術最適化**：x*1→x、x+0→x、x*0→0 等の代数的簡約化
- **リマッパー**：Conv2D+BiasAdd+Relu等のパターンを融合Opに置換
- **メモリ最適化**：テンソルの生存期間を分析し、メモリ再利用を最大化

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TypeError | 型エラー | config_protoがConfigProto型でない | 正しい型のオブジェクトを渡す |
| OptimizationError | 最適化エラー | グラフ最適化パスの適用失敗 | 問題のある最適化パスを無効化 |

### リトライ仕様

最適化エラー時の自動リトライはない。個別の最適化パスを無効化して再実行する。

## トランザクション仕様

グローバルロックによるCluster排他制御。Cluster生成→最適化→Cluster解放の一連の処理はtry-finallyで保護される。

## パフォーマンス要件

- 最適化処理自体は初回グラフ実行時のオーバーヘッドとなる
- 最適化後のグラフは繰り返し実行で恩恵を受ける
- 定数畳み込みとリマッパーが一般的に最も効果が大きい

## セキュリティ考慮事項

- 最適化処理はグラフの意味を保存するため、セキュリティ上の新たなリスクは追加しない

## 備考

- `is_oss = True` の場合はシリアライズ版のAPIを使用（コピーバラ設定）
- Grappler最適化はtf.functionの内部で自動的に適用される
- 手動で最適化を適用する場合はtf_optimizer.OptimizeGraph()を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config_pb2 | `tensorflow/core/protobuf/config_pb2` | ConfigProto.graph_options.rewrite_optionsでRewriterConfig指定 |
| 1-2 | graph_pb2 | `tensorflow/core/framework/graph_pb2` | GraphDef protobuf定義 |
| 1-3 | meta_graph_pb2 | `tensorflow/core/protobuf/meta_graph_pb2` | MetaGraphDef protobuf定義 |

**読解のコツ**: GrapplerはProtocol Bufferを多用する。ConfigProto→RewriterConfig→各最適化パスの設定という階層構造を把握することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tf_optimizer.py | `tensorflow/python/grappler/tf_optimizer.py` | OptimizeGraph関数 - Python APIのメインエントリーポイント |

**主要処理フロー**:
1. **28-33行目**: OptimizeGraph関数のシグネチャと引数定義
2. **51-53行目**: ConfigProtoの型チェック
3. **54-56行目**: OSS版でのシリアライズ処理
4. **60-68行目**: Cluster指定時の最適化呼び出し
5. **70-87行目**: Cluster未指定時のロック取得とクラスタ自動生成

#### Step 3: Clusterとitemを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cluster.py | `tensorflow/python/grappler/cluster.py` | Clusterクラス - ハードウェアリソース情報管理 |
| 3-2 | item.py | `tensorflow/python/grappler/item.py` | GrapplerItemクラス - 最適化対象グラフのラッパー |

**主要処理フロー**:
- **22-46行目（item.py）**: Itemクラスのコンストラクタ、MetaGraphDefのコピーとTF Item構築
- **48-49行目（item.py）**: IdentifyImportantOps - 重要なOp特定
- **51-63行目（item.py）**: GetOpProperties - Op属性取得

#### Step 4: グラフ分析を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | graph_analyzer.py | `tensorflow/python/grappler/graph_analyzer.py` | グラフ構造の分析ユーティリティ |
| 4-2 | model_analyzer.py | `tensorflow/python/grappler/model_analyzer.py` | モデルの分析（FLOPs、パラメータ数等） |

### プログラム呼び出し階層図

```
tf_optimizer.OptimizeGraph (Python)
    |
    +-- config_proto検証
    +-- metagraph.SerializeToString()
    |
    +-- _OPTIMIZE_GRAPH_CLUSTER_LOCK (排他制御)
    |       +-- gcluster.Cluster() (ハードウェア情報)
    |
    +-- _pywrap_tf_optimizer.TF_OptimizeGraphSerialized (C++バインディング)
            |
            +-- MetaOptimizer::Optimize (C++)
                    +-- ConstantFolding
                    +-- ArithmeticOptimizer
                    +-- LayoutOptimizer
                    +-- Remapper
                    +-- MemoryOptimizer
                    +-- AutoMixedPrecision
                    +-- ... (その他のパス)
```

### データフロー図

```
[入力]                        [処理]                           [出力]

ConfigProto ────────▶ RewriterConfig解析
                            |
MetaGraphDef ────────▶ GrapplerItem構築 ──▶ 各最適化パス ──▶ 最適化GraphDef
                            |                    |
Cluster (HW情報) ────▶ コスト推定         各パスの適用ログ ──▶ 最適化ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tf_optimizer.py | `tensorflow/python/grappler/tf_optimizer.py` | ソース | Python APIエントリーポイント |
| cluster.py | `tensorflow/python/grappler/cluster.py` | ソース | Clusterクラス |
| item.py | `tensorflow/python/grappler/item.py` | ソース | GrapplerItemクラス |
| graph_analyzer.py | `tensorflow/python/grappler/graph_analyzer.py` | ソース | グラフ分析 |
| model_analyzer.py | `tensorflow/python/grappler/model_analyzer.py` | ソース | モデル分析 |
| cost_analyzer.py | `tensorflow/python/grappler/cost_analyzer.py` | ソース | コスト分析 |
