# 機能設計書 85-コスト分析

## 概要

本ドキュメントは、TensorFlowの計算グラフコスト分析機能について、その設計・処理内容・インタフェース仕様を記述した機能設計書である。計算グラフの実行時間・メモリ使用量の分析機能を提供する。

### 本機能の処理概要

コスト分析機能は、TensorFlowの計算グラフにおける各演算（Op）の実行コスト（実行時間・メモリ使用量）を推定・分析する機能である。Grapplerフレームワーク（No.84）の一部として動作し、最適化の判断材料を提供する。

**業務上の目的・背景**：モデルのパフォーマンスボトルネックを特定するために、各演算の計算コストとメモリ消費を定量的に把握する必要がある。コスト分析はGrappler最適化の判断基盤として機能し、メモリ最適化やデバイス配置の最適化に不可欠な情報を提供する。

**機能の利用シーン**：モデル最適化時のボトルネック特定、メモリ使用量の分析、デバイス配置戦略の決定支援、モデルの実行コストレポート生成など。

**主要な処理内容**：
1. GenerateCostReport：Op単位のコストレポート生成（実行時間・メモリ）
2. GenerateMemoryReport：ピークメモリ使用量の分析
3. DeterminePeakMemoryUsage：デバイスごとのピークメモリ使用量特定
4. Op性能データの取得（TensorProperties）
5. ノード単位の詳細レポート生成

**関連システム・外部連携**：Grappler最適化（No.84）、Clusterクラス、GrapplerItemと連携する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックエンド分析機能であり、直接的な画面関連はない |

## 機能種別

計算処理（グラフ分析・レポート生成）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| metagraph | MetaGraphDef | Yes | 分析対象の計算グラフ | 有効なMetaGraphDef |
| per_node_report | bool | No | ノード単位の詳細レポート | デフォルト: False |
| verbose | bool | No | 詳細出力モード | デフォルト: False |
| cluster | Cluster | No | ハードウェアクラスタ | None時は自動生成 |
| detailed_report | bool | No | 詳細メモリレポート | デフォルト: True |

### 入力データソース

TensorFlowの計算グラフ（MetaGraphDef protobuf）。ハードウェア情報はClusterオブジェクトから取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cost_report | string | コストレポート（テキスト形式） |
| memory_report | string | メモリ使用量レポート（テキスト形式） |
| peak_usage | dict | デバイスごとのピークメモリ使用量 |

### 出力先

呼び出し元（文字列形式のレポート）。

## 処理フロー

### 処理シーケンス

```
1. Cluster生成
   └─ 未指定時はCluster(disable_detailed_stats=False)で生成
2. コストレポート生成
   └─ _pywrap_cost_analyzer.GenerateCostReport呼び出し
3. メモリレポート生成
   └─ GrapplerItem構築→DeterminePeakMemoryUsage呼び出し
4. ピークメモリ解析
   └─ デバイスごとのスナップショットからピーク使用量と生存テンソルを特定
5. レポートフォーマット
   └─ テキスト形式でレポートを構築
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{Cluster指定あり?}
    B -->|No| C[Cluster自動生成]
    B -->|Yes| D[指定Clusterを使用]
    C --> E[MetaGraphDefシリアライズ]
    D --> E
    E --> F{コスト分析?}
    F -->|Yes| G[GenerateCostReport C++呼び出し]
    F -->|No| H[GrapplerItem構築]
    G --> I[レポート返却]
    H --> J[DeterminePeakMemoryUsage]
    J --> K[デバイスごとピーク解析]
    K --> L[メモリレポートフォーマット]
    L --> I
    I --> M[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-85-01 | Cluster設定差異 | コスト分析はdisable_detailed_stats=False、メモリ分析はdisable_detailed_stats=Trueで生成 | Cluster自動生成時 |
| BR-85-02 | メモリスナップショット | ピークメモリはスナップショット[0]、生存テンソルはスナップショット[1] | メモリ分析時 |

### 計算ロジック

各Opのコストはハードウェアプロファイルに基づく推定値。メモリ使用量はテンソルのサイズ（shape * dtype_size）と生存期間から計算される。ピークメモリは全テンソルの生存期間オーバーラップの最大値。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ValueError | 入力エラー | 不正なMetaGraphDef | 有効なMetaGraphDefを提供 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- コスト分析はグラフサイズに比例した実行時間
- 大規模グラフ（数万ノード）では分析に数秒〜数十秒を要する可能性

## セキュリティ考慮事項

- 分析結果にはモデルの構造情報が含まれるため、機密モデルの場合は出力の取り扱いに注意

## 備考

- cost_analyzer_tool.pyからコマンドラインツールとしても利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | op_performance_data_pb2 | `tensorflow/core/grappler/costs/op_performance_data_pb2` | OpInfo.TensorProperties定義 |

**読解のコツ**: コスト分析はProtocol Bufferの構造体を多用する。OpInfo.TensorPropertiesがOp単位のコスト情報を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cost_analyzer.py | `tensorflow/python/grappler/cost_analyzer.py` | GenerateCostReport / GenerateMemoryReport関数 |

**主要処理フロー**:
1. **22-45行目**: GenerateCostReport - Opごとのコストレポート生成
2. **48-80行目**: GenerateMemoryReport - ピークメモリ使用量分析
3. **40-41行目**: Cluster自動生成（disable_detailed_stats=False）
4. **62-63行目**: メモリ分析用Cluster生成（disable_detailed_stats=True, disable_timeline=True）
5. **65行目**: GrapplerItem構築
6. **66行目**: DeterminePeakMemoryUsage呼び出し
7. **68-79行目**: デバイスごとのピーク使用量と生存テンソルのレポートフォーマット

#### Step 3: サポートクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cluster.py | `tensorflow/python/grappler/cluster.py` | Clusterクラス・DeterminePeakMemoryUsage |
| 3-2 | item.py | `tensorflow/python/grappler/item.py` | GrapplerItemクラス |

### プログラム呼び出し階層図

```
GenerateCostReport (Python)
    |
    +-- gcluster.Cluster(disable_detailed_stats=False)
    +-- _pywrap_cost_analyzer.GenerateCostReport (C++バインディング)

GenerateMemoryReport (Python)
    |
    +-- gcluster.Cluster(disable_detailed_stats=True)
    +-- gitem.Item(metagraph)
    +-- cluster.DeterminePeakMemoryUsage(item)
    |       +-- デバイスごとのスナップショット解析
    +-- レポートフォーマット
```

### データフロー図

```
[入力]                     [処理]                          [出力]

MetaGraphDef ──────▶ GrapplerItem構築
                          |
                          v
Cluster (HW情報) ──▶ コスト推定エンジン ──▶ コストレポート (文字列)
                          |
                          v
                     メモリ分析 ──────────▶ メモリレポート (文字列)
                          |
                          v
                     ピーク使用量計算 ────▶ {device: (peak_bytes, [tensor_info])}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cost_analyzer.py | `tensorflow/python/grappler/cost_analyzer.py` | ソース | コスト分析メインAPI |
| cost_analyzer_tool.py | `tensorflow/python/grappler/cost_analyzer_tool.py` | ソース | CLIツール |
| cluster.py | `tensorflow/python/grappler/cluster.py` | ソース | Clusterクラス |
| item.py | `tensorflow/python/grappler/item.py` | ソース | GrapplerItemクラス |
| model_analyzer.py | `tensorflow/python/grappler/model_analyzer.py` | ソース | モデル分析 |
