# 機能設計書 87-Eager実行コンテキスト

## 概要

本ドキュメントは、TensorFlowのEager Execution（即時実行）コンテキスト管理機能について、その設計・処理内容・インタフェース仕様を記述した機能設計書である。即時実行モードのコンテキスト管理・デバイス配置・実行設定を提供する。

### 本機能の処理概要

Eager実行コンテキストは、TensorFlowの即時実行モード（Eager Execution）の状態管理を担うグローバルコンテキストオブジェクトである。TensorFlow 2.xではデフォルトで有効化され、演算の即時実行、デバイス配置、スレッド設定、メモリ設定などを管理する。

**業務上の目的・背景**：TensorFlow 1.xではSessionベースのグラフ実行モードが主体であったが、デバッグの困難さ、直感的でないAPIなどの問題があった。TensorFlow 2.xではEager Executionがデフォルトとなり、Pythonの通常の制御フローでTensorFlow演算を即座に実行できるようになった。コンテキストオブジェクトはこの実行環境の全体設定を管理する中核機能である。

**機能の利用シーン**：TensorFlow演算のデバイス指定（CPU/GPU/TPU）、実行モードの切り替え（Eager/Graph）、GPU メモリ成長設定、スレッド数設定、JITコンパイル設定など。

**主要な処理内容**：
1. Eager/Graph実行モードの管理（EAGER_MODE / GRAPH_MODE）
2. デバイス配置ポリシーの管理（EXPLICIT / WARN / SILENT）
3. 同期/非同期実行モードの制御
4. GPU メモリ設定（メモリ成長の有効化等）
5. スレッド数・並列度の設定
6. JITコンパイルリライトの制御
7. XLAシャーディングの管理
8. Eager Tensor キャッシュ管理
9. FunctionCallOptionsによる関数呼び出し設定

**関連システム・外部連携**：tf.function（No.88）、AutoGraph変換（No.89）、Grappler最適化（No.84）、全てのTensorFlow演算と連携する。

**権限による制御**：環境変数（TF_JIT_COMPILE_REWRITE、TF_XLA_SHARDING_FOR_RESOURCE_VARIABLES等）による制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | バックエンドのランタイム管理機能であり、直接的な画面関連はない |

## 機能種別

システム管理（実行環境コンテキスト管理）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| device_policy | enum | No | デバイス配置ポリシー | EXPLICIT/WARN/SILENT/SILENT_FOR_INT32 |
| execution_mode | int | No | 同期(0)/非同期(1) | 0 or 1 |
| config_proto | ConfigProto | No | 実行設定 | ConfigProto型 |
| executor_type | string | No | Executor種別 | 空文字はデフォルト |

### 入力データソース

アプリケーション層からのAPI呼び出し、環境変数設定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| context | Context | グローバルコンテキストオブジェクト |
| device_name | string | 現在のデバイス名 |
| execution_mode | int | 現在の実行モード |

### 出力先

TensorFlowランタイム（全ての演算実行に影響）。

## 処理フロー

### 処理シーケンス

```
1. コンテキスト初期化
   └─ TF2有効時はEAGER_MODE、TF1互換時はGRAPH_MODEで初期化
2. デバイス配置設定
   └─ device_policyに基づきデバイス配置動作を設定
3. GPU メモリ設定
   └─ メモリ成長の有効化、メモリ制限の設定
4. スレッド設定
   └─ intra_op / inter_op 並列度の設定
5. JITコンパイル設定
   └─ 環境変数/API経由でJITコンパイルリライトの有効/無効を設定
6. 演算実行
   └─ 各演算がコンテキストの設定に基づいて実行される
```

### フローチャート

```mermaid
flowchart TD
    A[TensorFlow初期化] --> B{TF2有効?}
    B -->|Yes| C[default_execution_mode = EAGER_MODE]
    B -->|No| D[default_execution_mode = GRAPH_MODE]
    C --> E[Context初期化]
    D --> E
    E --> F[デバイスポリシー設定]
    F --> G[GPUメモリ設定]
    G --> H[スレッド設定]
    H --> I[JITコンパイル設定]
    I --> J[演算実行準備完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-87-01 | デフォルトモード | TF2.xではEAGER_MODEがデフォルト | tf2.enabled()がTrue |
| BR-87-02 | デバイスキャッシュ | デバイスパース結果はグローバルキャッシュに保存（GILで保護） | デバイス指定時 |
| BR-87-03 | テンソルキャッシュ | EagerTensorCacheはFIFO方式で最大256項目、テンソルサイズ10000以下 | テンソル生成時 |
| BR-87-04 | KEEP_ALIVE | セッションキープアライブは600秒 | 分散実行時 |

### 計算ロジック

特に計算ロジックはない。コンテキストは実行環境の設定管理のみを行う。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ValueError | 設定エラー | 無効なConfigProto型 | 正しい型を指定 |
| RuntimeError | 実行エラー | GPU初期化失敗 | GPU環境を確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし。スレッドセーフティはGILとThreadLocalで保証。

## パフォーマンス要件

- コンテキスト初期化は通常数百ミリ秒
- Eager演算のオーバーヘッドはPythonインタプリタのオーバーヘッドに支配される

## セキュリティ考慮事項

- 環境変数による設定は不正な設定の注入リスクがある
- 信頼できない環境ではデフォルト設定の使用を推奨

## 備考

- is_oss = Trueはcopybara（Google内部→OSS変換ツール）で更新される
- is_tfrt_enabled は TFRTランタイム（No.117）の有効化状態をエクスポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | context.py | `tensorflow/python/eager/context.py` | グローバル定数と列挙値の理解 |

**読解のコツ**: context.pyはTensorFlowの全体的な実行状態を管理する大規模なファイルである。まず先頭のグローバル定数（GRAPH_MODE/EAGER_MODE/DEVICE_PLACEMENT_*等）を把握してから詳細に入るとよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | context.py | `tensorflow/python/eager/context.py` | モジュール先頭の初期化ロジック |

**主要処理フロー**:
1. **55-56行目**: GRAPH_MODE = 0, EAGER_MODE = 1 定義
2. **58行目**: default_execution_modeの決定（tf2.enabled()に基づく）
3. **69-74行目**: DEVICE_PLACEMENT_* 定数定義
4. **76-77行目**: SYNC = 0, ASYNC = 1 定義
5. **79行目**: _KEEP_ALIVE_SECS = 600
6. **81-84行目**: コンテキスト生成カウンタ
7. **87行目**: is_tfrt_enabledの再エクスポート
8. **91-96行目**: 環境変数による設定読み込み（JIT_COMPILE_REWRITE等）

#### Step 3: ユーティリティクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | context.py | `tensorflow/python/eager/context.py` | _EagerTensorCacheクラス（218-241行目） |
| 3-2 | context.py | `tensorflow/python/eager/context.py` | FunctionCallOptionsクラス（244-297行目） |

**主要処理フロー**:
- **218-241行目**: _EagerTensorCache - FIFOキャッシュ（max_items=256, max_tensor_size=10000）
- **244-297行目**: FunctionCallOptions - 関数呼び出し時のConfigProtoとexecutor_type管理

#### Step 4: JITコンパイル・XLAシャーディング制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | context.py | `tensorflow/python/eager/context.py` | enable/disable_jit_compile_rewrite（104-127行目） |
| 4-2 | context.py | `tensorflow/python/eager/context.py` | enable/disable_xla_sharding_for_resource_variables（130-153行目） |

### プログラム呼び出し階層図

```
tensorflow パッケージインポート
    |
    +-- tf2.enabled() → default_execution_mode決定
    |
    +-- Context (シングルトン)
    |       +-- device_policy設定
    |       +-- execution_mode設定
    |       +-- gpu_memory設定
    |       +-- thread設定
    |
    +-- 各tf.* 演算実行
            +-- pywrap_tfe (C++バインディング)
                    +-- Context参照
                    +-- Device配置
                    +-- カーネル実行
```

### データフロー図

```
[入力]                        [処理]                         [出力]

環境変数 ────────────▶ グローバル設定読み込み
                              |
API設定呼び出し ────▶ Context状態更新 ──────▶ 実行環境設定
                              |
tf演算呼び出し ─────▶ Context参照 ──────────▶ デバイス配置・実行制御
                              |
                              v
                       pywrap_tfe (C++) ──▶ カーネル実行結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| context.py | `tensorflow/python/eager/context.py` | ソース | Eagerコンテキスト管理（メイン） |
| execute.py | `tensorflow/python/eager/execute.py` | ソース | 演算の実行ディスパッチ |
| executor.py | `tensorflow/python/eager/executor.py` | ソース | Executorの管理 |
| cancellation.py | `tensorflow/python/eager/cancellation.py` | ソース | 実行キャンセル機能 |
| monitoring.py | `tensorflow/python/eager/monitoring.py` | ソース | モニタリングカウンタ |
| tfrt_utils.py | `tensorflow/python/framework/tfrt_utils.py` | ソース | TFRTランタイムユーティリティ |
