# 機能設計書 93-ランダムインデックスシャッフル

## 概要

本ドキュメントは、TensorFlowにおけるランダムインデックスシャッフル（Random Index Shuffle）機能の設計を記述する。インデックスの暗号学的安全なシャッフル機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：データのシャッフルは機械学習の訓練において偏りのない学習を実現するための基本操作である。本機能は、与えられたインデックスを[0, max_index]の範囲内で暗号学的に安全なシャッフル（置換）を行い、データパイプラインでの効率的かつ再現可能なシャッフリングを提供する。従来のシャッフル手法と異なり、全データをメモリに保持せずにインデックスの置換を計算できる。

**機能の利用シーン**：大規模データセットのシャッフル、バッチ処理におけるインデックス並べ替え、データ拡張時のランダム順序生成などに使用される。seedを固定することで再現可能なシャッフルが実現できる。

**主要な処理内容**：
1. インデックスとseedから暗号学的に安全な置換インデックスを計算
2. スカラーおよびバッチ（ベクトル）入力に対応
3. ラウンド数（rounds属性）で置換の暗号学的強度を制御

**関連システム・外部連携**：tf.data パイプラインと連携してデータシャッフルに使用される。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

計算処理（乱数ベースのインデックス置換）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| index | dtype (int32/uint32/int64/uint64) | Yes | シャッフル対象のインデックス | スカラーまたは1次元ベクトル |
| seed | Tseed (int32/uint32/int64/uint64) | Yes | シード値（形状 [3] または [n, 3]） | 最後の次元が3 |
| max_index | dtype | Yes | インデックスの最大値 | スカラーまたは1次元ベクトル |
| rounds | int | No | 置換ラウンド数（デフォルト: 4） | 正の整数 |

### 入力データソース

計算グラフ内のテンソル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output | dtype | シャッフルされたインデックス（入力と同じ型・形状） |

### 出力先

計算グラフ内の後続操作への入力。

## 処理フロー

### 処理シーケンス

```
1. 入力形状の検証
   └─ index: スカラーまたはrank 1
   └─ seed: rank 1 ([3]) または rank 2 ([n, 3])
   └─ max_index: スカラーまたはrank 1
2. 出力形状の決定
   └─ 全入力がスカラーの場合: スカラー出力
   └─ いずれかがベクトルの場合: ベクトル出力
3. 置換計算の実行
   └─ 指定rounds数のFeistelネットワークベースの置換を計算
4. 結果の返却
```

### フローチャート

```mermaid
flowchart TD
    A[入力: index, seed, max_index] --> B[形状検証]
    B --> C{全てスカラー?}
    C -->|Yes| D[スカラー出力]
    C -->|No| E{ベクトル確定?}
    E -->|Yes| F[ベクトルサイズ計算]
    E -->|不明| G[UnknownShape出力]
    F --> H[置換計算実行]
    D --> H
    G --> H
    H --> I[シャッフル済みインデックス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-01 | seed形状制約 | seedの最後の次元は3である必要がある | 常時 |
| BR-93-02 | 全単射性 | 同じseedとmax_indexに対して、[0, max_index]上の全単射（bijection）を提供 | 常時 |
| BR-93-03 | バッチサイズ一致 | ベクトル入力の場合、index, seed, max_indexのバッチサイズは一致する必要がある | バッチ入力時 |

### 計算ロジック

Feistelネットワークベースの暗号学的置換：
- index を [0, max_index] の範囲で置換
- rounds パラメータで暗号学的強度を調整（デフォルト4ラウンド）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 形状不正 | seedの最後の次元が3でない | [3]または[n,3]形状のseedを使用 |
| InvalidArgument | サイズ不一致 | バッチ入力でサイズが一致しない | 同じバッチサイズを使用 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

該当なし。ステートレスな計算処理。

## パフォーマンス要件

- 全データをメモリに保持せずにO(1)で各インデックスの置換を計算可能
- rounds数に比例した計算コスト

## セキュリティ考慮事項

- 暗号学的に安全な置換を提供（Feistelネットワークベース）
- seedの秘匿性がシャッフルの予測不可能性を保証

## 備考

- dtype: int32, uint32, int64, uint64 をサポート
- Tseed: int32, uint32, int64, uint64 をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | random_index_shuffle_ops.cc | `tensorflow/core/ops/random_index_shuffle_ops.cc` | RandomIndexShuffle Opの定義 |

**主要処理フロー**:
1. **30-121行目**: `StatelessRandomPermuteShape`関数 - 出力形状推論ロジック
2. **46-56行目**: seedの最後の次元が3であることの検証
3. **66-71行目**: ケース1 - 全入力スカラーの場合のスカラー出力
4. **77-82行目**: ケース2 - 出力が不定の場合のUnknownShape
5. **87-119行目**: ケース3 - ベクトル出力のサイズ計算
6. **123-131行目**: `RandomIndexShuffle` Op登録

**読解のコツ**: 形状推論が3つのケースに分かれている点に注目。入力のrank組み合わせによってスカラー/ベクトル/不定が決まる。

#### Step 2: カーネル実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | random_index_shuffle_ops.cc | `tensorflow/core/kernels/random_index_shuffle_ops.cc` | Feistelネットワークベースの置換実装 |

### プログラム呼び出し階層図

```
tf.random.experimental.index_shuffle (Python API)
    │
    └─ RandomIndexShuffle Op
           ├─ StatelessRandomPermuteShape (形状推論)
           │      ├─ Case 1: スカラー出力
           │      ├─ Case 2: UnknownShape
           │      └─ Case 3: ベクトル出力サイズ計算
           └─ Kernel実装 (Feistel network)
```

### データフロー図

```
[入力]                     [処理]                          [出力]

index (scalar/vector)  ───▶  RandomIndexShuffle       ───▶  output (scalar/vector)
seed [3] or [n,3]      ───▶  Feistel Network置換             シャッフル済みインデックス
max_index              ───▶  (rounds回適用)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| random_index_shuffle_ops.cc | `tensorflow/core/ops/random_index_shuffle_ops.cc` | ソース | Op定義と形状推論 |
| random_index_shuffle_ops.cc | `tensorflow/core/kernels/random_index_shuffle_ops.cc` | ソース | カーネル実装 |
