# 機能設計書 97-ロギング操作

## 概要

本ドキュメントは、TensorFlowにおけるロギング操作（Logging Operations）機能の設計を記述する。Print・Assert・Summaryなどのロギング操作を提供する。

### 本機能の処理概要

**業務上の目的・背景**：機械学習モデルの開発と運用において、実行中のテンソル値の出力やアサーション、TensorBoard向けのサマリー記録は不可欠なデバッグ・監視手段である。本機能は、計算グラフ実行中にテンソル値を出力し、条件チェックを行い、TensorBoard向けのサマリーデータを生成するOp群を提供する。

**機能の利用シーン**：モデル学習中の中間テンソル値の確認（Print）、入力データの妥当性検証（Assert）、学習メトリクスのTensorBoard可視化（TensorSummary, ImageSummary, AudioSummary）、タイムスタンプ取得（Timestamp）に使用される。

**主要な処理内容**：
1. `Assert` - 条件が偽の場合にエラーを発生させるアサーション
2. `Print` / `PrintV2` - テンソル値を標準出力/標準エラー出力に表示
3. `TensorSummary` / `TensorSummaryV2` - テンソルのサマリーProtoBuf生成
4. `ImageSummary` - 画像テンソルのサマリー生成
5. `AudioSummaryV2` / `AudioSummary` - 音声テンソルのサマリー生成
6. `Timestamp` - 現在のUnixタイムスタンプを取得

**関連システム・外部連携**：TensorBoard（サマリー可視化）と連携。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

ロギング・監視処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| condition | bool | Yes（Assert） | アサーション条件 | スカラー |
| data | T | Yes（Assert/Print） | 出力するデータテンソル | - |
| input | string | Yes（PrintV2） | 出力文字列 | スカラー |
| tag | string | Yes（Summary系） | サマリータグ | - |
| tensor | T | Yes（Summary系） | サマリー対象テンソル | - |
| sample_rate | float | Yes（AudioSummaryV2） | 音声サンプルレート | - |
| summarize | int | No | 出力要約数（デフォルト: 3） | - |
| message | string | No（Print） | メッセージプレフィックス | - |
| first_n | int | No（Print） | 最初のN回のみ出力（デフォルト: -1、無制限） | - |
| output_stream | string | No（PrintV2） | 出力先ストリーム（デフォルト: "stderr"） | - |
| end | string | No（PrintV2） | 行末文字（デフォルト: "\n"） | - |
| max_images | int | No（ImageSummary） | 最大画像数（デフォルト: 3） | >= 1 |
| max_outputs | int | No（AudioSummary） | 最大出力数（デフォルト: 3） | >= 1 |

### 入力データソース

計算グラフ内のテンソル。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output (Print) | T | 入力テンソルのパススルー |
| summary | string | SerializeされたSummary ProtoBuf |
| ts (Timestamp) | float64 | Unixタイムスタンプ |

### 出力先

- Print/PrintV2: 標準出力/標準エラー出力
- Assert: エラー出力（条件不成立時）
- Summary系: TensorBoardログディレクトリ
- Timestamp: 計算グラフ内の後続処理

## 処理フロー

### 処理シーケンス

```
1. Assert実行
   └─ condition = false の場合、dataテンソルの内容と共にエラーを出力
2. Print実行
   └─ 入力テンソルの値をmessage付きで出力、入力テンソルをそのまま返却
3. PrintV2実行
   └─ 文字列テンソルを指定ストリーム（stderr/stdout）に出力
4. Summary生成
   └─ テンソル値をSummary ProtoBuf形式にシリアライズ
5. Timestamp取得
   └─ 現在時刻をfloat64スカラーとして返却
```

### フローチャート

```mermaid
flowchart TD
    A[入力テンソル] --> B{Op種別}
    B -->|Assert| C{condition?}
    C -->|true| D[何もしない]
    C -->|false| E[エラー出力 + data表示]
    B -->|Print| F[テンソル値をstdout出力]
    F --> G[入力テンソルをパススルー]
    B -->|PrintV2| H[文字列をstderr/stdout出力]
    B -->|Summary| I[Summary ProtoBuf生成]
    B -->|Timestamp| J[float64タイムスタンプ返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-97-01 | Assert副作用 | Assertは出力なし（NoOutputs）、条件不成立時にエラーを発生 | Assert |
| BR-97-02 | Printパススルー | Print Opは入力テンソルをそのまま出力として返す | Print |
| BR-97-03 | PrintV2入力制約 | PrintV2の入力はスカラー文字列 | PrintV2 |
| BR-97-04 | ステートフル | Assert, Print, PrintV2, Timestampはステートフル（SetIsStateful） | 該当Op |
| BR-97-05 | Dataset互換 | Assert, Print, PrintV2, TimestampはDataset関数内で使用可能 | ALLOW_STATEFUL_OP |
| BR-97-06 | AudioSummary非推奨 | AudioSummary（v1）は非推奨、AudioSummaryV2を使用すべき | AudioSummary |

### 計算ロジック

- Summary系Opの出力形状はスカラー（ScalarShape）
- ImageSummaryのbad_color属性でNaN値の代替色を指定可能

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidArgument | 形状不正 | PrintV2の入力がスカラーでない | スカラー文字列テンソルを入力 |
| InvalidArgument | アサーション失敗 | Assert条件がfalse | データ検証ロジックの修正 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- Print/Assertは副作用を持つため、グラフ最適化で除去されないよう注意
- Summary系Opはsummarize属性で出力量を制限可能

## セキュリティ考慮事項

- Printでモデルやデータのセンシティブな情報が出力される可能性がある
- 本番環境ではPrintの使用を避けるか、first_nで出力回数を制限すること

## 備考

- AudioSummaryは deprecated（バージョン15から）、AudioSummaryV2を使用
- ImageSummaryのT属性: uint8, float, half, float64をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Op定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logging_ops.cc | `tensorflow/core/ops/logging_ops.cc` | 全10種のロギングOp定義 |

**主要処理フロー**:
1. **25-31行目**: `Assert` Op - 条件チェック、出力なし
2. **35-45行目**: `Print` Op - テンソル値出力、入力パススルー
3. **49-63行目**: `PrintV2` Op - 文字列出力、スカラー入力制約
4. **71-79行目**: `TensorSummaryV2` Op - V2サマリー（メタデータ付き）
5. **81-88行目**: `TensorSummary` Op - テンソルサマリー
6. **90-100行目**: `ImageSummary` Op - 画像サマリー（bad_color属性あり）
7. **102-108行目**: `AudioSummaryV2` Op - V2音声サマリー
8. **110-117行目**: `AudioSummary` Op - 音声サマリー（非推奨）
9. **119-122行目**: `Timestamp` Op - タイムスタンプ取得

**読解のコツ**: `ALLOW_STATEFUL_OP_FOR_DATASET_FUNCTIONS`マクロにより、Assert/Print/PrintV2/Timestampがtf.dataパイプライン内で使用可能になっている点に注目。

### プログラム呼び出し階層図

```
tf.debugging.assert_* / tf.print / tf.summary.*
    │
    ├─ Assert Op
    │      └─ shape_inference::NoOutputs
    │
    ├─ Print Op / PrintV2 Op
    │      └─ shape_inference::UnchangedShape / スカラー検証
    │
    ├─ TensorSummary / TensorSummaryV2
    │      └─ shape_inference::ScalarShape
    │
    ├─ ImageSummary
    │      └─ shape_inference::ScalarShape
    │
    ├─ AudioSummaryV2 / AudioSummary
    │      └─ shape_inference::ScalarShape
    │
    └─ Timestamp
           └─ shape_inference::ScalarShape
```

### データフロー図

```
[入力]                     [処理]                          [出力]

condition (bool)    ───▶  Assert                     ───▶  (出力なし / エラー)
data (T[])          ───▶

input (T)           ───▶  Print                      ───▶  output (T) = input
data (U[])          ───▶                              ───▶  (stdout副作用)

input (string)      ───▶  PrintV2                    ───▶  (stderr/stdout副作用)

tag (string)        ───▶  ImageSummary               ───▶  summary (string)
tensor (T)          ───▶                                    (serialized Summary proto)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| logging_ops.cc | `tensorflow/core/ops/logging_ops.cc` | ソース | ロギングOp定義 |
| summary_ops.cc | `tensorflow/core/ops/summary_ops.cc` | ソース | 追加サマリーOp定義 |
