# 機能設計書 98-プロファイラAPI

## 概要

本ドキュメントは、TensorFlowにおけるプロファイラAPI（Profiler API）機能の設計を記述する。TensorFlow 2.x向けのモデル実行プロファイリング・パフォーマンス分析機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：機械学習モデルのパフォーマンスボトルネックを特定するため、CPU/GPU/TPUでの実行時間・メモリ使用量をプロファイリングする必要がある。本機能は、TensorFlow 2.x向けのプロファイラAPIとして、プログラマティックモード（手動制御）とサンプリングモード（gRPCサーバー）の2つの動作モードを提供する。

**機能の利用シーン**：モデル学習のボトルネック分析、GPU利用率の確認、Opレベルの実行時間プロファイリング、TensorBoardのProfileタブでの可視化などに使用される。

**主要な処理内容**：
1. `tf.profiler.experimental.start` / `stop` - プロファイリングの開始と停止
2. `tf.profiler.experimental.Profile` - コンテキストマネージャによるプロファイリング
3. `tf.profiler.experimental.server.start` - gRPCプロファイラサーバーの起動
4. `ProfilerOptions` - プロファイラのオプション設定（トレースレベル、遅延等）

**関連システム・外部連携**：TensorBoard Profileプラグイン、gRPCプロファイラサービス、CUPTIライブラリ（GPU）と連携する。

**権限による制御**：同時に1つのプロファイラセッションのみ動作可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない。TensorBoard Profileタブで結果を可視化 |

## 機能種別

プロファイリング・パフォーマンス分析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| logdir | string | Yes（start） | プロファイル結果の保存ディレクトリ | 書き込み可能なパス |
| options | ProfilerOptions | No | プロファイラオプション | - |
| host_tracer_level | int | No | CPUトレースレベル（1-3、デフォルト: 2） | 1-3 |
| python_tracer_level | int | No | Python関数トレース（0: 無効, 1: 有効、デフォルト: 0） | 0-1 |
| device_tracer_level | int | No | デバイストレース（0: 無効, 1: 有効、デフォルト: 1） | 0-1 |
| delay_ms | int | No | プロファイリング開始遅延（ミリ秒） | None許容 |
| port | int | Yes（server.start） | gRPCサーバーポート | 有効なポート番号 |
| save | bool | No（stop） | 結果を保存するか（デフォルト: True） | - |

### 入力データソース

TensorFlowランタイムの実行トレースデータ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プロファイルデータ | ファイル | TensorBoard互換のプロファイルデータ（logdirに保存） |

### 出力先

指定されたlogdirディレクトリ。TensorBoardのProfileタブで可視化。

## 処理フロー

### 処理シーケンス

```
1. プロファイラセッション作成
   └─ _pywrap_profiler.ProfilerSession()の生成
2. プロファイリング開始
   └─ _profiler.start(logdir, opts)の呼び出し
3. モデル訓練/推論の実行
   └─ （ユーザコード）
4. プロファイリング停止
   └─ _profiler.export_to_tb()でTensorBoardにエクスポート
5. プロファイラセッション解放
   └─ _profiler = None
```

### フローチャート

```mermaid
flowchart TD
    A[start呼び出し] --> B{既存セッション?}
    B -->|あり| C[AlreadyExistsError]
    B -->|なし| D[ProfilerSession生成]
    D --> E[profiler.start実行]
    E --> F[モデル実行]
    F --> G[stop呼び出し]
    G --> H{save=True?}
    H -->|Yes| I[export_to_tb実行]
    H -->|No| J[セッション破棄のみ]
    I --> K[セッション解放]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-98-01 | 排他制御 | 同時に1つのプロファイラセッションのみ動作可能 | 常時 |
| BR-98-02 | スレッドセーフ | _profiler_lockによるスレッドセーフなセッション管理 | 常時 |
| BR-98-03 | サーバーモード排他 | サーバーモードとプログラマティックモードの同時使用は未定義動作 | 常時 |
| BR-98-04 | Kerasコールバック連携 | KarasのTensorBoardコールバックは自動サンプリングプロファイリングを実行 | コールバック使用時 |

### 計算ロジック

該当なし。プロファイリングはランタイムのトレースデータ収集。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。プロファイルデータはファイルシステムに保存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| AlreadyExistsError | セッション競合 | 別のプロファイラが既に実行中 | 先に既存セッションをstop |
| UnavailableError | セッション不在 | stop呼び出し時にプロファイラが動作していない | start後にstopを呼び出し |

### リトライ仕様

プロファイラサーバーモードでは、クライアントからのリトライに対応。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- プロファイリング自体がモデル実行にオーバーヘッドを与える
- warmup()関数でCUPTIライブラリの事前ロードが可能（GPU精度向上）
- host_tracer_level, device_tracer_levelでトレース粒度を制御

## セキュリティ考慮事項

- gRPCプロファイラサーバーは認証なしでリクエストを受け付ける
- プロファイルデータにはモデル構造の情報が含まれる

## 備考

- warmup()関数は空のプロファイリングセッションを実行し、CUPTIの初期化オーバーヘッドを排除する
- コンテキストマネージャ（Profile class）を使用すると、start/stopの管理が自動化される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `ProfilerOptions` namedtuple（46-77行目） |

**読解のコツ**: `ProfilerOptions`は`host_tracer_level`, `python_tracer_level`, `device_tracer_level`, `delay_ms`の4フィールドを持つnamedtuple。pybind11がnamedtupleをサポートしないため、dict変換して渡す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `start()`関数（81-126行目） |
| 2-2 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `stop()`関数（129-153行目） |

**主要処理フロー**:
1. **107-108行目**: `start()` - _profiler_lockでスレッド排他制御
2. **109-111行目**: 既存セッションチェック、AlreadyExistsError
3. **112行目**: `_pywrap_profiler.ProfilerSession()`生成
4. **116-117行目**: opts辞書変換、`_profiler.start(logdir, opts)`
5. **142-143行目**: `stop()` - セッション不在チェック、UnavailableError
6. **148-149行目**: `_profiler.export_to_tb()`でTensorBoardにエクスポート

#### Step 3: コンテキストマネージャとサーバーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `Profile`クラス（184-212行目） |
| 3-2 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `start_server()`関数（168-180行目） |
| 3-3 | profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | `warmup()`関数（156-165行目） |

**主要処理フロー**:
- **208-209行目**: `__enter__` → `start(self._logdir, self._options)`
- **211-212行目**: `__exit__` → `stop()`
- **164-165行目**: `warmup()` → `start('')` + `stop(save=False)`

### プログラム呼び出し階層図

```
tf.profiler.experimental.start(logdir, options)
    │
    ├─ _profiler_lock.acquire()
    ├─ _pywrap_profiler.ProfilerSession()
    ├─ options._asdict() → dict変換
    └─ _profiler.start(logdir, opts)

tf.profiler.experimental.stop(save=True)
    │
    ├─ _profiler_lock.acquire()
    ├─ _profiler.export_to_tb()  (save=True時)
    └─ _profiler = None

tf.profiler.experimental.Profile(logdir, options)
    │
    ├─ __enter__ → start(logdir, options)
    └─ __exit__ → stop()

tf.profiler.experimental.server.start(port)
    │
    └─ _pywrap_profiler.start_server(port)
```

### データフロー図

```
[入力]                     [処理]                          [出力]

logdir (string)     ───▶  ProfilerSession.start()    ───▶  トレースデータ収集開始
options (dict)      ───▶

（モデル実行中）      ───▶  CUPTI/Host Tracer         ───▶  トレースイベント蓄積

                    ───▶  ProfilerSession.export()   ───▶  プロファイルデータ
                                                           (logdir/plugins/profile/)
                                                           → TensorBoard Profile Tab
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | ソース | TF2.x プロファイラAPI（start/stop/Profile/server） |
| _pywrap_profiler.py | `tensorflow/python/profiler/internal/_pywrap_profiler.py` | バインディング | C++プロファイラのPythonバインディング |
