---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-TPUレプリケーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/tpu_replication_ops.cc` - レプリケーションOp登録定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TPUReplicateMetadataはnum_replicas >= 0を持つ | E-01 (29行目) | ○ |
| C-02 | num_cores_per_replicaのデフォルトは1 | E-01 (30行目) | ○ |
| C-03 | TPUReplicatedInputは全入力の形状をマージする | E-01 (55-62行目) | ○ |
| C-04 | DT_RESOURCE型でハンドル統合が行われる | E-01 (66-83行目) | ○ |
| C-05 | TPUReplicatedOutputは入力をnum_replicas個にコピー | E-01 (87-97行目) | ○ |
| C-06 | TPUCompilationResultはスカラー文字列出力 | E-01 (99-101行目) | ○ |
| C-07 | _TPUReplicateはcomputation関数属性を持つ | E-01 (104行目) | ○ |
| C-08 | use_spmd_for_xla_partitioning属性がある | E-01 (40, 120行目) | ○ |
| C-09 | use_shardy_partitioner属性がある | E-01 (41, 121行目) | ○ |
| C-10 | computation_shapeは非推奨 | E-01 (34-35行目コメント) | ○ |
| C-11 | TPUDummyInputはfloat/bfloat16型でSetDoNotOptimize | E-01 (132-134行目) | ○ |
| C-12 | is_mirrored_variable/is_packed属性がTPUReplicatedInputに存在 | E-01 (50-54行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: Op登録定義の正確性（低リスク - ソースコードから直接確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] tpu_replication_ops.ccの全6 Opが設計書に反映されているか
- [ ] TPUReplicatedInputのShapeFnロジックが正確に記述されているか
