---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-TPUクロスレプリカ操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/tpu_cross_replica_ops.cc` - クロスレプリカOp登録定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllToAllはnumbertype+bool型をサポート | E-01 (29行目) | ○ |
| C-02 | split_count >= 1の検証が行われる | E-01 (47-50行目) | ○ |
| C-03 | group_assignmentはランク2である必要がある | E-01 (51-53行目) | ○ |
| C-04 | group_assignment第2次元がsplit_countと一致する必要がある | E-01 (55-61行目) | ○ |
| C-05 | concat_dimensionの範囲検証がある | E-01 (65-68行目) | ○ |
| C-06 | split_dimensionの範囲検証がある | E-01 (70-74行目) | ○ |
| C-07 | 出力形状でconcat方向がsplit_count倍になる | E-01 (88行目) | ○ |
| C-08 | 出力形状でsplit方向が1/split_countになる | E-01 (97行目) | ○ |
| C-09 | split方向のサイズがsplit_countで割り切れる必要がある | E-01 (91-96行目) | ○ |
| C-10 | CrossReplicaSumはhalf/bfloat16/float/float64/int32/uint32型 | E-01 (109行目) | ○ |
| C-11 | CrossReplicaSumはUnchangedShape | E-01 (111行目) | ○ |
| C-12 | CollectivePermuteはnumbertype、UnchangedShape | E-01 (117, 119行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張がソースコードから直接確認済み（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] tpu_cross_replica_ops.ccの全3 Opが設計書に反映されているか
- [ ] AllToAllの出力形状計算ロジックが正確か
