---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-テンソル操作ユーティリティ（Manip Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/manip_ops.cc` - Roll Op登録定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Roll Opは入力テンソル、shift、axisの3入力を持つ | E-01 (24-28行目) | ○ |
| C-02 | T型属性で任意の型をサポート | E-01 (28行目) | ○ |
| C-03 | Tshiftはint32/int64 | E-01 (29行目) | ○ |
| C-04 | Taxisはint32/int64 | E-01 (30行目) | ○ |
| C-05 | 入力テンソルはランク1以上の制約 | E-01 (34行目) | ○ |
| C-06 | shiftはランク1以下の制約 | E-01 (36行目) | ○ |
| C-07 | axisはランク1以下の制約 | E-01 (38行目) | ○ |
| C-08 | shiftとaxisは同一形状でマージされる | E-01 (40行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張がソースコードから直接確認済み（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] manip_ops.ccのRoll Opが設計書に正確に反映されているか
