---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-マップ操作（Map Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/map_ops.cc` - TensorMap Op登録定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EmptyTensorMapはスカラーvariant出力 | E-01 (24-29行目) | ○ |
| C-02 | TensorMapSizeはスカラーint32出力 | E-01 (31-34行目) | ○ |
| C-03 | TensorMapLookupはkey_dtype/value_dtype属性を持つ | E-01 (36-45行目) | ○ |
| C-04 | TensorMapLookupの出力はUnknownShape | E-01 (43行目) | ○ |
| C-05 | TensorMapInsertはスカラーvariant出力 | E-01 (54-56行目) | ○ |
| C-06 | TensorMapEraseはkey_dtypeとvalue_dtype両方の属性を持つ | E-01 (63-64行目) | ○ |
| C-07 | TensorMapHasKeyはスカラーbool出力 | E-01 (70-75行目) | ○ |
| C-08 | TensorMapStackKeysの出力はUnknownShape | E-01 (82行目) | ○ |
| C-09 | 現在はスカラー値のみサポート（TODO記載あり） | E-01 (23行目コメント) | ○ |
| C-10 | 全7 OpがTensorMapプレフィックスを持つ（EmptyTensorMap含む） | E-01 (全体) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張がソースコードから直接確認済み（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] map_ops.ccの全7 Opが設計書に反映されているか
- [ ] スカラー値のみサポートの制限が正確に記述されているか
