---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：121-候補サンプリング操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **対数一様分布の計算式**: 数学的定義の正確性を要確認
  2. **カーネル実装の存在確認**: Op登録のみ確認、カーネル実装は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/core/ops/candidate_sampling_ops.cc` - Op定義ファイル（6種サンプラー + ComputeAccidentalHits）
- E-02: `tensorflow/core/ops/candidate_sampling_ops.cc:27-42` - CandidateSamplerShapeFn関数
- E-03: `tensorflow/core/ops/candidate_sampling_ops.cc:46-58` - UniformCandidateSampler登録
- E-04: `tensorflow/core/ops/candidate_sampling_ops.cc:60-72` - LogUniformCandidateSampler登録
- E-05: `tensorflow/core/ops/candidate_sampling_ops.cc:102-120` - FixedUnigramCandidateSampler登録
- E-06: `tensorflow/core/ops/candidate_sampling_ops.cc:135-164` - ComputeAccidentalHits登録
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.121の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6種類のサンプラーOpが存在する | E-01 | ○ |
| C-02 | true_classesは2次元int64テンソル | E-02, E-03 | ○ |
| C-03 | 出力は3つ: sampled_candidates, true_expected_count, sampled_expected_count | E-02 | ○ |
| C-04 | num_true >= 1, num_sampled >= 1の制約 | E-03 | ○ |
| C-05 | unique属性によるサンプリング重複制御 | E-03 | ○ |
| C-06 | range_max >= 1の制約 | E-03 | ○ |
| C-07 | FixedUnigramはvocab_file, distortion, unigrams等の追加属性を持つ | E-05 | ○ |
| C-08 | ComputeAccidentalHitsは正解とサンプルの一致を検出する | E-06 | ○ |
| C-09 | CandidateSamplerShapeFnが全サンプラーに共通の形状推論を行う | E-02 | ○ |
| C-10 | 出力形状: [num_sampled], [batch_size, num_true], [num_sampled] | E-02 | ○ |
| C-11 | SetIsStateful()により全サンプラーはステートフル | E-03, E-04 | ○ |
| C-12 | seed, seed2の乱数シード属性を持つ | E-03 | ○ |
| C-13 | AllCandidateSamplerはrange_max属性を持たない | E-01 | ○ |
| C-14 | 対数一様分布の計算式 P(class) = (log(class+2) - log(class+1)) / log(range_max+1) | **根拠なし** | △ |
| C-15 | カーネル実装が存在し実際に動作する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 対数一様分布の正確な計算式はOp定義ファイルには記載がなく、カーネル実装またはドキュメントからの確認が必要
  - 候補：カーネル実装ファイル / TensorFlow公式ドキュメント / 論文
- カーネル実装ファイルの調査が未実施
  - 候補：`tensorflow/core/kernels/candidate_sampler_ops.cc` / テストファイル

## 5) リスクフラグ（レビュー観点）
- 0: Op定義の入出力仕様（コードから直接確認可能）
- 1: 計算ロジックの数学的正確性（カーネル実装の確認が必要）
- 0: 形状推論ロジック（コードから直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] 6種類のサンプラーOpの説明が網羅的か確認
- [ ] 対数一様分布の計算式がTensorFlow公式ドキュメントと一致するか確認
- [ ] ComputeAccidentalHitsの出力形状の説明が正確か確認
- [ ] FixedUnigramCandidateSamplerの追加パラメータ（num_shards, shard）が設計書に含まれているか確認
