---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：122-SDCA操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **SDCA双対問題の計算式**: 数学的定義の正確性を要確認
  2. **tf.estimatorとの統合関係**: 具体的な統合コードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/sdca_ops.cc` - Op定義ファイル全体
- E-02: `tensorflow/core/ops/sdca_ops.cc:26-39` - ApplySdcaOptimizerShapeFn
- E-03: `tensorflow/core/ops/sdca_ops.cc:41-66` - SdcaOptimizer V1登録
- E-04: `tensorflow/core/ops/sdca_ops.cc:68-94` - SdcaOptimizerV2登録（コメント含む）
- E-05: `tensorflow/core/ops/sdca_ops.cc:96-101` - SdcaShrinkL1登録
- E-06: `tensorflow/core/ops/sdca_ops.cc:103-113` - SdcaFprint登録
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.122の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5種類の損失関数をサポート | E-03 | ○ |
| C-02 | V1はadaptative(typo), V2はadaptiveに修正 | E-03, E-04 | ○ |
| C-03 | L1/L2正則化パラメータを持つ | E-03 | ○ |
| C-04 | スパース特徴量と密特徴量の両方を入力可能 | E-03 | ○ |
| C-05 | out_example_state_dataの形状が[unknown, 4] | E-02 | ○ |
| C-06 | 出力はdelta_sparse_weightsとdelta_dense_weights | E-02 | ○ |
| C-07 | SdcaShrinkL1はRef型で重みを直接更新 | E-05 | ○ |
| C-08 | SdcaFprintは[N, 2]のint64を出力 | E-06 | ○ |
| C-09 | num_loss_partitions >= 1, num_inner_iterations >= 1の制約 | E-03 | ○ |
| C-10 | ApplySdcaOptimizerShapeFnがV1/V2共通 | E-02, E-03, E-04 | ○ |
| C-11 | 4つのOp(SdcaOptimizer, V2, ShrinkL1, Fprint)が登録される | E-01 | ○ |
| C-12 | adaptive属性のデフォルトはfalse | E-04 | ○ |
| C-13 | SDCAの双対問題の計算式 | **根拠なし** | △ |
| C-14 | tf.estimatorのLinearClassifierで内部利用される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SDCAアルゴリズムの数学的詳細はOp定義からは読み取れない。カーネル実装の確認が必要
  - 候補：カーネル実装ファイル / 原著論文(Shalev-Shwartz & Zhang, 2013)
- tf.estimatorとの統合コードの確認
  - 候補：`tensorflow/python/estimator/` / `tensorflow/contrib/linear_optimizer/`

## 5) リスクフラグ（レビュー観点）
- 0: Op定義の入出力仕様（コードから直接確認可能）
- 1: SDCAアルゴリズムの数学的記述の正確性
- 0: V1/V2の差異の記述

## 6) レビュアーチェックリスト（最小）
- [ ] 5種類の損失関数がすべて列挙されているか確認
- [ ] SDCAの数学的記述が原著論文と一致するか確認
- [ ] SdcaShrinkL1のRef型入力の意味が正確に記述されているか確認
- [ ] V1/V2のtypo修正に関する記述が正確か確認
