---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：123-Word2Vec操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **サブサンプリング確率の計算式**: カーネル実装での確認が必要
  2. **負例サンプリングの3/4乗分布**: 論文由来の記述でコード確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/word2vec_ops.cc` - Op定義ファイル全体
- E-02: `tensorflow/core/ops/word2vec_ops.cc:21-38` - Skipgram Op登録
- E-03: `tensorflow/core/ops/word2vec_ops.cc:40-52` - NegTrain Op登録
- E-04: `tensorflow/core/ops/word2vec_ops.cc:22-24` - Deprecated指定（バージョン19）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.123の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン19で非推奨 | E-04 | ○ |
| C-02 | tensorflow_models/tutorialsへ移行 | E-04 | ○ |
| C-03 | Skipgram Opは7つの出力を持つ | E-02 | ○ |
| C-04 | NegTrain OpはRef(float)のw_in, w_outを入力に持つ | E-03 | ○ |
| C-05 | window_sizeのデフォルトは5 | E-02 | ○ |
| C-06 | min_countのデフォルトは5 | E-02 | ○ |
| C-07 | subsampleのデフォルトは1e-3 | E-02 | ○ |
| C-08 | NegTrain Opはステートフル | E-03 | ○ |
| C-09 | Skipgram Opはステートフル | E-02 | ○ |
| C-10 | NegTrain Opには出力テンソルがない | E-03 | ○ |
| C-11 | サブサンプリング確率: P(w) = 1 - sqrt(subsample / freq(w)) | **根拠なし** | △ |
| C-12 | 負例サンプリングは3/4乗確率分布 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- サブサンプリングと負例サンプリングの具体的な計算式はOp定義からは確認できない
  - 候補：カーネル実装 / Mikolov et al. (2013) 原著論文
- カーネル実装ファイルの所在確認が未実施
  - 候補：`tensorflow/core/kernels/word2vec_kernels.cc`

## 5) リスクフラグ（レビュー観点）
- 0: 非推奨ステータスの記述（コードから直接確認可能）
- 1: 計算式の正確性（カーネル実装の確認が必要）
- 0: Op入出力仕様（コードから直接確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨の理由と移行先が正確か確認
- [ ] Skipgram Opの7つの出力がすべて記載されているか確認
- [ ] 計算式がMikolov et al. (2013)の論文と一致するか確認
- [ ] NegTrain OpのRef型入力の説明が適切か確認
