---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：127-送受信操作（Send/Recv）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **Rendezvousメカニズムの詳細**: ランタイム実装の確認が必要
  2. **gRPC通信の具体的なリトライ仕様**: 分散ランタイムコードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/sendrecv_ops.cc` - Op定義ファイル全体
- E-02: `tensorflow/core/ops/sendrecv_ops.cc:21-43` - _Send Op登録（Docコメント）
- E-03: `tensorflow/core/ops/sendrecv_ops.cc:56-79` - _Recv Op登録（Docコメント）
- E-04: `tensorflow/core/ops/sendrecv_ops.cc:93-118` - _HostSend Op登録（Docコメント）
- E-05: `tensorflow/core/ops/sendrecv_ops.cc:120-148` - _HostRecv Op登録（Docコメント）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.127の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6つのOp: _Send, Send, _Recv, Recv, _HostSend, _HostRecv | E-01 | ○ |
| C-02 | tensor_name, send_device, recv_deviceの共通属性 | E-02, E-03 | ○ |
| C-03 | send_device_incarnationでデバイス世代を識別 | E-02 | ○ |
| C-04 | client_terminatedはfeed/fetch操作で使用 | E-02 | ○ |
| C-05 | _HostSendはホストメモリ上の入力を要求 | E-04 | ○ |
| C-06 | _HostRecvはホストメモリ上に出力 | E-05 | ○ |
| C-07 | _Recv, Recv, _HostRecvはSetIsDistributedCommunication() | E-03, E-05 | ○ |
| C-08 | Send系Opは出力テンソルを持たない | E-02 | ○ |
| C-09 | Recv系Opはtensor_type型のテンソルを出力 | E-03 | ○ |
| C-10 | 全OpがSetIsStateful() | E-01 | ○ |
| C-11 | 公開版と内部版(_付き)が存在 | E-01 | ○ |
| C-12 | 形状推論はUnknownShape | E-02, E-03 | ○ |
| C-13 | Rendezvousメカニズムにより順序非依存でデータ転送 | **根拠なし** | △ |
| C-14 | gRPC通信エラー時のランタイムレベルリトライ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Rendezvousメカニズムの詳細実装はランタイムコードの確認が必要
  - 候補：`tensorflow/core/distributed_runtime/` / `tensorflow/core/common_runtime/rendezvous_mgr.h`
- gRPCリトライ仕様の確認
  - 候補：`tensorflow/core/distributed_runtime/rpc/`

## 5) リスクフラグ（レビュー観点）
- 0: Op定義の仕様（コードから直接確認可能）
- 1: Rendezvousメカニズムの詳細
- 1: 分散通信のリトライ仕様

## 6) レビュアーチェックリスト（最小）
- [ ] 6つのOpの入出力がすべて記載されているか確認
- [ ] ホストメモリ版とデバイスメモリ版の差異が明確か確認
- [ ] client_terminated属性の説明が正確か確認
- [ ] SetIsDistributedCommunication()のマークが正しいOpに適用されているか確認
