---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：128-特殊数学関数操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **特殊関数の数学的定義の正確性**: 数学リファレンスとの照合が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/special_math_ops.cc` - Op定義ファイル全体
- E-02: `tensorflow/core/ops/special_math_ops.cc:23-27` - UNARY_REALマクロ定義
- E-03: `tensorflow/core/ops/special_math_ops.cc:29-33` - 基本特殊関数Op登録
- E-04: `tensorflow/core/ops/special_math_ops.cc:37-50` - ベッセル関数Op登録
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.128の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 17個のOpが定義されている | E-01 | ○ |
| C-02 | UNARY_REALマクロで共通パターンを定義 | E-02 | ○ |
| C-03 | 型制約: bfloat16, half, float, double | E-02 | ○ |
| C-04 | 形状推論はUnchangedShape | E-02 | ○ |
| C-05 | 入力x: T, 出力y: T | E-02 | ○ |
| C-06 | 5つの基本特殊関数: Dawsn, Expint, FresnelCos, FresnelSin, Spence | E-03 | ○ |
| C-07 | 4つの第1種修正ベッセル関数: BesselI0, I1, I0e, I1e | E-04 | ○ |
| C-08 | 4つの第2種修正ベッセル関数: BesselK0, K1, K0e, K1e | E-04 | ○ |
| C-09 | 4つの第1種・第2種ベッセル関数: BesselJ0, J1, Y0, Y1 | E-04 | ○ |
| C-10 | numeric_op.hをインクルードしている | E-01 | ○ |
| C-11 | 指数スケーリング版(e付き)は大きなxに対する数値安定性を向上 | E-01 | ○ |
| C-12 | 各特殊関数の数学的定義（積分表現） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各特殊関数の積分表現はOp定義からは確認できない。数学リファレンスからの引用
  - 候補：Abramowitz and Stegun / DLMF (Digital Library of Mathematical Functions) / scipy.special

## 5) リスクフラグ（レビュー観点）
- 0: Op定義の仕様（コードから直接確認可能）
- 0: UNARY_REALマクロのパターン
- 1: 特殊関数の数学的定義の正確性

## 6) レビュアーチェックリスト（最小）
- [ ] 17個のOpがすべて列挙されているか確認
- [ ] ベッセル関数の分類（第1種/第2種/修正）が正確か確認
- [ ] 特殊関数の数学的定義がDLMFなどのリファレンスと一致するか確認
- [ ] 指数スケーリング版の説明が正確か確認
