---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：130-プロジェクト設定（Configure）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **CUDA/ROCm設定の全手順**: configure.pyの後半部分（未読部分）の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `configure.py` - メイン設定スクリプト（先頭200行を読取）
- E-02: `configure.py:28` - _DEFAULT_CUDA_COMPUTE_CAPABILITIES = '3.5,7.0'
- E-03: `configure.py:30` - _SUPPORTED_ANDROID_NDK_VERSIONS = [19, 20, 21, 25]
- E-04: `configure.py:32` - _DEFAULT_PROMPT_ASK_ATTEMPTS = 10
- E-05: `configure.py:34-36` - _TF_BAZELRC_FILENAME, _TF_WORKSPACE_ROOT等
- E-06: `configure.py:39-41` - NCCL_LIB_PATHS
- E-07: `configure.py:44-54` - APPLE_BAZEL_FILES, IOS_FILES
- E-08: `configure.py:57-58` - UserInputError例外クラス
- E-09: `configure.py:61-82` - プラットフォーム判定関数群
- E-10: `configure.py:85-138` - ユーティリティ関数群
- E-11: `configure.py:146-199` - Python環境設定関数群
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.130の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | .tf_configure.bazelrcを生成する | E-05 | ○ |
| C-02 | CUDAコンピュート能力のデフォルトは3.5,7.0 | E-02 | ○ |
| C-03 | サポートされるAndroid NDKバージョンは19, 20, 21, 25 | E-03 | ○ |
| C-04 | ユーザ入力は最大10回リトライ | E-04 | ○ |
| C-05 | NCCLパスはlib64/等の順に検索 | E-06 | ○ |
| C-06 | Apple関連のBUILDファイルを設定 | E-07 | ○ |
| C-07 | UserInputError例外クラスが定義されている | E-08 | ○ |
| C-08 | Windows/Linux/macOS/Cygwinのプラットフォーム判定 | E-09 | ○ |
| C-09 | Python 2/3互換のユーザ入力取得 | E-10 | ○ |
| C-10 | symlink_force()で既存リンクを強制上書き | E-10 | ○ |
| C-11 | write_to_bazelrc()で設定を追記 | E-10 | ○ |
| C-12 | sys.executableをデフォルトPythonパスとして使用 | E-11 | ○ |
| C-13 | get_python_path()でサイトパッケージを取得 | E-11 | ○ |
| C-14 | CUDA/cuDNN/TensorRT/ROCm設定の全手順 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- configure.pyの後半部分（CUDA/ROCm/Android設定の具体的な処理フロー）は部分的にしか読み取れていない
  - 候補：configure.pyの200行目以降を全体読み取り

## 5) リスクフラグ（レビュー観点）
- 0: グローバル定数の値（コードから直接確認可能）
- 0: プラットフォーム判定ロジック（コードから直接確認可能）
- 0: ユーティリティ関数の動作（コードから直接確認可能）
- 1: CUDA/ROCm設定の全手順の網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] .tf_configure.bazelrcの生成フォーマットが正確か確認
- [ ] CUDA設定の全パラメータが記載されているか確認
- [ ] Android NDK/SDK設定の全手順が記載されているか確認
- [ ] プラットフォーム固有の処理が適切に記述されているか確認
