---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：134-Kerasモデル保存

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **model_from_yamlの任意コード実行リスク**：一般的知識に基づく記述

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/keras/saving/save.py` 37-44行目（save_model関数）
- E-02: `tensorflow/python/keras/saving/save.py` 28-33行目（HDF5_PLUGIN_PATH設定）
- E-03: `tensorflow/python/keras/saving/hdf5_format.py` 55行目（save_model_to_hdf5）
- E-04: `tensorflow/python/keras/saving/hdf5_format.py` 36-43行目（h5py import, HDF5_OBJECT_HEADER_LIMIT）
- E-05: `tensorflow/python/keras/saving/save.py` 17-22行目（import構成）
- E-06: `tensorflow/python/keras/saving/save.py` 46-93行目（docstring）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 134行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | save_model関数がSavedModel/HDF5形式で保存 | E-01, E-06 | ○ |
| C-02 | HDF5_PLUGIN_PATHをdisableに設定（ZDI-CAN-25480対策） | E-02, E-04 | ○ |
| C-03 | save_model_to_hdf5でHDF5形式保存 | E-03 | ○ |
| C-04 | HDF5_OBJECT_HEADER_LIMIT=64512 | E-04 | ○ |
| C-05 | TF2ではSavedModel形式がデフォルト | E-05 (tf2 import) | ○ |
| C-06 | saved_model_save/loadモジュールとの連携 | E-05 | ○ |
| C-07 | overwrite=Falseで上書き確認 | E-06 | ○ |
| C-08 | save_traces=Falseでカスタムクラス必須 | E-06 | ○ |
| C-09 | h5pyはオプション依存関係 | E-04 (try/except) | ○ |
| C-10 | SavedModel保存内容（config, weights, optimizer, traced functions） | E-06 | ○ |
| C-11 | HDF5保存内容（config JSON, weights, optimizer state） | E-03 | ○ |
| C-12 | model_from_json/yaml/configで復元可能 | E-05 | ○ |
| C-13 | 機能一覧CSVに記載あり | E-07 | ○ |
| C-14 | model_from_yamlに任意コード実行リスク | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- model_from_yamlのセキュリティリスクの詳細：YAML deserialization攻撃は一般的な脆弱性だが、コード内の明示的な警告は未確認
  - 候補：TensorFlowセキュリティドキュメント / SECURITY.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 保存形式の記述はコードと一致
- 1: 中リスク - ZDI-CAN-25480対策の記述は正確だが、詳細な脆弱性説明が必要かもしれない

## 6) レビュアーチェックリスト（最小）
- [ ] SavedModel/HDF5の保存内容が正確に記述されているか確認
- [ ] ZDI-CAN-25480対策の記述が正確か確認
- [ ] load_modelの形式自動判定ロジックの詳細確認
- [ ] model_from_yamlのセキュリティリスクの妥当性確認
