---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：135-スコープドアロケータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Grappler最適化パスとの連携詳細**：カーネル実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/scoped_allocator_ops.cc` 21-49行目（_ScopedAllocator Op）
- E-02: `tensorflow/core/ops/scoped_allocator_ops.cc` 51-83行目（_ScopedAllocatorConcat Op）
- E-03: `tensorflow/core/ops/scoped_allocator_ops.cc` 85-117行目（_ScopedAllocatorSplit Op）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 135行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つのOp（_ScopedAllocator, Concat, Split）が定義されている | E-01, E-02, E-03 | ○ |
| C-02 | 全Opsが実験的な内部操作でunsafeな使用が可能 | E-01 (Doc文字列) | ○ |
| C-03 | 全OpsがSetIsStateful()でステートフルとマーク | E-01, E-02, E-03 | ○ |
| C-04 | _ScopedAllocatorがshapes, shape, T, sa_name, id, expected_call_count属性を持つ | E-01 | ○ |
| C-05 | _ScopedAllocatorConcatがbacking入力 + N個のinputsを持つ | E-02 | ○ |
| C-06 | _ScopedAllocatorSplitがconcat入力 + N個のsplit入力を持つ | E-03 | ○ |
| C-07 | N >= 2の制約がある | E-02, E-03 | ○ |
| C-08 | reshape属性はConcatのみにある | E-02 | ○ |
| C-09 | ExplicitShape/ExplicitShapesのShapeFnを使用 | E-01, E-02, E-03 | ○ |
| C-10 | Op名がアンダースコアで始まり内部操作を示す | E-01, E-02, E-03 | ○ |
| C-11 | 機能一覧CSVに記載あり | E-04 | ○ |
| C-12 | Grappler最適化のScopedAllocatorOptimizationパスにより挿入 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ScopedAllocatorOptimizationパスの実装：grappler/ディレクトリ内の最適化パス実装を確認する必要がある
  - 候補：`tensorflow/core/grappler/optimizers/scoped_allocator_optimizer.cc`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義の記述はソースコードと完全一致
- 1: 中リスク - Grapplerとの連携詳細は推定を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 3つのOp定義が正確に記述されているか確認
- [ ] Grappler最適化パスとの連携が正しいか確認
- [ ] AllReduce操作との関係が正しいか確認
