---
generated_at: 2026-02-02 11:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：137-混同行列計算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/ops/confusion_matrix.py` 92-93行目（tf_export定義）
- E-02: `tensorflow/python/ops/confusion_matrix.py` 100-149行目（docstring）
- E-03: `tensorflow/python/ops/confusion_matrix.py` 150-155行目（前処理・キャスト）
- E-04: `tensorflow/python/ops/confusion_matrix.py` 159-167行目（非負値assert）
- E-05: `tensorflow/python/ops/confusion_matrix.py` 169-182行目（num_classes決定・範囲チェック）
- E-06: `tensorflow/python/ops/confusion_matrix.py` 189-196行目（scatter_ndによる行列構築）
- E-07: `tensorflow/python/ops/confusion_matrix.py` 30-89行目（remove_squeezable_dimensions）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 137行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf.math.confusion_matrixとして公開 | E-01 | ○ |
| C-02 | 行=正解ラベル、列=予測ラベル | E-02 (102-103行目) | ○ |
| C-03 | num_classes未指定時にmax+1で自動推論 | E-05 (169-171行目) | ○ |
| C-04 | 非負値assertでメモリ破壊防止 | E-04 (159行目コメント) | ○ |
| C-05 | scatter_ndで混同行列を構築 | E-06 | ○ |
| C-06 | remove_squeezable_dimensionsでランク差調整 | E-07 | ○ |
| C-07 | labels/predictionsをint64にキャスト | E-03 (156-157行目) | ○ |
| C-08 | 重み付き混同行列をサポート | E-06 (184-192行目) | ○ |
| C-09 | num_classes指定時に範囲チェック | E-05 (173-182行目) | ○ |
| C-10 | indices = stack([labels, predictions], axis=1) | E-06 (190行目) | ○ |
| C-11 | v1 APIでtf.confusion_matrixとしても公開 | E-01 (199行目) | ○ |
| C-12 | 機能一覧CSVに記載あり | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] scatter_ndの使用が正しく記述されているか確認
- [ ] remove_squeezable_dimensionsの動作が正確か確認
- [ ] 処理フローが実コードの順序と一致するか確認
