---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-ドロップアウト（Dropout）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **Keras Dropoutレイヤーの実装**：core.pyは未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/ops/nn_ops.py` 5380-5427行目 dropout（V1）
- E-02: `tensorflow/python/ops/nn_ops.py` 5432-5522行目 dropout_v2
- E-03: `tensorflow/python/ops/nn_ops.py` 5740-5817行目 _dropout
- E-04: `tensorflow/python/ops/nn_ops.py` 5525-5555行目 stateless_dropout
- E-05: 機能一覧.csv No.19の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rateの確率でゼロに設定、残りを1/(1-rate)でスケール | E-02 (docstring 5458-5460行目) | ○ |
| C-02 | rate範囲は[0, 1) | E-03 (5764-5766行目) | ○ |
| C-03 | rate=1は禁止 | E-02 (5512-5514行目) | ○ |
| C-04 | 入力は浮動小数点型限定 | E-03 (5769-5772行目) | ○ |
| C-05 | rate=0の高速パス | E-03 (5773-5784行目) | ○ |
| C-06 | dummy_rng_stepがrate=0でも呼ばれる | E-03 (5779-5783行目) | ○ |
| C-07 | 数値rateの場合: scale=1/(1-rate)、x*scale | E-03 (5789-5792行目) | ○ |
| C-08 | Tensor rateの場合: ランク0検証 | E-03 (5797行目) | ○ |
| C-09 | Tensor rateの場合: dtype互換性チェック | E-03 (5800-5803行目) | ○ |
| C-10 | noise_shapeでブロードキャストドロップアウト | E-03 (5808行目) | ○ |
| C-11 | uniform_samplerで乱数テンソル生成 | E-03 (5811行目) | ○ |
| C-12 | keep_mask = random_tensor >= rate | E-03 (5812行目) | ○ |
| C-13 | where_v2でマスク適用 | E-03 (5814行目) | ○ |
| C-14 | V1のkeep_probはrateに変換 | E-01 (5415, 5420-5422行目) | ○ |
| C-15 | dropout_v2はuniform_samplerをpartialで構成 | E-02 (5516行目) | ○ |
| C-16 | stateless版はstateless_random_uniformを使用 | E-04 | ○ |
| C-17 | Keras Dropoutレイヤーは訓練時のみドロップアウト適用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: Keras Dropoutレイヤーの実装はcore.pyにあるが未読み込み
  - 候補：`tensorflow/python/keras/layers/core.py`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - tf.nn.dropout全体の実装は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] _dropout内部のスケーリング計算が数学的に正しいか確認
- [ ] noise_shapeの解決ロジック(_get_noise_shape)を確認
- [ ] Keras Dropoutレイヤーの訓練/推論モード切替を確認
