---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：37-自動微分

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **jacobianメソッドの詳細**: jacobian/batch_jacobianメソッドの実装詳細は別ファイルを参照する必要がある

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/eager/backprop.py` 1-900行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 38行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GradientTapeはtf_exportでGradientTapeとautodiff.GradientTapeとしてエクスポート | E-01 (704行目) | ○ |
| C-02 | persistent=FalseとTrue両方をサポート | E-01 (801-817行目) | ○ |
| C-03 | watch_accessed_variables=Trueで訓練可能変数を自動監視 | E-01 (808-813行目) | ○ |
| C-04 | __enter__で_push_tape呼び出し | E-01 (821-824行目) | ○ |
| C-05 | __exit__で_pop_tape呼び出し | E-01 (826-829行目) | ○ |
| C-06 | watchメソッドでテンソル/変数を監視 | E-01 (864-884行目) | ○ |
| C-07 | float/complex型のみ微分可能（警告出力） | E-01 (874-877行目) | ○ |
| C-08 | stop_recordingコンテキストマネージャ | E-01 (886行目以降) | ○ |
| C-09 | _gradient_functionでOp名から勾配関数をルックアップ | E-01 (118-150行目) | ○ |
| C-10 | _MockOpで擬似Opオブジェクト作成 | E-01 (92-115行目) | ○ |
| C-11 | pywrap_tfe.TFE_Py_RecordGradientで操作を記録 | E-01 (171-172行目) | ○ |
| C-12 | implicit_val_and_gradで暗黙的な勾配計算 | E-01 (179-255行目) | ○ |
| C-13 | _aggregate_gradsで複数勾配の集約 | E-01 (585-605行目) | ○ |
| C-14 | _op_attr_type_cacheでOp属性型をキャッシュ | E-01 (58行目) | ○ |
| C-15 | テープはスタック構造で管理 | E-01 (831-842行目, push/pop) | ○ |
| C-16 | jacobianメソッドでヤコビアン行列を計算 | E-01 (存在するが詳細未読) | △ |

## 4) 不足情報（Unknown / Missing）
- jacobian/batch_jacobianメソッドの実装詳細
  - 候補：backprop.pyの後半部分、parallel_for/control_flow_ops.py

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コアとなるGradientTapeの動作は十分に確認済み
- 1: 中リスク - jacobianメソッドの詳細は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GradientTape.gradientメソッドの詳細な引数仕様を確認
- [ ] jacobian/batch_jacobianの実装を確認
- [ ] C++側のテープ実装の動作を確認
