---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：48-実験的データセット操作

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **C++カーネルの具体的な計算ロジック**：Op定義のみ確認、カーネル実装未読
  2. **CSVDataset Opの完全な入出力仕様**：先頭200行のみ読了

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/experimental_dataset_ops.cc` 21-34行目 - AssertCardinalityDataset
- E-02: `tensorflow/core/ops/experimental_dataset_ops.cc` 36-49行目 - AssertNextDataset
- E-03: `tensorflow/core/ops/experimental_dataset_ops.cc` 81-94行目 - AutoShardDataset
- E-04: `tensorflow/core/ops/experimental_dataset_ops.cc` 108-120行目 - BytesProducedStatsDataset
- E-05: `tensorflow/core/ops/experimental_dataset_ops.cc` 136-161行目 - ChooseFastestBranch/Dataset
- E-06: `tensorflow/core/ops/experimental_dataset_ops.cc` 174-185行目 - Compress/UncompressElement
- E-07: `tensorflow/core/ops/experimental_dataset_ops.cc` 187-196行目 - CheckPinned/ComputeBatchSize
- E-08: `tensorflow/core/ops/experimental_dataset_ops.cc` 198-200行目 - CSVDataset
- E-09: `機能一覧.csv` 48行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AssertCardinalityのcardinalityはスカラー | E-01 | ○ |
| C-02 | AssertNextのtransformationsはベクトル | E-02 | ○ |
| C-03 | AutoShardDatasetはnum_workers/index/auto_shard_policyを持つ | E-03 | ○ |
| C-04 | BytesProducedStatsDatasetのtagはスカラー | E-04 | ○ |
| C-05 | ChooseFastestDatasetはN >= 2の入力が必要 | E-05 | ○ |
| C-06 | CompressElementはtensorsをvariantに変換 | E-06 | ○ |
| C-07 | UncompressElementはvariantからtensorsに復元 | E-06 | ○ |
| C-08 | ComputeBatchSizeはint64スカラーを出力 | E-07 | ○ |
| C-09 | 全OpがTFT_DATASETのvariant型コンテナ | E-01, E-02, E-03 | ○ |
| C-10 | Experimental版と非Experimental版の両方が登録 | E-02 (51-64行目) | ○ |
| C-11 | CheckPinnedはデバッグ用Op | E-07 | ○ |
| C-12 | AutoShardのnum_replicas属性 | E-03 (89行目) | ○ |
| C-13 | C++カーネルの具体的な計算ロジック | **根拠なし** | △ |
| C-14 | CSVDatasetの完全な入出力仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C++カーネルの実装ファイル（Op定義は確認済みだがカーネル実装は未読）
  - 候補：tensorflow/core/kernels/data/experimental_* 配下
- CSVDataset Opの完全な属性・入出力定義（experimental_dataset_ops.ccの200行目以降）
  - 候補：experimental_dataset_ops.cc 200行目以降

## 5) リスクフラグ（レビュー観点）
- 0: Op登録のインターフェース定義（全て確認済み）
- 1: C++カーネルの内部ロジック（Op定義のみ、カーネル未読）
- 1: CSVDatasetの全属性（先頭200行のみ）

## 6) レビュアーチェックリスト（最小）
- [ ] AutoShardDatasetのシャーディングロジックをカーネル実装で確認
- [ ] CSVDatasetの全属性と対応するPython APIを確認
- [ ] ChooseFastestDatasetのベンチマーク選択ロジックを確認
