---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：61-RaggedTensor数学演算

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **GPU/TPUサポートの記述**：カーネル実装の確認不足

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/ragged_math_ops.cc` - RaggedRange Opの登録コード（31-39行目）
- E-02: `tensorflow/core/ops/ragged_math_ops.cc` - RaggedRangeShapeFn関数（45-79行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.61の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RaggedRangeオペレーションはstarts, limits, deltasの3入力を受け取る | E-01 (32-34行目) | ○ |
| C-02 | 出力はrt_nested_splitsとrt_dense_valuesの2テンソル | E-01 (35-36行目) | ○ |
| C-03 | サポートする型はbfloat16, float, double, int32, int64 | E-01 (37行目) | ○ |
| C-04 | Tsplitsのデフォルトはint64 | E-01 (38行目) | ○ |
| C-05 | 入力テンソルはランク0またはランク1に制限される | E-02 (50-52行目) | ○ |
| C-06 | ランク1入力同士の次元が一致する必要がある | E-02 (56-64行目) | ○ |
| C-07 | 全入力スカラーの場合、splits次元は2 | E-02 (70-72行目) | ○ |
| C-08 | rt_nested_splitsはランク1ベクトルとして出力される | E-02 (74行目) | ○ |
| C-09 | rt_dense_valuesはランク1の不明サイズとして出力される | E-02 (77行目) | ○ |
| C-10 | 本機能は機能一覧No.61に対応する | E-03 | ○ |
| C-11 | 関連画面は存在しない | 画面機能マッピング.csv確認済み | ○ |
| C-12 | GPU/TPUでの実行が可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: GPU/TPUサポートはカーネル登録の確認が必要だが、`ragged_math_ops.cc`にはOp定義のみでカーネル登録は別ファイルにある
  - 候補：`tensorflow/core/kernels/ragged_range_op.cc` / デバイスカーネル登録ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義と形状推論の記述はソースコードと完全に一致
- 1: 中リスク - GPU/TPUサポートの記述は未確認のカーネル登録に依存

## 6) レビュアーチェックリスト（最小）
- [ ] RaggedRangeの入出力定義がソースコードと一致しているか確認
- [ ] 形状推論ロジックの説明が正確か確認
- [ ] GPU/TPUサポートの可否をカーネル登録ファイルで確認
- [ ] 他のRaggedTensor数学演算（セグメント集約等）が別ファイルに存在しないか確認
