---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：62-SavedModel保存

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **アトミック性の記述**：保存がアトミックでないことの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/saved_model/save.py` - save関数のメインロジック
- E-02: `tensorflow/python/saved_model/builder_impl.py` - SavedModelBuilderクラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.62の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SavedModelはProtocol Buffer形式でシリアライズされる | E-01 (31行目 saved_model_pb2インポート) | ○ |
| C-02 | _AugmentedGraphViewがTrackableオブジェクトグラフを走査する | E-01 (100-113行目) | ○ |
| C-03 | _SaveableViewがチェックポイントsave/restore関数を生成する | E-01 (254-325行目) | ○ |
| C-04 | export_dirが空でない場合AssertionErrorが発生する | E-02 (100-105行目) | ○ |
| C-05 | アセットファイルはassets/ディレクトリにコピーされる | E-02 (117-135行目) | ○ |
| C-06 | 未トレース関数は警告ログが出力される | E-01 (288-295行目) | ○ |
| C-07 | _UNCOPIABLE_DTYPESにresourceとvariantが含まれる | E-01 (87行目) | ○ |
| C-08 | _CapturedTensorはnameとconcrete_functionのフィールドを持つ | E-01 (90-91行目) | ○ |
| C-09 | _SAVE_V2_LABELメトリクスラベルが使用される | E-01 (97行目) | ○ |
| C-10 | 画像分類画面で事前保存済みモデルが利用される | E-04 (行3) | ○ |
| C-11 | 物体検出画面でモデルファイルが読み込まれる | E-04 (行9-10) | ○ |
| C-12 | スタイル変換画面でモデルファイルが読み込まれる | E-04 (行15-16) | ○ |
| C-13 | 音声認識画面でモデルファイルが読み込まれる | E-04 (行21-22) | ○ |
| C-14 | fingerprinting_utilsを使用してフィンガープリントが生成される | E-01 (58行目 import) | ○ |
| C-15 | SavedModel保存はアトミックではない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: SavedModel保存のアトミック性に関する記述はソースコード内に明示的なドキュメントがない
  - 候補：TensorFlow公式ドキュメント / 設計RFC

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なクラス構造と処理フローはソースコードと一致
- 1: 中リスク - SavedModel保存のアトミック性に関する記述の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] _AugmentedGraphViewとlist_childrenの動作がソースコードと一致するか確認
- [ ] _SaveableViewの初期化処理フローが正確か確認
- [ ] 関連画面との対応が画面機能マッピングと一致するか確認
- [ ] SavedModel出力形式（pb/pbtxt/cpb）の記述が正確か確認
