---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：63-SavedModel読み込み

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティリスクの記述**：任意コード実行リスクの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/saved_model/load.py` - Loaderクラスと読み込みロジック
- E-02: `tensorflow/python/saved_model/loader_impl.py` - parse_saved_model関数
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.63の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | _LOAD_V2_LABELメトリクスラベルが使用される | E-01 (70行目) | ○ |
| C-02 | _BUILT_IN_REGISTRATIONSにAsset、RestoredResource、TrackableConstantが含まれる | E-01 (75-78行目) | ○ |
| C-03 | _WrapperFunctionがレプリカコンテキストで変数ハンドルを解決する | E-01 (124-146行目) | ○ |
| C-04 | Loader.__init__でFunctionDefLibraryがロードされる | E-01 (160-164行目) | ○ |
| C-05 | チェックポイントスキップオプションが存在する | E-01 (225行目) | ○ |
| C-06 | CapturableResourceの初期化が実行される | E-01 (227-231行目) | ○ |
| C-07 | parse_saved_modelがpb形式を優先して読み込む | E-02 (104-122行目) | ○ |
| C-08 | cpb形式もサポートされる | E-02 (98-100行目) | ○ |
| C-09 | node_filtersで部分的な読み込みが可能 | E-01 (233-310行目) | ○ |
| C-10 | _load_allでノード、エッジ、関数がロードされる | E-01 (318-326行目) | ○ |
| C-11 | _recreateでregistered_classまたはビルトイン型に基づきオブジェクトが再構築される | E-01 (620-674行目) | ○ |
| C-12 | function_aliasesが復元される | E-01 (173-196行目) | ○ |
| C-13 | 依存関係順でノードがソートされる | E-01 (221行目) | ○ |
| C-14 | 信頼できないソースからの読み込みは任意コード実行リスクがある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: セキュリティリスクの詳細はTensorFlowセキュリティアドバイザリを参照する必要がある
  - 候補：SECURITY.md / TensorFlow公式セキュリティドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Loaderクラスの処理フローはソースコードと一致
- 0: 低リスク - parse_saved_modelのファイル形式優先順位はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Loader.__init__の処理フローがソースコードと一致するか確認
- [ ] _WrapperFunctionの分散変数ハンドリングが正確か確認
- [ ] parse_saved_modelのファイル形式サポート（pb/pbtxt/cpb）が正確か確認
- [ ] セキュリティリスクの記述が公式ドキュメントと一致するか確認
