---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-SavedModelフィンガープリンティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/saved_model/fingerprinting.py` - Fingerprintクラス全体（1-178行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.66の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fingerprintクラスは6つの属性を持つ | E-01 (36-43行目) | ○ |
| C-02 | from_protoクラスメソッドでprotobufからFingerprintを構築できる | E-01 (71-87行目) | ○ |
| C-03 | bytes入力もfrom_protoで受け付ける | E-01 (74-75行目) | ○ |
| C-04 | __eq__は5フィールドで比較する | E-01 (89-101行目) | ○ |
| C-05 | FingerprintDefとも比較可能 | E-01 (90-91行目) | ○ |
| C-06 | singleprintは4つのハッシュを連結する | E-01 (137-140行目) | ○ |
| C-07 | read_fingerprintはexport_dirからfingerprint.pbを読み取る | E-01 (151-178行目) | ○ |
| C-08 | FileNotFoundErrorがfingerprint.pb不在時に発生する | E-01 (173-174行目) | ○ |
| C-09 | RuntimeErrorがパース失敗時に発生する | E-01 (175-176行目) | ○ |
| C-10 | C++側のReadSavedModelFingerprintが使用される | E-01 (172行目) | ○ |
| C-11 | APIはtf.saved_model.experimentalとして公開される | E-01 (28行目, 151行目) | ○ |
| C-12 | 関連画面は存在しない | 画面機能マッピング.csv確認済み | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠あり。不足情報なし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードと直接対応。fingerprinting.pyは小規模ファイルで全体を読み込み済み。

## 6) レビュアーチェックリスト（最小）
- [ ] fingerprint.protoの定義がFingerprintクラスの属性と一致するか確認
- [ ] C++側のフィンガープリント生成ロジックを確認
- [ ] fingerprinting_utils.pyとの連携を確認
