---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：80-TFLiteモデル変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **量子化パフォーマンス数値**：公称値であり実測ではない
  2. **TFLiteConverterクラスの全メソッド**：lite.pyの全体は冒頭のみ確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/lite/python/lite.py` - TFLiteConverter実装（冒頭120行）
- E-02: `tensorflow/lite/python/convert.py` - 変換ロジック（冒頭100行）
- E-03: `tensorflow/lite/python/` ディレクトリ構成
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Optimize列挙型（DEFAULT, OPTIMIZE_FOR_SIZE等） | E-01 (112-120行目) | ○ |
| C-02 | OpsSet（TFLITE_BUILTINS, SELECT_TF_OPS） | E-02 (convert.pyインポート) | ○ |
| C-03 | 型マッピングテーブル（float32→FLOAT等） | E-02 (79-95行目) | ○ |
| C-04 | _is_quantized_input_stats_required関数 | E-02 (42-61行目) | ○ |
| C-05 | convert_tensor_tf_type_to_tflite_type関数 | E-02 (64-100行目) | ○ |
| C-06 | wrap_converterによるMLIR C++変換器呼び出し | E-02 (27行目インポート) | ○ |
| C-07 | converter_flags_pb2, model_flags_pb2, types_pb2の使用 | E-02 (23-25行目) | ○ |
| C-08 | from_saved_model, from_keras_model, from_concrete_functionsメソッド | E-01 (インポート群から推定) | ○ |
| C-09 | _mlir_quantize, _mlir_sparsify関数 | E-01 (48-49行目インポート) | ○ |
| C-10 | deduplicate_readonly_buffers関数 | E-01 (47行目インポート) | ○ |
| C-11 | modify_model_io_type関数 | E-01 (78行目インポート) | ○ |
| C-12 | calibrator使用による量子化キャリブレーション | E-01 (63行目インポート) | ○ |
| C-13 | flatbuffer_utils使用 | E-01 (83行目インポート) | ○ |
| C-14 | conversion_metadata_schema_py_generated使用 | E-01 (39行目インポート) | ○ |
| C-15 | INT8量子化で最大4倍高速化・サイズ1/4 | **根拠なし** | △ |
| C-16 | TFLiteConverterの全変換フロー詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 量子化パフォーマンス数値の実測データ
  - 候補：TFLite公式ドキュメント / ベンチマーク結果
- TFLiteConverterのconvert()メソッド内部フロー詳細
  - 候補：lite.pyの全文精読

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - パフォーマンス数値は公称値のため要検証
- 0: 低リスク - API構造はインポート群から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Optimize列挙型の全値が正確か
- [ ] 型マッピングテーブルが完全か
- [ ] 量子化モードの分類が正確か
- [ ] 変換フローの順序が正確か
