---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：82-TFLiteデリゲート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **GPUデリゲートの高速化倍率**：定量的根拠なし
  2. **NNAPIの対応Android バージョン**：ソースコードからは直接確認困難
  3. **CoreMLデリゲートの詳細**：ヘッダファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/lite/delegates/gpu/delegate.h` - GPUデリゲートAPI定義
- E-02: `tensorflow/lite/core/c/common.h` - TfLiteDelegate構造体
- E-03: `tensorflow/lite/core/acceleration/configuration/delegate_registry.h` - デリゲートレジストリ
- E-04: `tensorflow/lite/core/acceleration/configuration/c/delegate_plugin.h` - プラグインAPI
- E-05: `tensorflow/lite/core/acceleration/configuration/c/gpu_plugin.h` - GPUプラグイン
- E-06: `tensorflow/lite/core/acceleration/configuration/c/nnapi_plugin.h` - NNAPIプラグイン
- E-07: `tensorflow/lite/core/acceleration/configuration/c/xnnpack_plugin.h` - XNNPACKプラグイン
- E-08: `tensorflow/lite/core/acceleration/configuration/c/stable_delegate.h` - Stable Delegate
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TfLiteGpuDelegateV2Createでデリゲート生成 | E-01 | ○ |
| C-02 | TfLiteGpuDelegateV2DeleteでGPUデリゲート破棄 | E-01 | ○ |
| C-03 | tflite_plugin_create_delegateプラグインIF | E-01 | ○ |
| C-04 | TfLiteGpuDelegateV2CreateAsyncはAndroid専用 | E-01 | ○ |
| C-05 | デリゲートレジストリによる動的ロード | E-03 | ○ |
| C-06 | Stable Delegate APIによるバイナリ互換 | E-08 | ○ |
| C-07 | GPUプラグインの存在 | E-05 | ○ |
| C-08 | NNAPIプラグインの存在 | E-06 | ○ |
| C-09 | XNNPACKプラグインの存在 | E-07 | ○ |
| C-10 | TFLiteカメラプレビューでのデリゲート使用 | E-09 | ○ |
| C-11 | ベンチマーク画面でのデリゲート使用 | E-09 | ○ |
| C-12 | デリゲートフォールバック機構 | E-02 | ○ |
| C-13 | ModifyGraphWithDelegateによる適用 | E-02 | ○ |
| C-14 | ノードパーティショニング | E-02 | ○ |
| C-15 | デリゲートのPrepareコールバック | E-02 | ○ |
| C-16 | GPU比2〜5倍の高速化 | **根拠なし** | △ |
| C-17 | NNAPIはAndroid 8.1以上が必要 | **根拠なし** | △ |
| C-18 | CoreMLデリゲートの存在 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GPUデリゲートの性能数値はベンチマーク結果に依存
  - 候補：TFLite公式パフォーマンスガイド / ベンチマーク結果
- NNAPIの対応バージョン情報はAndroid SDK文書に依存
  - 候補：Android NDK ドキュメント / NNAPI仕様書
- CoreMLデリゲートのヘッダファイルは別ディレクトリにある可能性
  - 候補：`tensorflow/lite/delegates/coreml/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デリゲートAPIの構造は正確
- 1: 中リスク - パフォーマンス数値の検証が必要
- 1: 中リスク - CoreMLデリゲートの詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GPUデリゲートのオプション構造体が正確に記述されているか
- [ ] デリゲートパーティショニングの動作が正確か
- [ ] パフォーマンス要件の数値を実環境で検証
- [ ] CoreMLデリゲートの記述を追加確認
