---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：95-確率的キャスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **確率的丸めアルゴリズムの詳細**：カーネル実装未確認
  2. **期待値保存性の証明**：数学的根拠の確認推奨
  3. **TODOの実装状況**：b/232442915の進捗確認

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/ops/stochastic_cast_op.cc` - Op定義ファイル全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 95行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StochasticCastToInt Opが登録されている | E-01 (27-46行目) | ○ |
| C-02 | 入力型: half, bfloat16, float32, float64 | E-01 (33行目) | ○ |
| C-03 | 出力型: int8, int16, int32 | E-01 (34行目) | ○ |
| C-04 | keyはrank 1 | E-01 (38行目) | ○ |
| C-05 | counterはrank 1 | E-01 (39行目) | ○ |
| C-06 | algはスカラー | E-01 (40行目) | ○ |
| C-07 | keyサイズはRNG_KEY_SIZEと一致 | E-01 (42-43行目) | ○ |
| C-08 | 出力形状は入力形状と同一 | E-01 (44行目) | ○ |
| C-09 | 浮動小数点→低精度浮動小数点のTODOあり | E-01 (48行目) | ○ |
| C-10 | rng_alg.hを参照 | E-01 (16行目) | ○ |
| C-11 | Philox RNGを使用 | E-01 (16行目, rng_alg.hインクルード) | ○ |
| C-12 | 確率的丸めの期待値はE[output]=x | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: 確率的丸めの期待値保存性は確率論の一般的な性質であるが、カーネル実装での正確なアルゴリズムは未確認
  - 候補：カーネル実装コード / Stochastic Roundingの学術論文

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Op定義に直接基づく記述が大半

## 6) レビュアーチェックリスト（最小）
- [ ] カーネル実装の確率的丸めアルゴリズムを確認
- [ ] RNG_KEY_SIZEの実際の値を確認
- [ ] TODO(b/232442915)の実装状況を確認
