---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：98-プロファイラAPI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **C++バインディングの詳細**：_pywrap_profiler内部の確認推奨
  2. **CUPTI連携の詳細**：GPU側の実装確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/profiler/profiler_v2.py` - メインソースファイル全体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 98行目 - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProfilerOptionsはnamedtupleで4フィールド | E-01 (46-50行目) | ○ |
| C-02 | host_tracer_levelデフォルトは2 | E-01 (71行目) | ○ |
| C-03 | python_tracer_levelデフォルトは0 | E-01 (72行目) | ○ |
| C-04 | device_tracer_levelデフォルトは1 | E-01 (73行目) | ○ |
| C-05 | delay_msデフォルトはNone | E-01 (74行目) | ○ |
| C-06 | start()は_profiler_lockで排他制御 | E-01 (108行目) | ○ |
| C-07 | 既存セッション時にAlreadyExistsError | E-01 (110-111行目) | ○ |
| C-08 | ProfilerSession()で新規セッション作成 | E-01 (112行目) | ○ |
| C-09 | optionsはdict変換されて渡される | E-01 (116行目) | ○ |
| C-10 | stop()でセッション不在時UnavailableError | E-01 (144-146行目) | ○ |
| C-11 | save=Trueの場合export_to_tb()呼び出し | E-01 (148-149行目) | ○ |
| C-12 | warmup()はstart('')+stop(save=False) | E-01 (164-165行目) | ○ |
| C-13 | start_server()は_pywrap_profiler.start_server(port) | E-01 (180行目) | ○ |
| C-14 | Profile classは__enter__でstart、__exit__でstop | E-01 (208-212行目) | ○ |
| C-15 | 同時に1つのプロファイラセッションのみ | E-01 (25-26行目, docstring) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードに直接基づく

## 6) レビュアーチェックリスト（最小）
- [ ] _pywrap_profiler C++バインディングの動作確認
- [ ] CUPTI連携の初期化プロセスを確認
- [ ] TensorBoard Profileプラグインとの互換性を確認
