---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/tools/android/test/AndroidManifest.xml` -- TF DemoアプリのActivity定義
- E-02: `tensorflow/tools/android/test/src/org/tensorflow/demo/ClassifierActivity.java` -- 画像分類Activity
- E-03: `tensorflow/tools/android/test/src/org/tensorflow/demo/DetectorActivity.java` -- 物体検出Activity
- E-04: `tensorflow/tools/android/test/src/org/tensorflow/demo/StylizeActivity.java` -- スタイル変換Activity
- E-05: `tensorflow/tools/android/test/src/org/tensorflow/demo/SpeechActivity.java` -- 音声認識Activity
- E-06: `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraActivity.java` -- 抽象カメラActivity
- E-07: `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraConnectionFragment.java` -- Camera2フラグメント
- E-08: `tensorflow/tools/android/test/src/org/tensorflow/demo/LegacyCameraConnectionFragment.java` -- レガシーカメラフラグメント
- E-09: `tensorflow/lite/java/demo/app/src/main/AndroidManifest.xml` -- TFLite DemoアプリのActivity定義
- E-10: `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/CameraActivity.java` -- TFLiteカメラActivity
- E-11: `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/Camera2BasicFragment.java` -- TFLiteカメラフラグメント
- E-12: `tensorflow/lite/java/ovic/demo/app/AndroidManifest.xml` -- OVICアプリのActivity定義
- E-13: `tensorflow/lite/java/ovic/demo/app/OvicBenchmarkerActivity.java` -- OVICベンチマークActivity
- E-14: `tensorflow/lite/tools/benchmark/android/AndroidManifest.xml` -- Benchmarkツール Manifest
- E-15: `tensorflow/lite/tools/benchmark/android/src/org/tensorflow/lite/benchmark/BenchmarkModelActivity.java` -- ベンチマークActivity
- E-16: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/AndroidManifest.xml` -- デリゲート性能 Manifest
- E-17: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkLatencyActivity.java` -- レイテンシActivity
- E-18: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyActivity.java` -- 精度Activity
- E-19: `tensorflow/lite/tools/benchmark/experimental/firebase/android/AndroidManifest.xml` -- Firebase Manifest
- E-20: `tensorflow/lite/tools/benchmark/experimental/firebase/android/src/org/tensorflow/lite/benchmark/firebase/BenchmarkModelActivity.java` -- FirebaseベンチマークActivity
- E-21: `tensorflow/tools/android/test/res/layout/activity_camera.xml` -- カメラレイアウト
- E-22: `tensorflow/tools/android/test/res/layout/activity_speech.xml` -- 音声認識レイアウト
- E-23: `tensorflow/tools/android/test/res/layout/camera_connection_fragment.xml` -- カメラフラグメントレイアウト
- E-24: `tensorflow/tools/android/test/res/layout/camera_connection_fragment_tracking.xml` -- トラッキングフラグメントレイアウト
- E-25: `tensorflow/tools/android/test/res/layout/camera_connection_fragment_stylize.xml` -- スタイル変換フラグメントレイアウト
- E-26: `tensorflow/lite/java/demo/app/src/main/res/layout/activity_camera.xml` -- TFLiteカメラレイアウト
- E-27: `tensorflow/lite/java/demo/app/src/main/res/layout/fragment_camera2_basic.xml` -- TFLiteフラグメントレイアウト
- E-28: `tensorflow/lite/java/ovic/demo/app/res/layout/activity_main.xml` -- OVICレイアウト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClassifierActivityは画像分類を行うランチャーActivity | E-01, E-02 | ○ |
| C-02 | DetectorActivityは物体検出・追跡を行うランチャーActivity | E-01, E-03 | ○ |
| C-03 | StylizeActivityはスタイル変換を行うランチャーActivity | E-01, E-04 | ○ |
| C-04 | SpeechActivityは音声認識を行うランチャーActivity | E-01, E-05 | ○ |
| C-05 | CameraActivityはカメラプレビューの抽象基底クラス | E-06 | ○ |
| C-06 | CameraConnectionFragmentはCamera2 APIを使用するFragment | E-07, E-23 | ○ |
| C-07 | LegacyCameraConnectionFragmentは旧Camera APIを使用するFragment | E-08 | ○ |
| C-08 | TFLite CameraActivityはCamera2BasicFragmentを配置するランチャーActivity | E-09, E-10 | ○ |
| C-09 | Camera2BasicFragmentはTFLiteモデルで画像分類を行うFragment | E-11, E-27 | ○ |
| C-10 | OvicBenchmarkerActivityはOVICベンチマークを実行する画面 | E-12, E-13 | ○ |
| C-11 | BenchmarkModelActivityはUIなしでベンチマーク実行後に終了するActivity | E-14, E-15 | ○ |
| C-12 | BenchmarkLatencyActivityはデリゲートのレイテンシベンチマークを実行 | E-16, E-17 | ○ |
| C-13 | BenchmarkAccuracyActivityはデリゲートの精度ベンチマークを実行 | E-16, E-18 | ○ |
| C-14 | Firebase BenchmarkModelActivityはGame Loop Intent経由で起動 | E-19, E-20 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠が存在するため、不足情報はありません。
- ただし、TensorFlowプロジェクトは主にライブラリであり、画面を持つのはAndroidデモ・ベンチマークアプリのみです。Webフロントエンド（TensorBoard等）は本リポジトリには含まれていません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全画面がJavaソースコードとAndroidManifest.xmlから直接確認可能
- 0: 低リスク -- 画面遷移はAndroidManifest.xmlのintent-filterとソースコード上のFragment配置から特定
- 1: 中リスク -- TensorFlowプロジェクト全体の中でAndroidアプリ部分のみを対象としているため、別リポジトリに存在する可能性のあるUI（例：TensorBoard）は範囲外

## 6) レビュアーチェックリスト（最小）
- [ ] 各Activityの画面名・説明がソースコードのJavadocやコメントと一致しているか
- [ ] AndroidManifest.xmlに記載されたすべてのActivityが画面一覧に含まれているか
- [ ] 画面遷移図の継承関係（CameraActivity -> 各サブクラス）が正しいか
- [ ] Fragment配置の関係（CameraActivity -> CameraConnectionFragment等）が正しいか
- [ ] TensorBoard等の別リポジトリで管理されるUI画面が対象外であることが妥当か
