# 画面遷移図

## 概要

TensorFlowプロジェクトには、4つの独立したAndroidアプリケーションが含まれており、それぞれ独自の画面遷移を持ちます。

---

## 1. TF Demo アプリ（tensorflow/tools/android/test）

各Activity（ClassifierActivity, DetectorActivity, StylizeActivity, SpeechActivity）はそれぞれランチャーActivityとして登録されており、ホーム画面から個別に起動されます。CameraActivity（抽象クラス）を継承するActivityはCameraConnectionFragmentまたはLegacyCameraConnectionFragmentをカメラプレビュー表示に使用します。

```mermaid
graph TD
    subgraph "TF Demo アプリ"
        LAUNCHER_TF["Android ランチャー"]
        CA_ABS["CameraActivity<br/>（抽象基底クラス）"]

        CLASSIFIER["ClassifierActivity<br/>画像分類画面"]
        DETECTOR["DetectorActivity<br/>物体検出画面"]
        STYLIZE["StylizeActivity<br/>スタイル変換画面"]
        SPEECH["SpeechActivity<br/>音声認識画面"]

        CAM_FRAG["CameraConnectionFragment<br/>Camera2 API"]
        LEGACY_FRAG["LegacyCameraConnectionFragment<br/>旧Camera API"]

        LAUNCHER_TF -->|"起動"| CLASSIFIER
        LAUNCHER_TF -->|"起動"| DETECTOR
        LAUNCHER_TF -->|"起動"| STYLIZE
        LAUNCHER_TF -->|"起動"| SPEECH

        CA_ABS -.->|"継承"| CLASSIFIER
        CA_ABS -.->|"継承"| DETECTOR
        CA_ABS -.->|"継承"| STYLIZE

        CLASSIFIER -->|"Camera2対応"| CAM_FRAG
        CLASSIFIER -->|"Camera2非対応"| LEGACY_FRAG
        DETECTOR -->|"Camera2対応"| CAM_FRAG
        DETECTOR -->|"Camera2非対応"| LEGACY_FRAG
        STYLIZE -->|"Camera2対応"| CAM_FRAG
        STYLIZE -->|"Camera2非対応"| LEGACY_FRAG
    end
```

## 2. TFLite Demo アプリ（tensorflow/lite/java/demo）

CameraActivityがランチャーとして起動し、Camera2BasicFragmentをコンテナに配置します。

```mermaid
graph TD
    subgraph "TFLite Demo アプリ"
        LAUNCHER_TFLITE["Android ランチャー"]
        TFLITE_CAMERA["CameraActivity<br/>TFLiteカメラ画面"]
        TFLITE_FRAG["Camera2BasicFragment<br/>カメラプレビュー + 分類結果"]

        LAUNCHER_TFLITE -->|"起動"| TFLITE_CAMERA
        TFLITE_CAMERA -->|"Fragment配置"| TFLITE_FRAG
    end
```

## 3. OVIC Benchmark アプリ（tensorflow/lite/java/ovic/demo）

OvicBenchmarkerActivityが単一画面として起動し、ベンチマーク結果を表示します。

```mermaid
graph TD
    subgraph "OVIC Benchmark アプリ"
        LAUNCHER_OVIC["Android ランチャー"]
        OVIC["OvicBenchmarkerActivity<br/>ベンチマーク画面"]

        LAUNCHER_OVIC -->|"起動"| OVIC
    end
```

## 4. TFLite Benchmark ツール群（tensorflow/lite/tools/benchmark）

各ActivityはIntent経由で外部から起動され、UIを持たず処理完了後に自動終了します。

```mermaid
graph TD
    subgraph "TFLite Benchmark ツール"
        INTENT_BM["外部Intent / adb"]
        INTENT_FB["Firebase Game Loop Intent"]

        BM_MODEL["BenchmarkModelActivity<br/>モデルベンチマーク"]
        BM_LATENCY["BenchmarkLatencyActivity<br/>レイテンシベンチマーク"]
        BM_ACCURACY["BenchmarkAccuracyActivity<br/>精度ベンチマーク"]
        BM_FIREBASE["BenchmarkModelActivity<br/>（Firebase版）"]

        INTENT_BM -->|"args指定"| BM_MODEL
        INTENT_BM -->|"tflite_settings_files指定"| BM_LATENCY
        INTENT_BM -->|"tflite_settings_files指定"| BM_ACCURACY
        INTENT_FB -->|"TEST_LOOP"| BM_FIREBASE

        BM_MODEL -->|"finish()"| END_BM["終了"]
        BM_LATENCY -->|"finish()"| END_BM
        BM_ACCURACY -->|"finish()"| END_BM
        BM_FIREBASE -->|"finish()"| END_BM
    end
```
