---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 38
  claims_with_evidence: 33
  claims_without_evidence: 5
confidence_derived: 0.87
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：33 / 38、根拠なし：5
- 優先レビュー（高）
  1. **画像分類画面とSavedModel保存の関連**：.pbファイル読み込みがSavedModel保存機能に該当するかは解釈に依存
  2. **音声認識画面とSoftmax活性化関数の関連**：モデル内部のノード名から推測しているため根拠が間接的
  3. **Firebase Game Loopベンチマーク画面とTFLiteデリゲートの関連**：コード上にデリゲート設定の直接的記述がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/tools/android/test/src/org/tensorflow/demo/ClassifierActivity.java` - TensorFlowImageClassifier生成、MODEL_FILE定数、processImage()メソッド
- E-02: `tensorflow/tools/android/test/src/org/tensorflow/demo/DetectorActivity.java` - TF OD API / MultiBox / YOLO検出器生成、tracker利用
- E-03: `tensorflow/tools/android/test/src/org/tensorflow/demo/StylizeActivity.java` - TensorFlowInferenceInterface利用、stylizeImage()メソッド、GridViewスタイル選択UI
- E-04: `tensorflow/tools/android/test/src/org/tensorflow/demo/SpeechActivity.java` - AudioRecord利用、TensorFlowInferenceInterface利用、RecognizeCommands利用
- E-05: `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraActivity.java` - Camera2/Legacy切替、setFragment()、processImage()抽象メソッド
- E-06: `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraConnectionFragment.java` - Camera2 API利用、ImageReader YUV_420_888
- E-07: `tensorflow/tools/android/test/src/org/tensorflow/demo/LegacyCameraConnectionFragment.java` - 旧Camera API利用
- E-08: `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/CameraActivity.java` - Camera2BasicFragment生成
- E-09: `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/Camera2BasicFragment.java` - ImageClassifier利用、GPU/NNAPI切替、periodicClassify
- E-10: `tensorflow/lite/java/ovic/demo/app/OvicBenchmarkerActivity.java` - OvicClassifierBenchmarker/OvicDetectorBenchmarker利用
- E-11: `tensorflow/lite/tools/benchmark/android/src/org/tensorflow/lite/benchmark/BenchmarkModelActivity.java` - BenchmarkModel.run()、hexagonデリゲート設定
- E-12: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkLatencyActivity.java` - BenchmarkLatencyImpl利用
- E-13: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyActivity.java` - BenchmarkAccuracyImpl利用
- E-14: `tensorflow/lite/tools/benchmark/experimental/firebase/android/src/org/tensorflow/lite/benchmark/firebase/BenchmarkModelActivity.java` - Firebase Game Loop Intent処理、BenchmarkModel.run()
- E-15: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No・画面名の一覧定義
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No・機能名の一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画像分類画面がImage Operationsで画像前処理を実行 | E-01 (ImageUtils.getTransformationMatrix, frameToCropTransform) | ○ |
| C-02 | 画像分類画面がTFLite推論エンジンでInceptionモデル推論を実行 | E-01 (TensorFlowImageClassifier.create, classifier.recognizeImage) | ○ |
| C-03 | 画像分類画面がSavedModel保存機能でモデルを読み込み | E-01 (MODEL_FILE = tensorflow_inception_graph.pb) | △ |
| C-04 | 画像分類画面がCameraActivityを継承 | E-01 (extends CameraActivity) | ○ |
| C-05 | 画像分類画面がCameraConnectionFragmentを利用 | E-01 (getLayoutId = camera_connection_fragment), E-05 | ○ |
| C-06 | 画像分類画面がLegacyCameraConnectionFragmentを利用 | E-05 (setFragment内のフォールバック処理) | ○ |
| C-07 | 物体検出画面がImage Operationsで画像前処理を実行 | E-02 (ImageUtils.getTransformationMatrix) | ○ |
| C-08 | 物体検出画面がTFLite推論エンジンで物体検出推論を実行 | E-02 (TF OD API / MultiBox / YOLO検出器) | ○ |
| C-09 | 物体検出画面がSavedModel保存機能でモデルを読み込み | E-02 (MODEL_FILE定数群) | △ |
| C-10 | 物体検出画面がCameraActivityを継承 | E-02 (extends CameraActivity) | ○ |
| C-11 | 物体検出画面がCameraConnectionFragmentを利用 | E-02 (getLayoutId = camera_connection_fragment_tracking), E-05 | ○ |
| C-12 | 物体検出画面がLegacyCameraConnectionFragmentを利用 | E-05 (setFragment内のフォールバック処理) | ○ |
| C-13 | スタイル変換画面がImage Operationsで画像前処理を実行 | E-03 (ImageUtils.getTransformationMatrix) | ○ |
| C-14 | スタイル変換画面がTFLite推論エンジンでスタイル変換推論を実行 | E-03 (inferenceInterface.run, stylizeImage) | ○ |
| C-15 | スタイル変換画面がSavedModel保存機能でモデルを読み込み | E-03 (MODEL_FILE = stylize_quantized.pb) | △ |
| C-16 | スタイル変換画面がCameraActivityを継承 | E-03 (extends CameraActivity) | ○ |
| C-17 | スタイル変換画面がCameraConnectionFragmentを利用 | E-03 (getLayoutId = camera_connection_fragment_stylize), E-05 | ○ |
| C-18 | スタイル変換画面がLegacyCameraConnectionFragmentを利用 | E-05 (setFragment内のフォールバック処理) | ○ |
| C-19 | 音声認識画面がAudio Operationsで音声入力を取得 | E-04 (AudioRecord利用、SAMPLE_RATE = 16000) | ○ |
| C-20 | 音声認識画面がTFLite推論エンジンで音声コマンド認識を実行 | E-04 (inferenceInterface.run, inferenceInterface.fetch) | ○ |
| C-21 | 音声認識画面がSavedModel保存機能でモデルを読み込み | E-04 (MODEL_FILENAME = conv_actions_frozen.pb) | △ |
| C-22 | 音声認識画面がSoftmax活性化関数を利用 | E-04 (OUTPUT_SCORES_NAME = "labels_softmax") | △ |
| C-23 | カメラベース画面がImage Operationsで色空間変換を提供 | E-05 (ImageUtils.convertYUV420ToARGB8888, convertYUV420SPToARGB8888) | ○ |
| C-24 | カメラベース画面がCameraConnectionFragmentを生成 | E-05 (CameraConnectionFragment.newInstance in setFragment) | ○ |
| C-25 | カメラベース画面がLegacyCameraConnectionFragmentを生成 | E-05 (new LegacyCameraConnectionFragment in setFragment) | ○ |
| C-26 | カメラ接続フラグメントがImage OperationsでYUVフレームを取得 | E-06 (ImageReader YUV_420_888形式) | ○ |
| C-27 | レガシーカメラ接続フラグメントが旧Camera APIでフレームを取得 | E-07 (Camera.open, setPreviewCallbackWithBuffer) | ○ |
| C-28 | TFLiteカメラ画面がCamera2BasicFragmentを生成 | E-08 (Camera2BasicFragment.newInstance in onCreate) | ○ |
| C-29 | TFLiteカメラプレビューフラグメントがTFLiteモデル変換機能でモデルを読み込み | E-09 (ImageClassifierQuantizedMobileNet, ImageClassifierFloatMobileNet) | ○ |
| C-30 | TFLiteカメラプレビューフラグメントがTFLite推論エンジンで分類を実行 | E-09 (classifier.classifyFrame, periodicClassify) | ○ |
| C-31 | TFLiteカメラプレビューフラグメントがTFLiteデリゲートを利用 | E-09 (classifier.useGpu(), classifier.useNNAPI()) | ○ |
| C-32 | TFLiteカメラプレビューフラグメントがImage Operationsでカメラ画像を変換 | E-09 (textureView.getBitmap) | ○ |
| C-33 | OVICベンチマーク画面がTFLite推論エンジンでベンチマークを実行 | E-10 (OvicClassifierBenchmarker, OvicDetectorBenchmarker, processBitmap) | ○ |
| C-34 | OVICベンチマーク画面がTFLiteモデル変換機能でモデルを読み込み | E-10 (quantized_model.lite, detect.lite) | ○ |
| C-35 | TFLiteベンチマーク実行画面がTFLite推論エンジンでベンチマークを実行 | E-11 (BenchmarkModel.run(args)) | ○ |
| C-36 | TFLiteベンチマーク実行画面がTFLiteデリゲートを利用 | E-11 (--use_hexagon, hexagon_lib_path) | ○ |
| C-37 | デリゲート性能ベンチマーク（レイテンシ/精度）画面がTFLite推論エンジンとデリゲートを利用 | E-12, E-13 (BenchmarkLatencyImpl, BenchmarkAccuracyImpl, tfliteSettingsJsonFiles) | ○ |
| C-38 | Firebase Game Loopベンチマーク画面がTFLiteデリゲートを利用 | E-14 (BenchmarkModel.run) | △ |

## 4) 不足情報（Unknown / Missing）
- .pbファイル（Protocol Bufferグラフ）の読み込みを「SavedModel保存」機能（No.62）にマッピングしているが、厳密にはSavedModel形式とFrozen Graph形式は異なる。機能一覧にFrozen Graph読み込み専用の項目が存在しないため、最も近い機能としてマッピングした。
  - 候補：SavedModel読み込み（No.63） / Protocol Bufferエンコード/デコード（No.114） / 新規「Frozen Graphモデル読み込み」機能の追加
- SpeechActivityのlabels_softmaxノード名から「活性化関数（Activation Functions）」へのマッピングは、モデル内部のレイヤー名からの推測であり、画面UIから直接呼び出されるものではない。
  - 候補：マッピングから除外 / 備考欄で補足 / モデルアーキテクチャ設計書で管理
- Firebase Game Loopベンチマーク画面のTFLiteデリゲート関連は、BenchmarkModel内部の実装に依存しており、Activity自体のコードにはデリゲート設定の記述がない。
  - 候補：BenchmarkModelのネイティブコード解析 / マッピングから除外

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - .pbファイル読み込みとSavedModel保存機能のマッピングの妥当性。機能一覧にFrozen Graph専用項目がないため代替マッピングとしているが、レビュアーの判断が必要。
- 0: 低リスク - TF Demoアプリの画面（No.1-7）は継承関係とソースコードから明確にマッピング可能。
- 0: 低リスク - TFLiteアプリの画面（No.8-14）はコード内のクラス参照から明確にマッピング可能。
- 1: 中リスク - ベンチマーク系画面（No.11-14）はUIを持たないため、「画面」としてのマッピングの粒度が適切かレビューが必要。

## 6) レビュアーチェックリスト（最小）
- [ ] .pbファイル読み込みをSavedModel保存（No.62）にマッピングしている箇所の妥当性を確認
- [ ] 音声認識画面のSoftmax活性化関数マッピング（C-22）が画面機能マッピングとして適切か確認
- [ ] ベンチマーク系画面（No.11-14）のデリゲート関連マッピングがコード実装と整合しているか確認
- [ ] 画面一覧の全14画面が漏れなくマッピングされているか確認
- [ ] 機能一覧の機能Noと機能名が正確に参照されているか確認
