# 画面設計書 13-デリゲート性能ベンチマーク（精度）画面

## 概要

本ドキュメントは、TFLite Benchmarkツールアプリにおける「デリゲート性能ベンチマーク（精度）画面」（BenchmarkAccuracyActivity）の画面設計書である。本画面はIntent経由でTFLite設定ファイルを受け取り、MiniBenchmarkベースの精度ベンチマークを実行するUIなしのActivityである。

### 本画面の処理概要

**業務上の目的・背景**：TensorFlow Liteのデリゲート（GPU、NNAPI、Hexagonなど）の推論精度性能を比較・評価するためのベンチマークツールである。デリゲート開発者やモデル最適化エンジニアが、異なるアクセラレーション設定における精度の差異を定量的に計測し、PASS/PASS_WITH_WARNING/FAILの判定結果を得ることを目的とする。TFLite MiniBenchmarkベースの精度測定を実行し、CSV・JSON・HTMLの3形式でレポートを出力する。

**画面へのアクセス方法**：本Activityは`android:noHistory="true"`が設定されたUIなしのActivityであり、adbコマンドまたは外部アプリケーションからIntent経由で起動する。`--tflite_settings_files`キーでTFLiteSettings JSONファイルパスの配列を渡す。

**主要な操作・処理内容**：
1. Intent Bundleから`--tflite_settings_files`キーでTFLiteSettings JSONファイルパス配列を取得する
2. BenchmarkAccuracyImplインスタンスを生成し、benchmark()メソッドを呼び出す
3. 内部でinitialize()により結果フォルダ作成とJSON/CSV/HTMLライターのセットアップを行う
4. assetsフォルダ内の`accuracy/`ディレクトリから.tfliteモデルファイルを列挙する
5. 各モデル・各デリゲート設定についてMiniBenchmarkベースの精度ベンチマークを実行する
6. 結果をCSV・JSON・HTMLの3形式で`delegate_performance_result/accuracy/`に出力する
7. Activity.finish()で自動終了する

**画面遷移**：外部Intent（adbまたはアプリ）から起動され、ベンチマーク完了後にfinish()で自動終了する。他の画面への遷移は存在しない。

**権限による表示制御**：UIが存在しないため表示制御はない。`READ_EXTERNAL_STORAGE`と`WRITE_EXTERNAL_STORAGE`権限がモデルファイル読み込みと結果出力に必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | TFLite推論エンジン | 主機能 | BenchmarkAccuracyImplを通じてMiniBenchmarkベースの精度ベンチマークを実行 |
| 82 | TFLiteデリゲート | 主機能 | TFLite設定ファイル経由で各種デリゲートの精度性能を計測・比較 |

## 画面種別

UIなし（バックグラウンド処理）。noHistory指定。

## URL/ルーティング

- パッケージ名: `org.tensorflow.lite.benchmark.delegateperformance`
- Activity名: `.BenchmarkAccuracyActivity`
- Intent起動: `adb shell am start -n org.tensorflow.lite.benchmark.delegateperformance/.BenchmarkAccuracyActivity --esa --tflite_settings_files "/path/to/settings1.json,/path/to/settings2.json"`

## 入出力項目

| 項目名 | 型 | I/O | 必須 | 説明 |
|--------|-----|-----|------|------|
| --tflite_settings_files | String[] (Bundle Extra) | 入力 | はい | TFLiteSettings JSONファイルパスの配列。デリゲート設定を定義する |
| report.csv | ファイル | 出力 | - | delegate_performance_result/accuracy/にCSV形式のパフォーマンスレポートを出力 |
| report.json | ファイル | 出力 | - | delegate_performance_result/accuracy/に詳細パフォーマンス結果をJSON形式で出力 |
| report.html | ファイル | 出力 | - | delegate_performance_result/accuracy/にHTML形式のパフォーマンスレポートを出力 |
| ログ出力 | Logcat | 出力 | - | TAG `TfLiteBenchmarkAccuracy` / `TfLiteAccuracyImpl` でベンチマーク進行と結果をログ出力 |

## 表示項目

UIなしのため表示項目は存在しない。ベンチマーク結果はファイルおよびLogcatに出力される。

## イベント仕様

### 1-Activity起動（onCreate）

1. `getIntent().getExtras()`でBundleを取得する
2. Bundleから`--tflite_settings_files`キーでString配列を取得する
3. `new BenchmarkAccuracyImpl().benchmark(this, tfliteSettingsJsonFiles)`を呼び出す
4. BenchmarkAccuracyImpl.benchmark()内部：
   a. benchmarkInternal()を呼び出す
   b. initialize()で入力引数のバリデーションと結果フォルダ作成を行う
      - tfliteSettingsJsonFilesのnull/空チェック
      - `delegate_performance_result/accuracy/`に結果フォルダを作成
      - JsonWriter、CsvWriter、HtmlWriterをBenchmarkReportに追加
   c. benchmarkDelegatesAndExportReport()でベンチマーク実行
      - TFLiteSettings JSONファイルをロードし、TfLiteSettingsListEntryリストを構築
      - assetsの`accuracy/`フォルダ内の各.tfliteモデルに対して：
        - モデル名抽出とモデル別結果フォルダ作成
        - 各デリゲート設定でDelegatePerformanceBenchmark.runAccuracyBenchmark()を実行
        - AccuracyBenchmarkReport.parseResults()で結果を解析
        - AccuracyBenchmarkReport.create()でモデル別レポートを生成
      - report.export()で集約結果をCSV・JSON・HTMLにエクスポート
   d. activity.finish()でActivityを終了

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベース操作を行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース操作なし |

## メッセージ仕様

| メッセージID | レベル | メッセージ内容 | 出力条件 |
|-------------|--------|--------------|---------|
| M-01 | INFO | "Create benchmark accuracy activity." | Activity起動時 |
| M-02 | INFO | "Running accuracy benchmark with TFLiteSettings JSON files: {files}" | ベンチマーク開始時 |
| M-03 | INFO | "Accuracy benchmark result for {target}: {result}." | ベンチマーク完了時 |
| M-04 | ERROR | "Failed to complete accuracy benchmark." | ベンチマーク全体の失敗時 |
| M-05 | ERROR | "No TFLiteSettings file provided." | tfliteSettingsJsonFilesがnullまたは空の場合 |
| M-06 | ERROR | "Failed to create result folder" | 結果フォルダ作成失敗時 |
| M-07 | ERROR | "Failed to load the TFLiteSettings JSON file." | TfLiteSettingsリスト構築で2件未満の場合 |
| M-08 | INFO | "{asset} is not a model file. Skipping." | .tflite以外のファイルをスキップ時 |

## 例外処理

| 例外 | 発生条件 | 処理 |
|------|---------|------|
| IOException | 結果フォルダ作成失敗 | initialize()がfalseを返し、"Failed to complete accuracy benchmark."をログ出力後finish() |
| IOException | assetsフォルダからのモデルファイル一覧取得失敗 | benchmarkDelegatesAndExportReport()がfalseを返す |
| IOException | モデルファイルのオープン失敗 | エラーログを出力し、falseを返す |
| IOException | モデル別結果フォルダ作成失敗 | エラーログを出力し、falseを返す |

## 備考

- 本Activityは`android:noHistory="true"`が設定されており、タスク履歴に残らない
- minSdkVersion: 23、targetSdkVersion: 33
- BenchmarkAccuracyImplはBenchmarkAccuracyインターフェースを実装している
- 精度ベンチマークの判定結果は以下の3段階：
  - PASS: テストターゲットデリゲートが全モデルの埋め込みメトリクス閾値をパスした場合
  - PASS_WITH_WARNING: テストターゲットデリゲートと参照デリゲートの両方が閾値を超過した場合
  - FAIL: テストターゲットデリゲートが少なくとも1つのモデルで閾値を下回り、かつ少なくとも1つの参照デリゲートが全モデルでパスした場合
- BenchmarkAccuracyImpl.benchmark()メソッド内でactivity.finish()が呼ばれるため、BenchmarkAccuracyActivity自体にはfinish()呼び出しがない
- レイテンシベンチマーク（No.12）とは異なり、--args引数は受け付けない
- ネイティブライブラリ: `delegate_performance_benchmark`（レイテンシベンチマークと共有）
- モデルごとに個別の結果フォルダ（`accuracy/{modelName}/`）が作成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面で扱う主要なデータ構造は、TFLiteSettings JSONファイルとベンチマーク結果（BenchmarkEvent FlatBuffer）である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AndroidManifest.xml | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/AndroidManifest.xml` | BenchmarkAccuracyActivityの宣言、noHistory=true、exported=true、READ/WRITE_EXTERNAL_STORAGE権限を確認（45-52行目） |

**読解のコツ**: BenchmarkLatencyActivityと同一アプリ内で宣言されており、同じ権限とSDK version設定を共有している。

#### Step 2: エントリーポイントを理解する

BenchmarkAccuracyActivityのonCreateがエントリーポイントである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BenchmarkAccuracyActivity.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyActivity.java` | onCreate内でIntent解析→BenchmarkAccuracyImpl生成→benchmark()呼び出しのフローを確認（37-45行目） |

**主要処理フロー**:
1. **38行目**: ログ出力 "Create benchmark accuracy activity."
2. **41行目**: `Intent intent = getIntent()` でIntentを取得
3. **43行目**: `--tflite_settings_files`キーでString[]を取得
4. **44行目**: `new BenchmarkAccuracyImpl().benchmark(this, tfliteSettingsJsonFiles)`で処理委譲

#### Step 3: 実装クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BenchmarkAccuracyImpl.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyImpl.java` | benchmark()→benchmarkInternal()→initialize()→benchmarkDelegatesAndExportReport()の委譲チェーンを確認（67-147行目）。特にactivity.finish()がbenchmark()内で呼ばれる点（73行目）に注意 |

**主要処理フロー**:
- **67-74行目**: benchmark() - Contextからactivityをキャスト、benchmarkInternal()実行、activity.finish()で終了
- **76-82行目**: benchmarkInternal() - initialize()→benchmarkDelegatesAndExportReport()
- **84-147行目**: benchmarkDelegatesAndExportReport() - TfLiteSettings読み込み、assetsからモデルリスト取得、モデルごとに結果フォルダ作成→ベンチマーク実行→レポートエクスポート
- **155-177行目**: initialize() - 入力バリデーション、結果フォルダ作成、ライター追加

#### Step 4: ネイティブブリッジを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DelegatePerformanceBenchmark.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/DelegatePerformanceBenchmark.java` | runAccuracyBenchmark()でのJNI呼び出しとBenchmarkEvent FlatBufferの解析（117-133行目）を確認 |

**主要処理フロー**:
- **117-133行目**: runAccuracyBenchmark() - TfLiteSettingsのバイト配列変換、accuracyBenchmarkNativeRun()のJNI呼び出し、BenchmarkEvent FlatBufferの解析
- **254-255行目**: accuracyBenchmarkNativeRun() ネイティブメソッド宣言

### プログラム呼び出し階層図

```
BenchmarkAccuracyActivity.onCreate()
    |
    +-- getIntent().getExtras()                        [Intent引数取得]
    |
    +-- new BenchmarkAccuracyImpl().benchmark(this, files)
            |
            +-- benchmarkInternal()
            |       |
            |       +-- initialize()
            |       |       +-- DelegatePerformanceBenchmark.createResultFolder()
            |       |       +-- JsonWriter.create() / CsvWriter.create() / HtmlWriter.create()
            |       |
            |       +-- benchmarkDelegatesAndExportReport()
            |               |
            |               +-- DelegatePerformanceBenchmark.loadTfLiteSettingsList()
            |               |       +-- loadTfLiteSettingsJsonNative()   [JNI]
            |               |
            |               +-- [for each .tflite model]
            |               |       +-- DelegatePerformanceBenchmark.createResultFolder()
            |               |       +-- DelegatePerformanceBenchmark.runAccuracyBenchmark()
            |               |       |       +-- accuracyBenchmarkNativeRun()   [JNI]
            |               |       +-- AccuracyBenchmarkReport.parseResults()
            |               |       +-- AccuracyBenchmarkReport.create()
            |               |
            |               +-- report.export()            [CSV/JSON/HTMLレポート出力]
            |
            +-- activity.finish()                          [Activity終了]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Intent Bundle              -->  BenchmarkAccuracyActivity       -->  Logcat (TAG: TfLiteBenchmarkAccuracy)
  --tflite_settings_files        .onCreate()
                                     |
                                BenchmarkAccuracyImpl
                                     |
assets/accuracy/*.tflite   -->  .benchmarkDelegatesAndExport()  -->  delegate_performance_result/accuracy/
                                     |                                  report.csv
                                     |                                  report.json
                                DelegatePerformanceBenchmark             report.html
                                .runAccuracyBenchmark() [JNI]   -->  BenchmarkEvent (FlatBuffer)
                                     |
                                     |                          -->  delegate_performance_result/accuracy/{model}/
                                AccuracyBenchmarkReport                 (モデル別結果)
                                     |
                                activity.finish()               -->  Activity終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BenchmarkAccuracyActivity.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyActivity.java` | ソース | メインActivity。Intent解析とBenchmarkAccuracyImplへの処理委譲 |
| BenchmarkAccuracyImpl.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyImpl.java` | ソース | 精度ベンチマーク実装。初期化・ベンチマーク実行・レポート生成 |
| DelegatePerformanceBenchmark.java | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/DelegatePerformanceBenchmark.java` | ソース | ネイティブJNIブリッジ、TfLiteSettingsロード、結果フォルダ管理 |
| AndroidManifest.xml | `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/AndroidManifest.xml` | 設定 | Activity宣言、権限、SDK version設定 |
