# 画面設計書 2-物体検出画面

## 概要

本ドキュメントは、TF DemoアプリにおけるDetectorActivity（物体検出画面）の画面設計書である。カメラプレビューを表示し、TensorFlowMultiBoxDetectorとObjectTrackerで物体検出・追跡を行う画面について記述する。

### 本画面の処理概要

**業務上の目的・背景**：TensorFlowの物体検出モデルのオンデバイス推論をデモンストレーションするために本画面が必要である。TF Object Detection API（SSD MobileNet v1）、MultiBox、YOLOの3種類の検出モデルに対応し、検出された物体をMultiBoxTrackerでリアルタイム追跡することで、モバイルデバイス上での物体検出の動作を確認・検証する。

**画面へのアクセス方法**：Androidランチャーから直接起動される。AndroidManifest.xmlにてランチャーActivityとして登録されており、アプリアイコンをタップすることでアクセスできる。

**主要な操作・処理内容**：
1. カメラプレビューの表示（Camera2 APIまたは旧Camera APIによるフレーム取得）
2. カメラフレームのYUV→RGB変換およびリサイズ・クロップ処理（デフォルト300x300ピクセル）
3. 物体検出モデルによる推論の実行（TF_OD_API / MULTIBOX / YOLOの3モード対応）
4. 検出結果のフィルタリング（信頼度閾値によるフィルタリング）
5. MultiBoxTrackerによる検出物体の追跡とバウンディングボックスの描画
6. trackingOverlay上での追跡結果の視覚化

**画面遷移**：Androidランチャーから起動される。他の画面への遷移機能は持たない。CameraActivity（抽象基底クラス）を継承し、CameraConnectionFragmentまたはLegacyCameraConnectionFragmentをカメラプレビュー表示に使用する。追跡用レイアウト（camera_connection_fragment_tracking.xml）を使用する。

**権限による表示制御**：カメラ権限（CAMERA）とストレージ権限（WRITE_EXTERNAL_STORAGE）が必要。権限が未付与の場合、権限リクエストダイアログが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 画像変換操作（Image Operations） | 主機能 | カメラフレームの画像リサイズ・クロップ・色空間変換を行い検出モデル入力画像を生成 |
| 81 | TFLite推論エンジン | 主機能 | TF Object Detection API / MultiBox / YOLOモデルによる物体検出推論を実行 |
| 62 | SavedModel保存 | 補助機能 | ssd_mobilenet_v1 / multibox_model / graph-tiny-yolo-vocモデルファイルの読み込み |
| 5 | カメラベース画面（抽象） | 主機能 | CameraActivityを継承しカメラプレビュー・権限管理・フレーム処理の共通基盤機能を利用 |
| 6 | カメラ接続フラグメント | 補助機能 | Camera2 APIによるカメラプレビュー表示をCameraConnectionFragmentに委譲（tracking用レイアウト） |
| 7 | レガシーカメラ接続フラグメント | 補助機能 | Camera2非対応デバイスでのフォールバックとしてLegacyCameraConnectionFragmentを利用 |

## 画面種別

リアルタイム処理画面（カメラプレビュー＋物体検出・追跡結果表示）

## URL/ルーティング

Androidネイティブアプリのため、URLベースのルーティングは存在しない。パッケージ: `org.tensorflow.demo`、クラス: `DetectorActivity`。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| カメラプレビューフレーム | 入力 | YUV_420_888 / YUV420SP | カメラから取得される生の画像フレーム（640x480推奨） |
| RGB変換済みBitmap | 中間 | Bitmap (ARGB_8888) | YUVからRGBに変換されたフルサイズBitmap |
| クロップ済みBitmap | 中間 | Bitmap (ARGB_8888) | モデル入力サイズにリサイズ・クロップされたBitmap |
| luminanceCopy | 中間 | byte[] | 追跡用の輝度データコピー |
| 検出結果リスト | 出力 | List<Classifier.Recognition> | ラベル名・信頼度・位置（RectF）を含む検出結果のリスト |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| カメラプレビュー | TextureView | リアルタイムカメラプレビュー映像 |
| 追跡オーバーレイ | OverlayView (tracking_overlay) | MultiBoxTrackerによるバウンディングボックスとラベルの描画 |
| デバッグ情報（任意） | OverlayView (debug_overlay) | フレームサイズ、クロップサイズ、回転角度、推論時間 |

## イベント仕様

### 1-カメラフレーム取得・物体検出イベント

カメラからフレームが利用可能になった際に自動的にトリガーされる。

処理フロー:
1. tracker.onFrame()でフレーム情報を追跡器に通知
2. computingDetectionフラグで排他制御（検出処理中は新フレームをスキップ）
3. getRgbBytes()によりYUV→RGB変換
4. luminanceCopyに輝度データをコピー
5. frameToCropTransformでcroppedBitmapに変換
6. バックグラウンドスレッドでdetector.recognizeImage()を実行
7. 最小信頼度（TF_OD_API:0.6, MULTIBOX:0.1, YOLO:0.25）でフィルタリング
8. cropToFrameTransformで座標を逆変換
9. tracker.trackResults()に結果を渡して追跡
10. trackingOverlayを再描画

### 2-デバッグモード切り替えイベント

ボリュームキー等を押下するとデバッグモードのON/OFFが切り替わり、オーバーレイにデバッグ情報が表示される。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

## メッセージ仕様

| メッセージID | メッセージ内容 | 種別 | 表示条件 |
|-------------|--------------|------|---------|
| MSG-01 | "Classifier could not be initialized" | エラー | TF OD APIモデルの初期化に失敗した場合（IOException発生時） |
| MSG-02 | "Camera AND storage permission are required for this demo" | 警告 | 権限未付与の場合 |

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| モデル初期化失敗（IOException） | Toastでエラーメッセージを表示し、Activityをfinish()で終了 |
| カメラ権限未付与 | 権限リクエストダイアログを表示 |
| 検出処理中の新フレーム到着 | computingDetectionフラグにより新フレームをスキップし、readyForNextImage()で次フレームを受付可能にする |

## 備考

- デフォルトの検出モード: TF_OD_API（SSD MobileNet v1）
- 検出モデル: `ssd_mobilenet_v1_android_export.pb`（TF_OD_API）、`multibox_model.pb`（MULTIBOX）、`graph-tiny-yolo-voc.pb`（YOLO）
- 入力サイズ: TF_OD_API=300, MULTIBOX=224, YOLO=416
- レイアウト: `activity_camera.xml`（CameraActivity）+ `camera_connection_fragment_tracking.xml`（Fragment）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Classifier.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/Classifier.java` | Recognition内部クラス（ラベル、信頼度、位置RectF）を確認 |

**読解のコツ**: DetectorActivityでは位置情報（getLocation/setLocation）が重要。ClassifierActivityと異なりRectFを含む検出結果が返される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DetectorActivity.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/DetectorActivity.java` | DetectorModeの定義（81-83行目）、onPreviewSizeChosen()でのモデル切り替え（120-240行目）、processImage()での検出・追跡処理（244-331行目） |

**主要処理フロー**:
1. **81-84行目**: DetectorModeのenum定義とデフォルトMODE=TF_OD_API
2. **87-89行目**: 各モード別の最小信頼度閾値定義
3. **129-165行目**: MODEに応じたdetectorの初期化（YOLO/MULTIBOX/TF_OD_API）
4. **245-256行目**: tracker.onFrame()でのフレーム通知
5. **259-263行目**: computingDetectionによる排他制御
6. **281-330行目**: バックグラウンドでの検出・フィルタリング・追跡処理

#### Step 3: 追跡処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MultiBoxTracker.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/tracking/MultiBoxTracker.java` | onFrame()、trackResults()、draw()メソッドの役割 |

### プログラム呼び出し階層図

```
DetectorActivity (extends CameraActivity)
    |
    +-- onPreviewSizeChosen()
    |       +-- MultiBoxTracker()
    |       +-- TensorFlowObjectDetectionAPIModel.create() / TensorFlowMultiBoxDetector.create() / TensorFlowYoloDetector.create()
    |
    +-- processImage()
            +-- tracker.onFrame()
            +-- getRgbBytes() [YUV->RGB変換]
            +-- System.arraycopy() [luminanceCopy]
            +-- Canvas.drawBitmap() [クロップ]
            +-- runInBackground()
                    +-- detector.recognizeImage()
                    +-- cropToFrameTransform.mapRect() [座標逆変換]
                    +-- tracker.trackResults()
                    +-- trackingOverlay.postInvalidate()
```

### データフロー図

```
[入力]                      [処理]                              [出力]

カメラフレーム -----> YUV→RGB変換 -----> リサイズ/クロップ -----> 物体検出推論
(YUV_420_888)      (ImageUtils)       (frameToCropTransform)   (detector)
  640x480                                  300x300                  |
                                                                    v
                                                          List<Recognition>
                                                                    |
                                                      信頼度フィルタリング
                                                                    |
                                                      座標逆変換(cropToFrame)
                                                                    |
                                                      MultiBoxTracker追跡
                                                                    |
                                                      trackingOverlay描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DetectorActivity.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/DetectorActivity.java` | ソース | 物体検出画面の主要Activity |
| CameraActivity.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraActivity.java` | ソース | カメラ処理の抽象基底クラス |
| MultiBoxTracker.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/tracking/MultiBoxTracker.java` | ソース | 物体追跡処理 |
| TensorFlowObjectDetectionAPIModel.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/TensorFlowObjectDetectionAPIModel.java` | ソース | SSD MobileNet検出器 |
| TensorFlowMultiBoxDetector.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/TensorFlowMultiBoxDetector.java` | ソース | MultiBox検出器 |
| TensorFlowYoloDetector.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/TensorFlowYoloDetector.java` | ソース | YOLO検出器 |
| camera_connection_fragment_tracking.xml | `tensorflow/tools/android/test/res/layout/camera_connection_fragment_tracking.xml` | レイアウト | 追跡用Fragmentレイアウト |
