# 画面設計書 7-レガシーカメラ接続フラグメント

## 概要

本ドキュメントは、TF DemoアプリにおけるLegacyCameraConnectionFragment（レガシーカメラ接続フラグメント）の画面設計書である。旧Camera APIを使用してカメラプレビューを表示するFragmentであり、Camera2 API非対応デバイス向けのフォールバックとして機能する。

### 本画面の処理概要

**業務上の目的・背景**：Camera2 APIをサポートしないデバイス（ハードウェアレベルがFULL未満の内蔵カメラ）でもカメラプレビューを表示できるようにするために本クラスが必要である。旧Camera API（android.hardware.Camera）を使用し、CameraConnectionFragmentと同等のプレビュー機能を提供する。

**画面へのアクセス方法**：直接起動されることはなく、CameraActivity.setFragment()でuseCamera2API=falseの場合にコンストラクタで生成される。

**主要な操作・処理内容**：
1. 旧Camera APIによるカメラデバイスのオープン・クローズ管理
2. TextureView上でのカメラプレビュー表示
3. CameraConnectionFragment.chooseOptimalSize()を利用した最適プレビューサイズの選択
4. setPreviewCallbackWithBuffer()によるプレビューフレームデータのコールバック提供
5. 背面カメラの自動選択（getCameraId）
6. 継続的オートフォーカスの設定

**画面遷移**：CameraActivity.setFragment()により配置される。他の画面への遷移機能は持たない。

**権限による表示制御**：カメラ権限はCameraActivity側で管理される。本Fragment自体では権限チェックを行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 画像変換操作（Image Operations） | 主機能 | 旧Camera APIでプレビューフレームを取得しYUVデータをコールバック経由で提供 |

## 画面種別

Fragmentコンポーネント（カメラプレビュー表示・レガシー版）

## URL/ルーティング

Fragmentのため、URLベースのルーティングは存在しない。パッケージ: `org.tensorflow.demo`、クラス: `LegacyCameraConnectionFragment`。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| imageListener | 入力 | Camera.PreviewCallback | プレビューフレーム取得時のコールバック（CameraActivity） |
| layout | 入力 | int | インフレートするレイアウトリソースID |
| desiredSize | 入力 | Size | 希望するプレビューサイズ |
| プレビューフレーム | 出力 | byte[] (YUV) | コールバック経由で提供されるYUVフレームデータ |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| カメラプレビュー | AutoFitTextureView (texture) | 旧Camera APIによるリアルタイムカメラプレビュー映像 |

## イベント仕様

### 1-SurfaceTexture利用可能イベント（onSurfaceTextureAvailable）

TextureViewのSurfaceTextureが利用可能になった際に呼び出される。

処理フロー:
1. getCameraId()で背面カメラのインデックスを取得
2. Camera.open(index)でカメラデバイスをオープン
3. Camera.Parametersで連続オートフォーカスを設定（FOCUS_MODE_CONTINUOUS_PICTURE対応時）
4. CameraConnectionFragment.chooseOptimalSize()で最適プレビューサイズを選択
5. setPreviewSize()でプレビューサイズを設定
6. setDisplayOrientation(90)で表示回転を設定
7. camera.setPreviewTexture(texture)でプレビュー先テクスチャを設定
8. camera.setPreviewCallbackWithBuffer(imageListener)でフレームコールバックを登録
9. ImageUtils.getYUVByteSize()でコールバックバッファを割り当て
10. textureView.setAspectRatio()でアスペクト比を設定
11. camera.startPreview()でプレビュー開始

### 2-Fragment一時停止イベント（onPause）

stopCamera()でカメラを停止・解放し、stopBackgroundThread()でバックグラウンドスレッドを終了する。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

## メッセージ仕様

本Fragmentではユーザー向けメッセージの表示は行わない。

## 例外処理

| 例外状態 | 処理内容 |
|---------|---------|
| Camera.open()失敗 | 旧Camera APIのため例外ではなくnull返却の可能性あり |
| setPreviewTexture()でのIOException | camera.release()でカメラを解放 |
| BackgroundThread.join()でのInterruptedException | Logger.e()でエラーログ出力 |

## 備考

- 旧Camera API（android.hardware.Camera）を使用
- 背面カメラ（CAMERA_FACING_BACK）を自動選択
- setPreviewCallbackWithBuffer()によるバッファ付きコールバック
- 表示回転は固定で90度（camera.setDisplayOrientation(90)）
- BackgroundThread名: "CameraBackground"
- レイアウト: コンストラクタ引数で指定（camera_connection_fragment.xml等）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LegacyCameraConnectionFragment.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/LegacyCameraConnectionFragment.java` | フィールド変数（40-48行目）: camera, imageListener, desiredSize, layout |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LegacyCameraConnectionFragment.java | 同上 | コンストラクタ（50-55行目）: 3引数（imageListener, layout, desiredSize） |
| 2-2 | LegacyCameraConnectionFragment.java | 同上 | surfaceTextureListener.onSurfaceTextureAvailable（76-113行目）: カメラ初期化のメインフロー |

**主要処理フロー**:
1. **79-80行目**: getCameraId()で背面カメラ取得、Camera.open(index)
2. **83-100行目**: パラメータ設定（オートフォーカス、最適プレビューサイズ、表示回転90度）
3. **106-108行目**: setPreviewCallbackWithBuffer、コールバックバッファ割り当て
4. **110行目**: setAspectRatio(高さ, 幅)（縦向き用に反転）
5. **112行目**: camera.startPreview()

#### Step 3: カメラ停止処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LegacyCameraConnectionFragment.java | 同上 | stopCamera()（198-205行目）: stopPreview→setPreviewCallback(null)→release |

### プログラム呼び出し階層図

```
LegacyCameraConnectionFragment (extends Fragment)
    |
    +-- コンストラクタ(imageListener, layout, desiredSize)
    |
    +-- onResume()
    |       +-- startBackgroundThread()
    |       +-- textureView.isAvailable() → camera.startPreview() / setSurfaceTextureListener()
    |
    +-- surfaceTextureListener.onSurfaceTextureAvailable()
    |       +-- getCameraId() [背面カメラ選択]
    |       +-- Camera.open(index)
    |       +-- Camera.Parameters設定
    |       +-- CameraConnectionFragment.chooseOptimalSize()
    |       +-- camera.setPreviewCallbackWithBuffer(imageListener)
    |       +-- camera.startPreview()
    |
    +-- onPause()
            +-- stopCamera()
            |       +-- camera.stopPreview()
            |       +-- camera.setPreviewCallback(null)
            |       +-- camera.release()
            +-- stopBackgroundThread()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Camera (旧API) -----> setPreviewCallbackWithBuffer ---------> Camera.PreviewCallback
                     (YUV バイト配列)                         (CameraActivity.onPreviewFrame)
                          |                                              |
                          v                                              v
                   SurfaceTexture                                フレームデータ
                   (TextureView表示)                            (byte[] YUV420SP)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LegacyCameraConnectionFragment.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/LegacyCameraConnectionFragment.java` | ソース | 旧Camera APIプレビューFragment |
| CameraConnectionFragment.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/CameraConnectionFragment.java` | ソース | chooseOptimalSize()を提供 |
| AutoFitTextureView.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/AutoFitTextureView.java` | ソース | アスペクト比自動調整TextureView |
| ImageUtils.java | `tensorflow/tools/android/test/src/org/tensorflow/demo/env/ImageUtils.java` | ソース | getYUVByteSize()を提供 |
| camera_connection_fragment.xml | `tensorflow/tools/android/test/res/layout/camera_connection_fragment.xml` | レイアウト | カメラプレビューレイアウト |
